/*
 * Decompiled with CFR 0.152.
 */
package net.mvndicraft.townywaypoints.commands;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.paperlib.PaperLib;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.mvndicraft.townywaypoints.TownyWaypoints;
import net.mvndicraft.townywaypoints.Waypoint;
import net.mvndicraft.townywaypoints.lib.co.aikar.commands.BaseCommand;
import net.mvndicraft.townywaypoints.lib.co.aikar.commands.annotation.CommandAlias;
import net.mvndicraft.townywaypoints.lib.co.aikar.commands.annotation.CommandCompletion;
import net.mvndicraft.townywaypoints.lib.co.aikar.commands.annotation.CommandPermission;
import net.mvndicraft.townywaypoints.lib.co.aikar.commands.annotation.Default;
import net.mvndicraft.townywaypoints.lib.co.aikar.commands.annotation.Description;
import net.mvndicraft.townywaypoints.lib.co.aikar.commands.annotation.Subcommand;
import net.mvndicraft.townywaypoints.lib.co.aikar.commands.annotation.Syntax;
import net.mvndicraft.townywaypoints.settings.Settings;
import net.mvndicraft.townywaypoints.settings.TownyWaypointsSettings;
import net.mvndicraft.townywaypoints.util.LocationUtil;
import net.mvndicraft.townywaypoints.util.Messaging;
import net.mvndicraft.townywaypoints.util.TownBlockMetaDataController;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

@CommandAlias(value="townywaypoints|twaypoints|twp")
public class TownyWaypointsCommand
extends BaseCommand {
    static TownyAPI townyAPI = TownyAPI.getInstance();

    @Default
    @Description(value="Lists the version of the plugin")
    public static void onTownyWaypoints(CommandSender player) {
        player.sendMessage(TownyWaypoints.getInstance().toString());
    }

    @Subcommand(value="reload")
    @CommandPermission(value="townywaypoints.admin")
    @Description(value="Reloads the plugin config and locales.")
    public static void onReload(CommandSender player) {
        Settings.loadConfigAndLang();
        Messaging.sendMsg(player, Translatable.of((String)"townywaypoints_msg_reload", (Object[])new Object[]{TownyWaypoints.getInstance().getName()}));
    }

    @Subcommand(value="set open")
    @Syntax(value="set <property> [<value>]")
    @CommandCompletion(value="@open_statuses @nothing")
    @Description(value="Change which people the plot is open to teleports from.")
    public static void onSetOpen(Player player, String status) {
        if (!player.hasPermission("townywaypoints.admin") && !player.hasPermission("towny.command.town.toggle.public")) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_waypoint_set_open_insufficient_permission"));
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player);
        if (townBlock == null) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_not_in_townblock"));
            return;
        }
        TownBlockMetaDataController.setSdf(townBlock, "townywaypoints_status", status);
        Messaging.sendMsg((CommandSender)player, Translatable.of((String)"msg_status_set", (Object[])new Object[]{status}));
    }

    @Subcommand(value="set spawn")
    @Syntax(value="set <property> <value>")
    @Description(value="Set the block a player gets teleported to on arival for a waypoint plot.")
    public static void onSetSpawn(Player player) {
        if (!player.hasPermission("townywaypoints.admin") && !player.hasPermission("towny.command.town.set.spawn")) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_waypoint_set_spawn_insufficient_permission"));
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player);
        if (townBlock == null) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_not_in_townblock"));
            return;
        }
        Location loc = player.getLocation();
        Messaging.sendMsg((CommandSender)player, Translatable.of((String)"msg_spawn_set", (Object[])new Object[]{loc.toString()}));
        TownBlockMetaDataController.setSpawn(townBlock, loc);
    }

    @Subcommand(value="travel")
    @Syntax(value="<town> <waypoint> <plot name>")
    @CommandCompletion(value="@reachable_waypointed_towns @town_waypoints @waypoint_plot_names @nothing")
    @Description(value="Travel between different waypoints.")
    public static void onTravel(Player player, String townName, String waypointName, String waypointPlotName) {
        Town town = TownyAPI.getInstance().getTown(townName);
        if (town == null) {
            return;
        }
        TownBlock townBlock = null;
        for (TownBlock _townBlock : town.getTownBlocks()) {
            String plotName = _townBlock.getName();
            if (plotName.isEmpty()) {
                plotName = Translatable.of((String)"townywaypoints_plot_unnamed").defaultLocale();
            }
            if (!_townBlock.getType().getName().equals(waypointName) || !plotName.equals(waypointPlotName) && !waypointPlotName.isEmpty()) continue;
            townBlock = _townBlock;
            break;
        }
        if (townBlock == null) {
            return;
        }
        Waypoint waypoint = TownyWaypoints.getWaypoints().get(waypointName);
        double travelcost = waypoint.getTravelCost();
        boolean admin = player.hasPermission("townywaypoints.admin");
        String plotName = townBlock.getName();
        if (plotName.isEmpty()) {
            plotName = Translatable.of((String)"townywaypoints_plot_unnamed").defaultLocale();
        }
        if (!admin && TownyWaypoints.getEconomy().balance("TownyWaypoints", player.getUniqueId()).doubleValue() - travelcost < 0.0) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_waypoint_travel_insufficient_funds", (Object[])new Object[]{plotName, travelcost}));
            return;
        }
        Location loc = TownBlockMetaDataController.getSpawn(townBlock);
        if (loc.getWorld() == null) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_waypoint_spawn_not_set"));
            return;
        }
        if (!TownBlockMetaDataController.hasAccess(townBlock, player) && !admin) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_no_access"));
            return;
        }
        double dist = LocationUtil.getDistance(player, townBlock);
        int maxDist = LocationUtil.getMaxDistance(waypoint);
        if (!admin && dist > (double)maxDist) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_waypoint_travel_too_far", (Object[])new Object[]{townBlock.getName(), maxDist}));
            return;
        }
        TownBlock playerTownBlock = townyAPI.getTownBlock(player);
        if (!admin && (playerTownBlock == null || TownyWaypointsSettings.getPeerToPeer() && !playerTownBlock.getType().getName().equals(waypointName))) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_waypoint_p2p", (Object[])new Object[]{waypointName, waypointName}));
            return;
        }
        Resident res = townyAPI.getResident(player);
        if (res == null) {
            return;
        }
        int cooldown = CooldownTimerTask.getCooldownRemaining((String)player.getName(), (String)"waypoint");
        if (admin || cooldown == 0) {
            TownyWaypoints.getEconomy().withdraw("TownyWaypoints", player.getUniqueId(), BigDecimal.valueOf(travelcost));
            if (admin) {
                Messaging.sendMsg((CommandSender)player, Translatable.of((String)"msg_waypoint_travel_warmup"));
            } else {
                Messaging.sendMsg((CommandSender)player, Translatable.of((String)"msg_waypoint_travel_warmup_cost", (Object[])new Object[]{travelcost}));
            }
            TownyWaypointsCommand.teleport(player, loc, waypoint.travelWithVehicle());
            if (TownyWaypointsSettings.getSplit() != -1.0 && (player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE)) {
                double splitCostNation = travelcost * (1.0 - TownyWaypointsSettings.getSplit());
                double splitCostTown = travelcost * TownyWaypointsSettings.getSplit();
                town.getAccount().deposit(town.hasNation() ? splitCostTown : travelcost, Translatable.of((String)"msg_deposit_reason").toString());
                if (town.hasNation()) {
                    town.getNationOrNull().getAccount().deposit(splitCostNation, Translatable.of((String)"msg_deposit_reason").toString());
                }
            }
            if (!CooldownTimerTask.hasCooldown((String)player.getName(), (String)"waypoint")) {
                CooldownTimerTask.addCooldownTimer((String)player.getName(), (String)"waypoint", (int)TownyWaypointsSettings.getCooldown());
            }
        } else {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_waypoint_travel_cooldown", (Object[])new Object[]{cooldown, townBlock.getName()}));
        }
    }

    @Subcommand(value="travel")
    @Syntax(value="<town> <waypoint> <plot name>")
    @CommandCompletion(value="@reachable_waypointed_towns @town_waypoints @waypoint_plot_names @nothing")
    @Description(value="Travel between different waypoints.")
    public static void onTravel(Player player, String townName, String waypointName) {
        TownyWaypointsCommand.onTravel(player, townName, waypointName, "");
    }

    private static void teleport(@Nonnull Player player, @Nonnull Location loc, boolean travelWithVehicle) {
        boolean needToTpVehicle;
        Entity vehicle = player.getVehicle();
        boolean bl = needToTpVehicle = travelWithVehicle && player.isInsideVehicle() && vehicle != null;
        if (needToTpVehicle) {
            vehicle.eject();
            PaperLib.teleportAsync((Entity)vehicle, (Location)loc, (PlayerTeleportEvent.TeleportCause)PlayerTeleportEvent.TeleportCause.COMMAND);
        }
        townyAPI.requestTeleport(player, loc);
        if (needToTpVehicle) {
            TownyWaypoints.getScheduler().runTask(loc, () -> vehicle.addPassenger((Entity)player));
        }
    }

    @Subcommand(value="list")
    @Syntax(value="<waypoint> <int>")
    @CommandCompletion(value="@waypoints @waypoints_pages @nothing")
    @Description(value="Display the list of waypoints.")
    public static void onList(Player player, String waypointName, Integer page) {
        Location location = player.getLocation();
        List<TownBlock> waypointTownBlocks = TownyAPI.getInstance().getTownBlocks().stream().filter(tb -> tb.getType().getName().equals(waypointName)).filter(TownBlock::hasTown).sorted(Comparator.comparingDouble(tb -> TownBlockMetaDataController.getSpawn(tb).distance(location))).toList();
        if (waypointTownBlocks.isEmpty()) {
            Messaging.sendErrorMsg((CommandSender)player, Translatable.of((String)"msg_err_waypoint_not_found", (Object[])new Object[]{waypointName}));
        } else {
            int maxPage = Math.floorDiv(waypointTownBlocks.size(), 10);
            if (page < 1) {
                page = 1;
            } else if (page > maxPage) {
                page = maxPage;
            }
            String tenValues = waypointTownBlocks.stream().skip(((long)page.intValue() - 1L) * 10L).limit(10L).map(tb -> tb.getTownOrNull().getName() + " " + tb.getName() + " " + (int)TownBlockMetaDataController.getSpawn(tb).distance(location) + "m" + (TownBlockMetaDataController.hasAccess(tb, player) ? " (accessible)" : "")).collect(Collectors.joining("\n"));
            String message = page + "/" + maxPage + "\n" + tenValues;
            Messaging.sendMsg((CommandSender)player, Translatable.of((String)"msg_page", (Object[])new Object[]{message}));
        }
    }

    @Subcommand(value="list")
    @Syntax(value="<waypoint> <int>")
    @CommandCompletion(value="@waypoints @waypoints_pages @nothing")
    @Description(value="Display the list of waypoints.")
    public static void onList(Player player, String waypointName) {
        TownyWaypointsCommand.onList(player, waypointName, 1);
    }
}

