/*
 * Decompiled with CFR 0.152.
 */
package net.mvndicraft.townywaypoints;

import com.google.common.collect.ImmutableList;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockTypeCache;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.Translatable;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import net.milkbowl.vault2.economy.Economy;
import net.mvndicraft.townywaypoints.Waypoint;
import net.mvndicraft.townywaypoints.commands.TownyWaypointsCommand;
import net.mvndicraft.townywaypoints.lib.co.aikar.commands.PaperCommandManager;
import net.mvndicraft.townywaypoints.lib.com.github.Anon8281.universalScheduler.UniversalScheduler;
import net.mvndicraft.townywaypoints.lib.com.github.Anon8281.universalScheduler.scheduling.schedulers.TaskScheduler;
import net.mvndicraft.townywaypoints.listeners.TownyListener;
import net.mvndicraft.townywaypoints.settings.Settings;
import net.mvndicraft.townywaypoints.util.LocationUtil;
import net.mvndicraft.townywaypoints.util.TownBlockMetaDataController;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class TownyWaypoints
extends JavaPlugin {
    public static final String ADMIN_PERMISSION = "townywaypoints.admin";
    protected static final ConcurrentHashMap<String, Waypoint> waypoints = new ConcurrentHashMap();
    private static TownyWaypoints instance;
    private static Economy economy;
    private static TaskScheduler scheduler;
    private static final String BIOME_TAGS_KEY = "allowed_biome_tags";
    private static final String BIOME_KEY = "allowed_biomes";

    public static TownyWaypoints getInstance() {
        return instance;
    }

    public static Economy getEconomy() {
        return economy;
    }

    public static TaskScheduler getScheduler() {
        return scheduler;
    }

    public static ConcurrentHashMap<String, Waypoint> getWaypoints() {
        return waypoints;
    }

    public static void loadWaypoints() {
        File waypointsDataFile = new File(instance.getDataFolder(), "waypoints.yml");
        if (!waypointsDataFile.exists()) {
            instance.saveResource("waypoints.yml", true);
        }
        YamlConfiguration waypointsData = YamlConfiguration.loadConfiguration((File)waypointsDataFile);
        Set waypointsConfig = waypointsData.getKeys(false);
        waypointsConfig.forEach(arg_0 -> TownyWaypoints.lambda$loadWaypoints$0((FileConfiguration)waypointsData, arg_0));
    }

    private static Waypoint createWaypoint(ConfigurationSection config) {
        return new Waypoint(config.getString("name"), config.getString("mapKey"), config.getDouble("cost"), config.getDouble("travel_cost"), config.getInt("max"), config.getBoolean("sea"), config.getBoolean("travel_with_vehicle"), config.getString("permission"), config.getInt("max_distance"), config.contains(BIOME_TAGS_KEY) ? config.getStringList(BIOME_TAGS_KEY) : new ArrayList(), config.contains(BIOME_KEY) ? config.getStringList(BIOME_KEY) : new ArrayList<String>());
    }

    public void onEnable() {
        PluginManager plugMan = Bukkit.getPluginManager();
        if (!this.setupEconomy()) {
            this.getLogger().severe("Disabled due to no Vault dependency found!");
            plugMan.disablePlugin((Plugin)this);
            return;
        }
        Settings.loadConfigAndLang();
        PaperCommandManager manager = new PaperCommandManager((Plugin)instance);
        manager.registerCommand(new TownyWaypointsCommand());
        manager.getCommandCompletions().registerAsyncCompletion("reachable_waypointed_towns", c -> {
            Player player = c.getContextValue(Player.class, 0);
            ArrayList towns = new ArrayList();
            TownyAPI.getInstance().getTowns().forEach(town -> ((ConcurrentHashMap.KeySetView)TownyWaypoints.getWaypoints().keySet()).forEach(waypoint -> {
                if (town.getTownBlockTypeCache().getNumTownBlocks(TownBlockTypeHandler.getType((String)waypoint), TownBlockTypeCache.CacheType.ALL) > 0 && TownBlockMetaDataController.numWaypointsWithAccess(town, player, waypoint) > 0 && LocationUtil.isCloseEnough(player, TownyWaypoints.getWaypoints().get(waypoint), town)) {
                    towns.add(town.getName());
                }
            }));
            return towns;
        });
        manager.getCommandCompletions().registerAsyncCompletion("town_waypoints", c -> {
            Player player = c.getContextValue(Player.class, 0);
            Town town = TownyAPI.getInstance().getTown(c.getContextValue(String.class, 1));
            ArrayList waypoints = new ArrayList();
            if (town == null) {
                return waypoints;
            }
            ((ConcurrentHashMap.KeySetView)TownyWaypoints.getWaypoints().keySet()).forEach(waypoint -> {
                if (town.getTownBlockTypeCache().getNumTownBlocks(TownBlockTypeHandler.getType((String)waypoint), TownBlockTypeCache.CacheType.ALL) > 0 && TownBlockMetaDataController.numWaypointsWithAccess(town, player, waypoint) > 0) {
                    waypoints.add(waypoint);
                }
            });
            return waypoints;
        });
        manager.getCommandCompletions().registerAsyncCompletion("waypoints_pages", c -> {
            Player player = c.getContextValue(Player.class, 0);
            Location location = player.getLocation();
            String waypointName = c.getContextValue(String.class, 1);
            int possibilities = (int)TownyAPI.getInstance().getTownBlocks().stream().filter(tb -> tb.getType().getName().equals(waypointName)).filter(TownBlock::hasTown).sorted(Comparator.comparingDouble(tb -> TownBlockMetaDataController.getSpawn(tb).distance(location))).count();
            int maxPage = Math.floorDiv(possibilities, 10);
            return IntStream.rangeClosed(1, maxPage).mapToObj(String::valueOf).toList();
        });
        manager.getCommandCompletions().registerAsyncCompletion("waypoints", c -> TownyWaypoints.getWaypoints().keySet());
        manager.getCommandCompletions().registerAsyncCompletion("waypoint_plot_names", c -> {
            Player player = c.getContextValue(Player.class, 0);
            Town town = TownyAPI.getInstance().getTown(c.getContextValue(String.class, 1));
            ArrayList plots = new ArrayList();
            if (town == null) {
                return plots;
            }
            town.getTownBlocks().forEach(townBlock -> {
                if (townBlock.getType().getName().equals(c.getContextValue(String.class, 2)) && TownBlockMetaDataController.hasAccess(townBlock, player)) {
                    if (townBlock.getName().equals("")) {
                        plots.add(Translatable.of((String)"townywaypoints_plot_unnamed").defaultLocale());
                    } else {
                        plots.add(townBlock.getName());
                    }
                }
            });
            return plots;
        });
        manager.getCommandCompletions().registerAsyncCompletion("open_statuses", c -> ImmutableList.of((Object)Translatable.of((String)"open_status_all").defaultLocale(), (Object)Translatable.of((String)"open_status_allies").defaultLocale(), (Object)Translatable.of((String)"open_status_nation").translate(), (Object)Translatable.of((String)"open_status_town").translate(), (Object)Translatable.of((String)"open_status_none").translate()));
        TownyListener townyListener = new TownyListener();
        plugMan.registerEvents((Listener)townyListener, (Plugin)instance);
        this.getLogger().info("enabled!");
    }

    public void onLoad() {
        instance = this;
        scheduler = UniversalScheduler.getScheduler((Plugin)instance);
        TownyWaypoints.loadWaypoints();
    }

    public void onDisable() {
        this.getLogger().info("disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp != null) {
                economy = (Economy)rsp.getProvider();
            }
            return true;
        }
        this.getLogger().severe("Vault not found. Please download Vault to use TownyWaypoints.");
        return false;
    }

    public String getVersion() {
        return instance.getPluginMeta().getVersion();
    }

    private static /* synthetic */ void lambda$loadWaypoints$0(FileConfiguration waypointsData, String waypointConfig) {
        ConfigurationSection waypointConfigSection = waypointsData.getConfigurationSection(waypointConfig);
        if (waypointConfigSection == null) {
            return;
        }
        Waypoint waypoint = TownyWaypoints.createWaypoint(waypointConfigSection);
        TownyListener.registerPlot(waypoint.getName(), waypoint.getMapKey(), waypoint.getCost());
        waypoints.put(waypoint.getName(), waypoint);
    }
}

