/*
 * Decompiled with CFR 0.152.
 */
package fr.formiko.mc.biomeutils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBiome;

public class NMSBiomeUtils {
    private static Map<String, net.minecraft.world.level.biome.Biome> allBiomes;

    @Nonnull
    public static Registry<net.minecraft.world.level.biome.Biome> getBiomeRegistry() {
        return ((CraftServer)Bukkit.getServer()).getServer().registryAccess().lookupOrThrow(Registries.BIOME);
    }

    @Nullable
    public static net.minecraft.world.level.biome.Biome getBiome(@Nonnull String key) {
        Holder.Reference ref = NMSBiomeUtils.getBiomeRegistry().get(NMSBiomeUtils.resourceLocation(key)).orElse(null);
        if (ref == null) {
            return null;
        }
        return (net.minecraft.world.level.biome.Biome)ref.value();
    }

    @Nonnull
    public static net.minecraft.world.level.biome.Biome getBiome(@Nonnull Location location) {
        return NMSBiomeUtils.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getWorld());
    }

    @Nonnull
    public static Holder<net.minecraft.world.level.biome.Biome> getBiomeHolder(@Nonnull Location location) {
        return NMSBiomeUtils.getBiomeHolder(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getWorld());
    }

    @Nonnull
    public static net.minecraft.world.level.biome.Biome getBiome(int x, int y, int z, World bukkitWorld) {
        Holder<net.minecraft.world.level.biome.Biome> biomeHolder = NMSBiomeUtils.getBiomeHolder(x, y, z, bukkitWorld);
        return biomeHolder == null ? null : (net.minecraft.world.level.biome.Biome)biomeHolder.value();
    }

    @Nonnull
    public static Holder<net.minecraft.world.level.biome.Biome> getBiomeHolder(int x, int y, int z, @Nonnull World bukkitWorld) {
        ServerLevel nmsWorld = ((CraftWorld)bukkitWorld).getHandle();
        return nmsWorld.getNoiseBiome(x >> 2, y >> 2, z >> 2);
    }

    @Nullable
    public static ResourceLocation getBiomeKey(@Nonnull Location location) {
        net.minecraft.world.level.biome.Biome biome = NMSBiomeUtils.getBiome(location);
        return NMSBiomeUtils.getBiomeRegistry().getKey((Object)biome);
    }

    @Nullable
    public static ResourceLocation getBiomeKey(int x, int y, int z, @Nonnull World bukkitWorld) {
        net.minecraft.world.level.biome.Biome biome = NMSBiomeUtils.getBiome(x, y, z, bukkitWorld);
        return NMSBiomeUtils.getBiomeRegistry().getKey((Object)biome);
    }

    @Nullable
    public static String getBiomeKeyString(Location location) {
        ResourceLocation key = NMSBiomeUtils.getBiomeKey(location);
        return key == null ? null : key.toString();
    }

    @Nullable
    public static String getBiomeKeyString(int x, int y, int z, World bukkitWorld) {
        ResourceLocation key = NMSBiomeUtils.getBiomeKey(x, y, z, bukkitWorld);
        return key == null ? null : key.toString();
    }

    @Nonnull
    public static ResourceLocation resourceLocation(@Nonnull String name) {
        String[] t = name.split(":");
        return ResourceLocation.fromNamespaceAndPath((String)t[0], (String)t[1]);
    }

    public static Biome minecraftToBukkit(net.minecraft.world.level.biome.Biome minecraft) {
        return CraftBiome.minecraftToBukkit((net.minecraft.world.level.biome.Biome)minecraft);
    }

    public static net.minecraft.world.level.biome.Biome bukkitToMinecraft(Biome bukkit) {
        return CraftBiome.bukkitToMinecraft((Biome)bukkit);
    }

    public static Biome minecraftHolderToBukkit(Holder<net.minecraft.world.level.biome.Biome> minecraft) {
        return NMSBiomeUtils.minecraftToBukkit((net.minecraft.world.level.biome.Biome)minecraft.value());
    }

    public static Holder<net.minecraft.world.level.biome.Biome> bukkitToMinecraftHolder(Biome bukkit) {
        return CraftBiome.bukkitToMinecraftHolder((Biome)bukkit);
    }

    public static boolean matchTag(String biomeString, String tagString) {
        if (biomeString == null || tagString == null) {
            return false;
        }
        Holder<net.minecraft.world.level.biome.Biome> biomeHolder = NMSBiomeUtils.getBiomeHolder(biomeString);
        if (biomeHolder == null) {
            return false;
        }
        return NMSBiomeUtils.getBiomeRegistry().getTags().anyMatch(pair -> pair.key().location().toString().equals(tagString) && pair.contains(biomeHolder));
    }

    public static boolean matchTag(Location location, String tagString) {
        return NMSBiomeUtils.matchTag(NMSBiomeUtils.getBiomeKeyString(location), tagString);
    }

    public static boolean matchTag(Block block, String tagString) {
        return NMSBiomeUtils.matchTag(block.getLocation(), tagString);
    }

    @Nullable
    public static ResourceKey<net.minecraft.world.level.biome.Biome> getBiomeResourceKey(@Nonnull String key) {
        net.minecraft.world.level.biome.Biome biome = NMSBiomeUtils.getBiome(key);
        if (biome == null) {
            return null;
        }
        return NMSBiomeUtils.getBiomeRegistry().getResourceKey((Object)biome).orElse(null);
    }

    @Nullable
    public static Holder<net.minecraft.world.level.biome.Biome> getBiomeHolder(String key) {
        return NMSBiomeUtils.getBiomeRegistry().get(NMSBiomeUtils.resourceLocation(key)).orElse(null);
    }

    @Nonnull
    public static Map<String, net.minecraft.world.level.biome.Biome> getAllBiomes() {
        if (allBiomes == null) {
            Registry<net.minecraft.world.level.biome.Biome> biomeRegistry = NMSBiomeUtils.getBiomeRegistry();
            allBiomes = biomeRegistry.stream().collect(Collectors.toMap(biome -> biomeRegistry.getKey(biome).toString(), biome -> biome));
        }
        return allBiomes;
    }

    @Nonnull
    public static Set<String> getAllBiomesKeyStringMatchingTag(String tag) {
        return NMSBiomeUtils.getAllBiomes().keySet().stream().filter(biomeKey -> NMSBiomeUtils.matchTag(biomeKey, tag)).collect(Collectors.toSet());
    }

    public static void setCustomBiome(String newBiomeName, Chunk chunk, boolean refresh) {
        Holder<net.minecraft.world.level.biome.Biome> biomeHolder = NMSBiomeUtils.getBiomeHolder(newBiomeName);
        ServerLevel w = ((CraftWorld)chunk.getWorld()).getHandle();
        for (int x = 0; x <= 15; ++x) {
            for (int z = 0; z <= 15; ++z) {
                for (int y = 0; y <= chunk.getWorld().getMaxHeight(); ++y) {
                    NMSBiomeUtils.setCustomBiome(chunk.getX() * 16 + x, y, chunk.getZ() * 16 + z, (Level)w, biomeHolder);
                }
            }
        }
        if (refresh) {
            chunk.getWorld().refreshChunk(chunk.getX(), chunk.getZ());
        }
    }

    public static void setCustomBiome(String newBiomeName, Chunk chunk) {
        NMSBiomeUtils.setCustomBiome(newBiomeName, chunk, true);
    }

    public static void setCustomBiome(String newBiomeName, Location location, boolean refresh) {
        NMSBiomeUtils.setCustomBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), (Level)((CraftWorld)location.getWorld()).getHandle(), NMSBiomeUtils.getBiomeHolder(newBiomeName));
        if (refresh) {
            location.getWorld().refreshChunk(location.getChunk().getX(), location.getChunk().getZ());
        }
    }

    public static void setCustomBiome(String newBiomeName, Location location) {
        NMSBiomeUtils.setCustomBiome(newBiomeName, location, true);
    }

    public static void setCustomBiome(String newBiomeName, int x, int y, int z, World world, boolean refresh) {
        NMSBiomeUtils.setCustomBiome(newBiomeName, new Location(world, (double)x, (double)y, (double)z), refresh);
    }

    public static void setCustomBiome(String newBiomeName, int x, int y, int z, World world) {
        NMSBiomeUtils.setCustomBiome(newBiomeName, x, y, z, world, true);
    }

    private static void setCustomBiome(int x, int y, int z, Level w, Holder<net.minecraft.world.level.biome.Biome> bb) {
        ChunkAccess chunk;
        BlockPos pos = new BlockPos(x, 0, z);
        if (w.isLoaded(pos) && (chunk = w.getChunk(pos)) != null) {
            chunk.setBiome(x >> 2, y >> 2, z >> 2, bb);
        }
    }

    @Nullable
    public static Biome getBukkitBiome(String name) {
        try {
            return Biome.valueOf((String)name.split(":")[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nonnull
    public static String normalizeBiomeName(@Nonnull String name) {
        if (!((String)(name = ((String)name).toLowerCase())).contains(":")) {
            name = "minecraft:" + (String)name;
        }
        return name;
    }

    @Nonnull
    public static List<String> normalizeBiomeNameList(@Nonnull List<String> nameList) {
        return nameList.stream().map(NMSBiomeUtils::normalizeBiomeName).toList();
    }
}

