/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.commands;

import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.equip.RemoveEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.daleks.DalekEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.k9.K9Equipment;
import me.eccentric_nz.tardisweepingangels.monsters.toclafane.ToclafaneEquipment;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.PlayerInventory;

public class DisguiseCommand {
    private final TARDIS plugin;

    public DisguiseCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void disguise(CommandSender sender, String mon, String o, String uid) {
        Monster monster;
        String upper = mon.toUpperCase(Locale.ROOT);
        try {
            monster = Monster.valueOf(upper);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_INVALID");
            return;
        }
        Player player = null;
        if (sender instanceof ConsoleCommandSender) {
            if (uid.isEmpty()) {
                this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_UUID");
                return;
            }
            UUID uuid = UUID.fromString(uid);
            player = this.plugin.getServer().getPlayer(uuid);
        }
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player == null) {
            this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_UUID");
            return;
        }
        if (!o.equalsIgnoreCase("on") && !o.equalsIgnoreCase("off")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.MONSTERS, "TWA_ON_OFF");
            return;
        }
        PlayerInventory inv = player.getInventory();
        if (!(!o.equalsIgnoreCase("on") || inv.getBoots().getType().isAir() && inv.getChestplate().getType().isAir() && inv.getHelmet().getType().isAir() && inv.getLeggings().getType().isAir())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.MONSTERS, "WA_ARMOUR");
            return;
        }
        if (o.equalsIgnoreCase("on")) {
            switch (monster) {
                case DALEK: {
                    DalekEquipment.set((LivingEntity)player, true);
                    break;
                }
                case K9: {
                    K9Equipment.set(null, (LivingEntity)player, true);
                    break;
                }
                case TOCLAFANE: {
                    ToclafaneEquipment.set((Entity)player, true);
                    break;
                }
                default: {
                    new Equipper(monster, (LivingEntity)player, true).setHelmetAndInvisibility();
                    break;
                }
            }
        } else {
            RemoveEquipment.set(player);
        }
    }
}

