/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.commands;

import java.util.Collection;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Husk;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Zombie;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffectType;

public class CountCommand {
    private final TARDIS plugin;

    public CountCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void count(CommandSender sender, String mon, World w) {
        String which = mon.toUpperCase(Locale.ROOT);
        String what = "Angels";
        int count = 0;
        if (w == null) {
            this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "COULD_NOT_FIND_WORLD");
            return;
        }
        if (which.equals("G")) {
            what = "Invisible Guardians without Endermen";
            Collection guardians = w.getEntitiesByClass(Guardian.class);
            for (Guardian g : guardians) {
                if (!g.hasPotionEffect(PotionEffectType.INVISIBILITY) || g.getVehicle() != null) continue;
                ++count;
            }
        } else {
            Monster monster;
            try {
                monster = Monster.valueOf(which);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_INVALID");
                return;
            }
            switch (monster) {
                case SILENT: 
                case MIRE: 
                case OMEGA: 
                case DALEK: 
                case HEADLESS_MONK: 
                case SILURIAN: 
                case WEEPING_ANGEL: {
                    what = switch (monster) {
                        case Monster.SILENT -> "Silence";
                        case Monster.MIRE -> "Mire";
                        case Monster.OMEGA -> "Omegans";
                        default -> monster.getName() + "s";
                    };
                    Collection angels = w.getEntitiesByClass(Skeleton.class);
                    for (Skeleton a : angels) {
                        if (!a.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                        ++count;
                    }
                    break;
                }
                case ANGEL_OF_LIBERTY: 
                case THE_BEAST: 
                case CYBERMAN: 
                case EMPTY_CHILD: 
                case SLITHEEN: 
                case VASHTA_NERADA: 
                case CLOCKWORK_DROID: 
                case CYBERSHADE: 
                case OSSIFIED: 
                case SCARECROW: 
                case SMILER: 
                case SONTARAN: 
                case SYCORAX: 
                case ZYGON: {
                    what = switch (monster) {
                        case Monster.ANGEL_OF_LIBERTY -> "Angels of Liberty";
                        case Monster.THE_BEAST -> "The Beast";
                        case Monster.CYBERMAN -> "Cybermen";
                        case Monster.EMPTY_CHILD -> "Empty Children";
                        case Monster.SLITHEEN -> "Slitheen";
                        case Monster.VASHTA_NERADA -> "Vashta Nerada";
                        default -> monster.getName() + "s";
                    };
                    Collection cybermen = w.getEntitiesByClass(Zombie.class);
                    for (Zombie c : cybermen) {
                        if (!c.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                        ++count;
                    }
                    break;
                }
                case DALEK_SEC: 
                case DAVROS: 
                case HATH: 
                case ICE_WARRIOR: 
                case STRAX: {
                    what = monster.equals((Object)Monster.ICE_WARRIOR) ? "Ice Warriors" : monster.getName();
                    Collection fish = w.getEntitiesByClass(PigZombie.class);
                    for (PigZombie h : fish) {
                        if (!h.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                        ++count;
                    }
                    break;
                }
                case JUDOON: 
                case K9: 
                case OOD: {
                    what = monster.equals((Object)Monster.K9) ? "K9s" : monster.getName();
                    Collection galactic_police = w.getEntitiesByClass(Husk.class);
                    for (Husk h : galactic_police) {
                        if (!h.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), TARDISWeepingAngels.PersistentDataTypeUUID)) continue;
                        ++count;
                    }
                    break;
                }
                case SEA_DEVIL: 
                case VAMPIRE_OF_VENICE: {
                    what = monster == Monster.VAMPIRE_OF_VENICE ? "Vampires of Venice" : "Sea Devils";
                    Collection drowned = w.getEntitiesByClass(Drowned.class);
                    for (Drowned d : drowned) {
                        if (!d.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                        ++count;
                    }
                    break;
                }
                case RACNOSS: {
                    what = monster.getName();
                    Collection brutes = w.getEntitiesByClass(PiglinBrute.class);
                    for (PiglinBrute b : brutes) {
                        if (!b.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                        ++count;
                    }
                    break;
                }
                case SUTEKH: {
                    what = monster.getName();
                    Collection strays = w.getEntitiesByClass(Stray.class);
                    for (Stray s : strays) {
                        if (!s.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                        ++count;
                    }
                    break;
                }
                case TOCLAFANE: {
                    what = monster.getName();
                    Collection bees = w.getEntitiesByClass(Bee.class);
                    for (Bee b : bees) {
                        if (b.getPassengers().isEmpty() || !(b.getPassengers().getFirst() instanceof ArmorStand)) continue;
                        ++count;
                    }
                    break;
                }
            }
        }
        this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_COUNT", count, what, w.getName());
    }
}

