/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.command;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetSaves;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetWarpByName;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TVMCommandSave {
    private final TARDIS plugin;

    public TVMCommandSave(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void send(Player player, int page) {
        if (!TARDISPermission.hasPermission(player, "vm.teleport")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_CMD");
            return;
        }
        String uuid = player.getUniqueId().toString();
        if (page == 0) {
            TVMResultSetSaves rss = new TVMResultSetSaves(this.plugin, uuid, 0, 10);
            if (rss.resultSet()) {
                TVMUtils.sendSaveList(player, rss, 1);
            }
        } else {
            if (page < 0) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_INVALID");
                return;
            }
            int start = page * 10 - 10;
            int limit = page * 10;
            TVMResultSetSaves rss = new TVMResultSetSaves(this.plugin, uuid, start, limit);
            if (rss.resultSet()) {
                TVMUtils.sendSaveList(player, rss, page);
            }
        }
    }

    public void save(Player player, String name) {
        String uuid = player.getUniqueId().toString();
        TVMResultSetWarpByName rs = new TVMResultSetWarpByName(this.plugin, uuid, name);
        if (rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_SAVE_EXISTS");
            return;
        }
        Location l = player.getLocation();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("uuid", uuid);
        set.put("save_name", name);
        set.put("world", l.getWorld().getName());
        set.put("x", l.getX());
        set.put("y", l.getY());
        set.put("z", l.getZ());
        set.put("yaw", Float.valueOf(l.getYaw()));
        set.put("pitch", Float.valueOf(l.getPitch()));
        this.plugin.getQueryFactory().doInsert("saves", set);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_SAVE_ADDED", name);
    }
}

