/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.command;

import io.papermc.paper.math.BlockPosition;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMQueryFactory;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TVMCommandCoords {
    private final TARDIS plugin;

    public TVMCommandCoords(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void execute(Player player, World world, BlockPosition pos) {
        int actual;
        String uuid;
        Location l;
        int required;
        if (!TARDISPermission.hasPermission(player, "vm.teleport")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_CMD");
            return;
        }
        Parameters params = new Parameters(player, Flag.getAPIFlags());
        ArrayList<String> worlds = new ArrayList<String>();
        if (world == null) {
            required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.random");
            l = this.plugin.getTardisAPI().getRandomLocation(this.plugin.getTardisAPI().getWorlds(), null, params);
        } else if (pos == null) {
            if (!this.containsIgnoreCase(world.getName(), this.plugin.getTardisAPI().getWorlds())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_TRAVEL");
                return;
            }
            required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.world");
            worlds.add(world.getName());
            l = this.plugin.getTardisAPI().getRandomLocation(worlds, null, params);
        } else {
            required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.coords");
            if (!this.containsIgnoreCase(world.getName(), this.plugin.getTardisAPI().getWorlds())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_TRAVEL");
                return;
            }
            l = new Location(world, (double)pos.blockX(), (double)pos.blockY(), (double)pos.blockZ());
            if (!l.getBlock().getType().equals((Object)Material.AIR)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_ADJUST");
                int highest = l.getWorld().getHighestBlockYAt(l);
                l.setY((double)highest);
            }
        }
        ArrayList<Player> players = new ArrayList<Player>();
        players.add(player);
        if (this.plugin.getVortexConfig().getBoolean("allow.multiple")) {
            for (Entity e : player.getNearbyEntities(0.5, 0.5, 0.5)) {
                if (!(e instanceof Player) || e.getUniqueId().equals(player.getUniqueId())) continue;
                players.add((Player)e);
            }
        }
        if (!TVMUtils.checkTachyonLevel(uuid = player.getUniqueId().toString(), actual = required * players.size())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NEED_TACHYON", actual);
            return;
        }
        if (l != null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_STANDBY");
            while (!l.getChunk().isLoaded()) {
                l.getChunk().load();
            }
            TVMUtils.movePlayers(players, l, player.getLocation().getWorld());
            new TVMQueryFactory(this.plugin).alterTachyons(uuid, -actual);
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PARAMETERS");
        }
    }

    private boolean containsIgnoreCase(String str, List<String> list) {
        for (String s : list) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }
}

