/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.tardisshop.TARDISShopItem;

public class ResultSetUpdateShop {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private List<TARDISShopItem> shopItems;

    public ResultSetUpdateShop(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean getAll() {
        String query = "SELECT * FROM " + this.prefix + "items";
        try (PreparedStatement statement = this.connection.prepareStatement(query);){
            boolean bl;
            block22: {
                ResultSet rs;
                block20: {
                    boolean bl2;
                    block21: {
                        rs = statement.executeQuery();
                        if (!rs.isBeforeFirst()) break block20;
                        this.shopItems = new ArrayList<TARDISShopItem>();
                        while (rs.next()) {
                            this.shopItems.add(new TARDISShopItem(rs.getInt("item_id"), rs.getString("item"), TARDISStaticLocationGetters.getLocationFromBukkitString(rs.getString("location")), rs.getDouble("cost")));
                        }
                        bl2 = true;
                        if (rs == null) break block21;
                        rs.close();
                    }
                    return bl2;
                }
                try {
                    bl = false;
                    if (rs == null) break block22;
                }
                catch (SQLException e) {
                    boolean bl3;
                    block24: {
                        block23: {
                            this.plugin.debug("ResultSet error for items table! " + e.getMessage());
                            bl3 = false;
                            if (rs == null) break block23;
                            rs.close();
                        }
                        if (statement == null) break block24;
                        statement.close();
                    }
                    return bl3;
                    {
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.debug("Error closing items table! " + e.getMessage());
            return true;
        }
    }

    public List<TARDISShopItem> getShopItems() {
        return this.shopItems;
    }
}

