/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardisshop.TARDISShopItem;
import me.eccentric_nz.tardisshop.database.InsertShopItem;
import me.eccentric_nz.tardisshop.database.ResultSetUpdateShop;
import me.eccentric_nz.tardisshop.database.UpdateShopItem;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;

public class ShopUtility {
    public static void add(TARDIS plugin, Player player, String n) {
        String name = n.toLowerCase(Locale.ROOT);
        if (!plugin.getItemsConfig().contains(name)) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "TOO_FEW_ARGS");
        }
        double cost = plugin.getItemsConfig().getDouble(name);
        TARDISShopItem item = new InsertShopItem(plugin).addNamedItem(TARDISStringUtils.capitalise(n), cost);
        plugin.getShopSettings().getSettingItem().put(player.getUniqueId(), item);
        plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "SHOP_ADD", plugin.getShopSettings().getBlockMaterial().toString());
    }

    public static void remove(TARDIS plugin, Player player) {
        plugin.getShopSettings().getRemovingItem().add(player.getUniqueId());
        plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "SHOP_REMOVE", plugin.getShopSettings().getBlockMaterial().toString());
    }

    public static void update(TARDIS plugin) {
        File file = new File(plugin.getDataFolder(), "items.yml");
        try {
            plugin.getItemsConfig().load(file);
        }
        catch (IOException | InvalidConfigurationException e) {
            plugin.debug("Failed to reload items.yml" + e.getMessage());
        }
        ResultSetUpdateShop rs = new ResultSetUpdateShop(plugin);
        if (rs.getAll()) {
            for (TARDISShopItem item : rs.getShopItems()) {
                String lookup = item.item().replace(" ", "_").toLowerCase(Locale.ROOT);
                double cost = plugin.getItemsConfig().getDouble(lookup);
                if (cost == item.cost()) continue;
                new UpdateShopItem(plugin).updateCost(cost, item.id());
                for (Entity e : item.location().getWorld().getNearbyEntities(item.location().add(0.5, 1.0, 0.5), 0.5, 1.0, 0.5)) {
                    if (!(e instanceof TextDisplay)) continue;
                    TextDisplay text = (TextDisplay)e;
                    text.text(((TextComponent)Component.text((String)(item.item() + "\n")).append((Component)Component.text((String)"Cost:", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)String.format(" %.2f", cost), (TextColor)NamedTextColor.WHITE)));
                }
            }
        }
    }
}

