/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.product;

import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardischemistry.product.Product;
import me.eccentric_nz.tardischemistry.product.SparklerMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class SparklerRunnable
implements Runnable {
    private final Player player;
    private final BlockData colour;
    private final long startTime;
    private int taskId;

    public SparklerRunnable(Player player, BlockData colour, long startTime) {
        this.player = player;
        this.colour = colour;
        this.startTime = startTime;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    @Override
    public void run() {
        PlayerInventory inventory = this.player.getInventory();
        ItemStack mainHand = inventory.getItemInMainHand();
        if (this.isSparkler(mainHand)) {
            if (System.currentTimeMillis() < this.startTime + 30000L) {
                Location rightHand = this.getHandLocation();
                this.player.spawnParticle(Particle.DUST, rightHand, 5, (Object)this.colour);
            } else {
                ItemStack sparkler = inventory.getItemInMainHand();
                int amount = sparkler.getAmount();
                if (amount > 1) {
                    ItemMeta im = sparkler.getItemMeta();
                    Product cmd = Product.getByName().get(ComponentUtils.stripColour(im.displayName()));
                    im.setItemModel(cmd.getModel());
                    im.removeEnchant(Enchantment.LOYALTY);
                    im.setEnchantmentGlintOverride(null);
                    sparkler.setItemMeta(im);
                    sparkler.setAmount(amount - 1);
                    inventory.setItemInMainHand(sparkler);
                } else {
                    inventory.setItemInMainHand(null);
                }
                this.player.updateInventory();
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_CREEPER_DEATH, 1.0f, 1.0f);
                Bukkit.getScheduler().cancelTask(this.taskId);
                this.taskId = 0;
            }
        }
    }

    private boolean isSparkler(ItemStack sparkler) {
        if (sparkler == null) {
            return false;
        }
        if (!sparkler.hasItemMeta()) {
            return false;
        }
        ItemMeta im = sparkler.getItemMeta();
        return SparklerMaterial.isCorrectMaterial(sparkler.getType()) && im.hasItemModel() && (im.hasEnchantmentGlintOverride() || sparkler.containsEnchantment(Enchantment.LOYALTY));
    }

    private Location getHandLocation() {
        double degrees = this.toThreeSixty(Location.normalizeYaw((float)this.player.getLocation().getYaw()));
        double yaw = Math.toRadians(degrees);
        double handRadius = 0.55;
        double realXOffset = Math.cos(yaw) * handRadius;
        double realZOffset = Math.sin(yaw) * handRadius;
        double staticYOffset = 1.2;
        return this.player.getLocation().clone().add(realXOffset, staticYOffset, realZOffset);
    }

    private double toThreeSixty(double angle) {
        double threeSixty = angle < 0.0 && angle >= -180.0 ? angle + 360.0 : angle;
        return (threeSixty + 180.0) % 360.0;
    }
}

