/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.product;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.tardischemistry.product.Product;
import me.eccentric_nz.tardischemistry.product.ProductBuilder;
import me.eccentric_nz.tardischemistry.product.ProductInventory;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ProductGUIListener
extends TARDISMenuListener {
    private final List<Integer> slots = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(18), Integer.valueOf(19), Integer.valueOf(20));
    private final List<Integer> pipe = List.of(Integer.valueOf(2), Integer.valueOf(11), Integer.valueOf(20));

    public ProductGUIListener(TARDIS plugin) {
        super(plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onProductMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof ProductInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 26) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                TARDIS.plugin.debug("ProductGUIListener");
                event.setCancelled(true);
            }
            return;
        }
        switch (slot) {
            case 0: 
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 17: {
                event.setCancelled(true);
                this.craft(event.getClickedInventory(), player);
                break;
            }
            case 26: {
                event.setCancelled(true);
                this.close(player);
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private void craft(Inventory inventory, Player player) {
        StringBuilder builder = new StringBuilder();
        for (int slot : this.slots) {
            ItemStack is = inventory.getItem(slot);
            if (is != null) {
                Material material = is.getType();
                if ((material.equals((Object)Material.GLASS_BOTTLE) || material.equals((Object)Material.FEATHER)) && is.hasItemMeta()) {
                    ItemMeta im = is.getItemMeta();
                    if (!im.hasDisplayName()) continue;
                    builder.append(im.displayName()).append(this.pipe.contains(slot) ? "|" : ",");
                    continue;
                }
                builder.append(is.getType()).append(this.pipe.contains(slot) ? "|" : ",");
                continue;
            }
            builder.append("-").append(this.pipe.contains(slot) ? "|" : ",");
        }
        String recipe = builder.substring(0, builder.length() - 1);
        for (Product product : Product.values()) {
            if (!product.getRecipe().equals(recipe)) continue;
            this.craft(product, inventory, player);
            return;
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
    }

    private void craft(Product product, Inventory inventory, Player player) {
        ItemStack crafted = ProductBuilder.getProduct(product);
        inventory.setItem(14, crafted);
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        for (int i : this.slots) {
            inventory.setItem(i, null);
        }
    }
}

