/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.lab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.keys.CureVariant;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionType;

public class CureBrewingListener
implements Listener {
    private final TARDIS plugin;
    private final List<String> elements = List.of("Silver", "Bismuth", "Calcium", "Cobalt");
    private final List<PotionType> cures = List.of(PotionType.AWKWARD, PotionType.MUNDANE, PotionType.THICK, PotionType.WATER);
    private final HashMap<PotionType, List<String>> potions = new HashMap();
    private final Set<UUID> noPickUps = new HashSet<UUID>();

    public CureBrewingListener(TARDIS plugin) {
        this.plugin = plugin;
        this.potions.put(PotionType.FIRE_RESISTANCE, List.of("BLAZE_POWDER", "GLASS_BOTTLE", "MAGMA_CREAM", "NETHER_WART"));
        this.potions.put(PotionType.HEALING, List.of("BLAZE_POWDER", "GLASS_BOTTLE", "GLISTERING_MELON", "NETHER_WART"));
        this.potions.put(PotionType.INVISIBILITY, List.of("BLAZE_POWDER", "FERMENTED_SPIDER_EYE", "GLASS_BOTTLE", "GOLDEN_CARROT", "NETHER_WART"));
        this.potions.put(PotionType.LEAPING, List.of("BLAZE_POWDER", "GLASS_BOTTLE", "NETHER_WART", "RABBIT_FOOT"));
        this.potions.put(PotionType.NIGHT_VISION, List.of("BLAZE_POWDER", "CARROT", "GLASS_BOTTLE", "GOLDEN_CARROT", "NETHER_WART"));
        this.potions.put(PotionType.REGENERATION, List.of("BLAZE_POWDER", "GHAST_TEAR", "GLASS_BOTTLE", "NETHER_WART"));
        this.potions.put(PotionType.SWIFTNESS, List.of("BLAZE_POWDER", "GLASS_BOTTLE", "NETHER_WART", "SUGAR"));
        this.potions.put(PotionType.STRENGTH, List.of("BLAZE_POWDER", "GLASS_BOTTLE", "IRON_INGOT", "NETHER_WART"));
        this.potions.put(PotionType.WATER_BREATHING, List.of("BLAZE_POWDER", "GLASS_BOTTLE", "NETHER_WART", "PUFFERFISH"));
        this.potions.put(PotionType.AWKWARD, List.of("BLAZE_POWDER", "FEATHER:Silver", "GLASS_BOTTLE", "NETHER_WART"));
        this.potions.put(PotionType.MUNDANE, List.of("BLAZE_POWDER", "FEATHER:Cobalt", "GLASS_BOTTLE", "NETHER_WART"));
        this.potions.put(PotionType.THICK, List.of("BLAZE_POWDER", "FEATHER:Calcium", "GLASS_BOTTLE", "NETHER_WART"));
        this.potions.put(PotionType.WATER, List.of("BLAZE_POWDER", "FEATHER:Bismuth", "GLASS_BOTTLE", "NETHER_WART"));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onItemDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getUtils().inTARDISWorld(player)) {
            return;
        }
        Item item = event.getItemDrop();
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            Levelled levelled;
            Location location = item.getLocation();
            Block cauldron = location.getBlock();
            if (item.isOnGround() && cauldron.getType() == Material.WATER_CAULDRON && TARDISPermission.hasPermission(player, "tardis.chemistry.brew") && (levelled = (Levelled)cauldron.getBlockData()).getLevel() > 0) {
                if (!cauldron.getRelative(BlockFace.DOWN).getType().equals((Object)Material.CAMPFIRE)) {
                    return;
                }
                this.noPickUps.add(player.getUniqueId());
                Location particles = cauldron.getLocation().add(0.5, 1.25, 0.5);
                location.getWorld().spawnParticle(Particle.SPLASH, particles, 5);
                player.playSound(player.getLocation(), Sound.BLOCK_BUBBLE_COLUMN_BUBBLE_POP, 1.0f, 1.0f);
                ArrayList<Object> items = new ArrayList<Object>();
                items.add(item.getItemStack().getType().toString());
                for (Entity e : item.getNearbyEntities(1.25, 1.25, 1.25)) {
                    if (!(e instanceof Item)) continue;
                    Item i = (Item)e;
                    ItemStack is = i.getItemStack();
                    Material type = is.getType();
                    if (type.equals((Object)Material.FEATHER) && is.hasItemMeta()) {
                        ItemMeta im = is.getItemMeta();
                        if (im.hasDisplayName() && im.hasItemModel()) {
                            String dn = ComponentUtils.stripColour(im.displayName());
                            items.add(String.valueOf(type) + (String)(this.elements.contains(dn) ? ":" + (String)dn : ""));
                            continue;
                        }
                        items.add(type.toString());
                        continue;
                    }
                    items.add(type.toString());
                }
                boolean isStronger = false;
                boolean isLonger = false;
                boolean isSplash = false;
                boolean isLingering = false;
                if (items.contains("GLOWSTONE_DUST")) {
                    items.remove("GLOWSTONE_DUST");
                    isStronger = true;
                }
                if (items.contains("REDSTONE")) {
                    items.remove("REDSTONE");
                    isLonger = true;
                }
                if (items.contains("GUNPOWDER")) {
                    items.remove("GUNPOWDER");
                    isSplash = true;
                }
                if (items.contains("DRAGON_BREATH")) {
                    items.remove("DRAGON_BREATH");
                    isLingering = true;
                }
                Collections.sort(items);
                for (Map.Entry<PotionType, List<String>> map : this.potions.entrySet()) {
                    boolean upgrade;
                    boolean extend;
                    if (!items.equals(map.getValue())) continue;
                    for (Entity e : item.getNearbyEntities(1.25, 1.25, 1.25)) {
                        if (!(e instanceof Item)) continue;
                        e.remove();
                    }
                    item.remove();
                    int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
                        location.getWorld().spawnParticle(Particle.SPLASH, particles, 5);
                        player.playSound(player.getLocation(), Sound.BLOCK_BUBBLE_COLUMN_BUBBLE_POP, 1.0f, 1.0f);
                    }, 1L, 20L);
                    PotionType potionType = map.getKey();
                    boolean milk = this.cures.contains(potionType);
                    ItemStack is = milk ? ItemStack.of((Material)Material.MILK_BUCKET) : (isSplash && isLingering ? ItemStack.of((Material)Material.LINGERING_POTION) : (isSplash ? ItemStack.of((Material)Material.SPLASH_POTION) : ItemStack.of((Material)Material.POTION)));
                    boolean bl = extend = isLonger && potionType.isExtendable();
                    if (isLonger && !extend) {
                        location.getWorld().dropItem(location.add(0.0, 1.0, 0.0), ItemStack.of((Material)Material.REDSTONE, (int)1));
                    }
                    boolean bl2 = upgrade = isStronger && potionType.isUpgradeable();
                    if (isStronger && !upgrade) {
                        location.getWorld().dropItem(location.add(0.0, 1.0, 0.0), ItemStack.of((Material)Material.GLOWSTONE_DUST, (int)1));
                    }
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        this.plugin.getServer().getScheduler().cancelTask(task);
                        if (milk) {
                            ItemMeta im = is.getItemMeta();
                            switch (potionType) {
                                case AWKWARD: {
                                    im.displayName((Component)ComponentUtils.toWhite("Antidote"));
                                    im.setItemModel(CureVariant.ANTIDOTE.getKey());
                                    break;
                                }
                                case MUNDANE: {
                                    im.displayName((Component)ComponentUtils.toWhite("Elixir"));
                                    im.setItemModel(CureVariant.ELIXIR.getKey());
                                    break;
                                }
                                case THICK: {
                                    im.displayName((Component)ComponentUtils.toWhite("Eye drops"));
                                    im.setItemModel(CureVariant.EYEDROPS.getKey());
                                    break;
                                }
                                default: {
                                    im.displayName((Component)ComponentUtils.toWhite("Tonic"));
                                    im.setItemModel(CureVariant.TONIC.getKey());
                                }
                            }
                            is.setItemMeta(im);
                        } else {
                            PotionMeta pm = (PotionMeta)is.getItemMeta();
                            PotionType potionName = extend && upgrade ? PotionType.valueOf((String)("STRONG_" + ((PotionType)map.getKey()).toString())) : (extend ? PotionType.valueOf((String)("LONG_" + ((PotionType)map.getKey()).toString())) : potionType);
                            pm.setBasePotionType(potionName);
                            is.setItemMeta((ItemMeta)pm);
                        }
                        location.getWorld().dropItem(location.add(0.0, 1.0, 0.0), is);
                        this.noPickUps.remove(player.getUniqueId());
                    }, 400L);
                    break;
                }
                this.noPickUps.remove(player.getUniqueId());
            }
        }, 20L);
    }

    @EventHandler(ignoreCancelled=true)
    public void noPickup(EntityPickupItemEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (this.noPickUps.contains(event.getEntity().getUniqueId())) {
            event.setCancelled(true);
        }
    }
}

