/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility.update;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateTARDISPlugins {
    private final TARDIS plugin;
    private final AtomicBoolean updateInProgress = new AtomicBoolean(false);

    public UpdateTARDISPlugins(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void fetchFromGitHub(final CommandSender sender) {
        if (this.updateInProgress.get()) {
            this.plugin.getMessenger().sendWithColour(sender, TardisModule.TARDIS, "An update is already in progress!", "#FF5555");
            return;
        }
        this.plugin.getMessenger().sendWithColour(sender, TardisModule.TARDIS, "Downloading TARDIS...", "#55FFFF");
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    File update = new File("plugins/update");
                    if (!update.exists() && update.mkdir()) {
                        update.setWritable(true);
                        update.setExecutable(true);
                    }
                    URI uri = URI.create("https://api.github.com/repos/eccentricdevotion/TARDIS/releases/latest");
                    HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
                    HttpRequest request = HttpRequest.newBuilder().GET().uri(uri).header("User-Agent", "TARDISPlugin").build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    JsonObject root = JsonParser.parseString((String)response.body()).getAsJsonObject();
                    JsonObject assets = root.get("assets").getAsJsonArray().get(0).getAsJsonObject();
                    String browser_download_url = assets.get("browser_download_url").getAsString();
                    File dest = new File("plugins/update/TARDIS.jar");
                    URL url = URI.create(browser_download_url).toURL();
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestProperty("User-Agent", "eccentric_nz/TARDIS");
                    try (InputStream input = con.getInputStream();){
                        Files.copy(input, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    new BukkitRunnable(){

                        public void run() {
                            UpdateTARDISPlugins.this.plugin.getMessenger().sendWithColour(sender, TardisModule.TARDIS, "Update success! Restart the server to finish the update.", "#55FFFF");
                        }
                    }.runTask((Plugin)UpdateTARDISPlugins.this.plugin);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new BukkitRunnable(){

                        public void run() {
                            UpdateTARDISPlugins.this.plugin.getMessenger().sendWithColour(sender, TardisModule.TARDIS, "Update failed, " + ex.getMessage(), "#FF5555");
                        }
                    }.runTask((Plugin)UpdateTARDISPlugins.this.plugin);
                }
                finally {
                    UpdateTARDISPlugins.this.updateInProgress.set(false);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }
}

