/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility.protection;

import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.RegionGroup;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.managers.storage.StorageException;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisCompanions;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.protection.TARDISWorldGuardFlag;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISWorldGuardUtils {
    private final TARDIS plugin;
    private WorldGuardPlugin wgp;
    private WorldGuardPlatform wg;

    public TARDISWorldGuardUtils(TARDIS plugin) {
        this.plugin = plugin;
        if (plugin.isWorldGuardOnServer()) {
            this.wgp = (WorldGuardPlugin)plugin.getPM().getPlugin("WorldGuard");
            this.wg = WorldGuard.getInstance().getPlatform();
        }
    }

    public boolean canBuild(Player p, Location l) {
        BlockVector3 vector = BlockVector3.at((double)l.getX(), (double)l.getY(), (double)l.getZ());
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(l.getWorld()));
        ApplicableRegionSet rs = rm.getApplicableRegions(vector);
        return rs.testState((RegionAssociable)this.wgp.wrapPlayer(p), new StateFlag[]{Flags.BUILD});
    }

    public boolean canLand(Player p, Location l) {
        String f = this.plugin.getConfig().getString("preferences.respect_worldguard");
        if (f.toLowerCase(Locale.ROOT).equals("none")) {
            return true;
        }
        if (f.toLowerCase(Locale.ROOT).equals("build")) {
            BlockVector3 vector = BlockVector3.at((double)l.getX(), (double)l.getY(), (double)l.getZ());
            RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(l.getWorld()));
            ApplicableRegionSet rs = rm.getApplicableRegions(vector);
            return rs.testState((RegionAssociable)this.wgp.wrapPlayer(p), new StateFlag[]{Flags.BUILD});
        }
        StateFlag flag = TARDISWorldGuardFlag.getFLAG_LOOKUP().get(f.toLowerCase(Locale.ROOT));
        if (flag == null) {
            return true;
        }
        BlockVector3 vector = BlockVector3.at((double)l.getX(), (double)l.getY(), (double)l.getZ());
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(l.getWorld()));
        ApplicableRegionSet rs = rm.getApplicableRegions(vector);
        return rs.testState(null, new StateFlag[]{flag});
    }

    public void addWGProtection(Player p, Location one, Location two) {
        BlockVector3 b2;
        BlockVector3 b1;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(one.getWorld()));
        int cube = this.plugin.getConfig().getInt("creation.border_radius") * 16;
        if (this.plugin.getConfig().getBoolean("creation.create_worlds")) {
            b1 = BlockVector3.at((int)cube, (int)256, (int)cube);
            b2 = BlockVector3.at((int)(-cube), (int)0, (int)(-cube));
        } else {
            b1 = this.makeBlockVector(one);
            b2 = this.makeBlockVector(two);
        }
        String name = TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(p.getUniqueId()) ? TARDISFloodgate.sanitisePlayerName(p.getName()) : p.getName();
        ProtectedCuboidRegion region = new ProtectedCuboidRegion("TARDIS_" + name, b1, b2);
        DefaultDomain owners = region.getOwners();
        owners.addPlayer(p.getName());
        region.setOwners(owners);
        HashMap<StateFlag, StateFlag.State> flags = new HashMap<StateFlag, StateFlag.State>();
        flags.put(Flags.ENDER_BUILD, StateFlag.State.DENY);
        flags.put(Flags.FIRE_SPREAD, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FIRE, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FLOW, StateFlag.State.DENY);
        flags.put(Flags.LIGHTER, StateFlag.State.DENY);
        flags.put(Flags.USE, StateFlag.State.ALLOW);
        region.setFlags(flags);
        rm.addRegion((ProtectedRegion)region);
        try {
            rm.save();
        }
        catch (StorageException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not create WorldGuard Protection for TARDIS! " + e.getMessage());
        }
    }

    public void addWGProtection(Player player, TIPSData data, org.bukkit.World world, boolean junk) {
        String name;
        UUID uuid;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        BlockVector3 b1 = BlockVector3.at((int)data.getMinX(), (int)0, (int)data.getMinZ());
        BlockVector3 b2 = BlockVector3.at((int)data.getMaxX(), (int)256, (int)data.getMaxZ());
        if (junk) {
            uuid = UUID.fromString("00000000-aaaa-bbbb-cccc-000000000000");
            name = "junk";
        } else {
            uuid = player.getUniqueId();
            name = TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(player.getUniqueId()) ? TARDISFloodgate.sanitisePlayerName(player.getName()) : player.getName();
        }
        String region_id = "TARDIS_" + name;
        ProtectedCuboidRegion region = new ProtectedCuboidRegion(region_id, b1, b2);
        DefaultDomain owners = region.getOwners();
        owners.addPlayer(uuid);
        region.setOwners(owners);
        HashMap<StateFlag, StateFlag.State> flags = new HashMap<StateFlag, StateFlag.State>();
        if (!junk && !this.plugin.getConfig().getBoolean("preferences.open_door_policy")) {
            flags.put(Flags.ENTRY, StateFlag.State.DENY);
        }
        flags.put(Flags.FIRE_SPREAD, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FIRE, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FLOW, StateFlag.State.DENY);
        flags.put(Flags.LIGHTER, StateFlag.State.DENY);
        flags.put(Flags.USE, StateFlag.State.ALLOW);
        region.setFlags(flags);
        rm.addRegion((ProtectedRegion)region);
        if (!junk) {
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "rg flag " + region_id + " exit -w " + world.getName() + " deny");
        }
        try {
            rm.save();
        }
        catch (StorageException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not create WorldGuard Protection for TARDIS! " + e.getMessage());
        }
    }

    public void addWGProtection(UUID uuid, String name, TIPSData data, org.bukkit.World world) {
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        BlockVector3 b1 = BlockVector3.at((int)data.getMinX(), (int)0, (int)data.getMinZ());
        BlockVector3 b2 = BlockVector3.at((int)data.getMaxX(), (int)256, (int)data.getMaxZ());
        String region_id = "TARDIS_" + name;
        ProtectedCuboidRegion region = new ProtectedCuboidRegion(region_id, b1, b2);
        DefaultDomain owners = region.getOwners();
        owners.addPlayer(uuid);
        region.setOwners(owners);
        HashMap<StateFlag, StateFlag.State> flags = new HashMap<StateFlag, StateFlag.State>();
        if (name.length() != 36 && !this.plugin.getConfig().getBoolean("preferences.open_door_policy")) {
            flags.put(Flags.ENTRY, StateFlag.State.DENY);
        }
        flags.put(Flags.FIRE_SPREAD, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FIRE, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FLOW, StateFlag.State.DENY);
        flags.put(Flags.LIGHTER, StateFlag.State.DENY);
        flags.put(Flags.USE, StateFlag.State.ALLOW);
        region.setFlags(flags);
        rm.addRegion((ProtectedRegion)region);
        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "rg flag " + region_id + " exit -w " + world.getName() + " deny");
        try {
            rm.save();
        }
        catch (StorageException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not create WorldGuard Protection for TARDIS! " + e.getMessage());
        }
    }

    public void addRechargerProtection(Player p, String name, Location one, Location two) {
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(one.getWorld()));
        BlockVector3 b1 = this.makeBlockVector(one);
        BlockVector3 b2 = this.makeBlockVector(two);
        ProtectedCuboidRegion region = new ProtectedCuboidRegion("tardis_recharger_" + name, b1, b2);
        DefaultDomain owners = region.getOwners();
        owners.addPlayer(p.getUniqueId());
        region.setOwners(owners);
        HashMap<StateFlag, StateFlag.State> flags = new HashMap<StateFlag, StateFlag.State>();
        flags.put(Flags.TNT, StateFlag.State.DENY);
        flags.put(Flags.CREEPER_EXPLOSION, StateFlag.State.DENY);
        flags.put(Flags.FIRE_SPREAD, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FIRE, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FLOW, StateFlag.State.DENY);
        flags.put(Flags.LIGHTER, StateFlag.State.DENY);
        region.setFlags(flags);
        rm.addRegion((ProtectedRegion)region);
        try {
            rm.save();
        }
        catch (StorageException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not create WorldGuard Protection for recharger! " + e.getMessage());
        }
    }

    public void addRendererProtection(String name, Location one, Location two) {
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(one.getWorld()));
        BlockVector3 b1 = this.makeBlockVector(one);
        BlockVector3 b2 = this.makeBlockVector(two);
        if (TARDISFloodgate.isFloodgateEnabled()) {
            name = TARDISFloodgate.sanitisePlayerName(name);
        }
        ProtectedCuboidRegion region = new ProtectedCuboidRegion("renderer_" + name, b1, b2);
        HashMap<StateFlag, StateFlag.State> flags = new HashMap<StateFlag, StateFlag.State>();
        flags.put(Flags.TNT, StateFlag.State.DENY);
        flags.put(Flags.CREEPER_EXPLOSION, StateFlag.State.DENY);
        flags.put(Flags.FIRE_SPREAD, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FIRE, StateFlag.State.DENY);
        flags.put(Flags.LAVA_FLOW, StateFlag.State.DENY);
        flags.put(Flags.LIGHTER, StateFlag.State.DENY);
        flags.put(Flags.LEAF_DECAY, StateFlag.State.DENY);
        region.setFlags(flags);
        rm.addRegion((ProtectedRegion)region);
        try {
            rm.save();
        }
        catch (StorageException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not create WorldGuard Protection for exterior rendering room! " + e.getMessage());
        }
    }

    public void addPlotWorldProtection(org.bukkit.World world) {
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        if (rm != null && !rm.hasRegion("__global__")) {
            GlobalProtectedRegion globalRegion = new GlobalProtectedRegion("__global__");
            globalRegion.setFlag((Flag)Flags.PASSTHROUGH, (Object)StateFlag.State.DENY);
            rm.addRegion((ProtectedRegion)globalRegion);
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Adding WorldGuard passthrough:deny to plot world.");
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not create WorldGuard Protection for plot world! " + e.getMessage());
            }
        }
    }

    public void addPlotProtection(UUID uuid, Location one, Location two) {
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(one.getWorld()));
        BlockVector3 b1 = this.makeBlockVector(one);
        BlockVector3 b2 = this.makeBlockVector(two);
        ProtectedCuboidRegion region = new ProtectedCuboidRegion("plot_" + uuid.toString(), b1, b2);
        DefaultDomain owners = region.getOwners();
        owners.addPlayer(uuid);
        region.setOwners(owners);
        DefaultDomain members = region.getMembers();
        ResultSetTardisCompanions rst = new ResultSetTardisCompanions(this.plugin);
        if (rst.fromUUID(uuid.toString()) && !rst.getCompanions().isEmpty()) {
            for (String u : rst.getCompanions().split(":")) {
                members.addPlayer(UUID.fromString(u));
            }
        }
        region.setMembers(members);
        rm.addRegion((ProtectedRegion)region);
        try {
            rm.save();
        }
        catch (StorageException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not create WorldGuard region for plot! " + e.getMessage());
        }
    }

    public void removeRegion(org.bukkit.World world, String name) {
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        Set regions = rm.removeRegion("TARDIS_" + name);
        if (regions.isEmpty() && TARDISFloodgate.isFloodgateEnabled()) {
            rm.removeRegion("TARDIS_" + TARDISFloodgate.sanitisePlayerName(name));
        }
        try {
            rm.save();
        }
        catch (StorageException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not remove WorldGuard Protection for TARDIS! " + e.getMessage());
        }
    }

    public void removeRegion(Location l) {
        BlockVector3 vector;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(l.getWorld()));
        ApplicableRegionSet ars = rm.getApplicableRegions(vector = BlockVector3.at((double)l.getX(), (double)l.getY(), (double)l.getZ()));
        if (ars.size() > 0) {
            LinkedList<String> parentNames = new LinkedList<String>();
            LinkedList<String> regions = new LinkedList<String>();
            for (ProtectedRegion pr : ars) {
                String id = pr.getId();
                regions.add(id);
                for (ProtectedRegion parent = pr.getParent(); parent != null; parent = parent.getParent()) {
                    parentNames.add(parent.getId());
                }
            }
            parentNames.forEach(regions::remove);
            rm.removeRegion((String)regions.getFirst());
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not remove WorldGuard Protection for TARDIS! " + e.getMessage());
            }
        } else {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not get WorldGuard region for TARDIS location!");
        }
    }

    public void removeRechargerRegion(String name) {
        org.bukkit.World w = TARDISAliasResolver.getWorldFromAlias(this.plugin.getConfig().getString("rechargers." + name + ".world"));
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(w));
        rm.removeRegion("tardis_recharger_" + name);
        try {
            rm.save();
        }
        catch (StorageException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not remove recharger WorldGuard Protection for recharger! " + e.getMessage());
        }
    }

    public void removeRoomRegion(org.bukkit.World world, String name, String room) {
        String sanitised;
        boolean save = false;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        if (rm.hasRegion(room + "_" + name)) {
            rm.removeRegion(room + "_" + name);
            save = true;
        } else if (TARDISFloodgate.isFloodgateEnabled() && rm.hasRegion(room + "_" + (sanitised = TARDISFloodgate.sanitisePlayerName(name)))) {
            rm.removeRegion(room + "_" + sanitised);
            save = true;
        }
        if (save) {
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not remove WorldGuard Protection for " + room + " room! " + e.getMessage());
            }
        }
    }

    public void addMemberToRegion(org.bukkit.World w, String owner, UUID uuid) {
        String sanitised;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(w));
        ProtectedRegion protectedRegion = null;
        if (rm.hasRegion("TARDIS_" + owner)) {
            protectedRegion = rm.getRegion("TARDIS_" + owner);
        } else if (TARDISFloodgate.isFloodgateEnabled() && rm.hasRegion("TARDIS_" + (sanitised = TARDISFloodgate.sanitisePlayerName(owner)))) {
            protectedRegion = rm.getRegion("TARDIS_" + sanitised);
        }
        if (protectedRegion != null) {
            DefaultDomain members = protectedRegion.getMembers();
            members.addPlayer(uuid);
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not update WorldGuard flags for everyone entry & exit! " + e.getMessage());
            }
        }
    }

    public void removeMemberFromRegion(org.bukkit.World world, String owner, UUID uuid) {
        String sanitised;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        ProtectedRegion protectedRegion = null;
        if (rm.hasRegion("TARDIS_" + owner)) {
            protectedRegion = rm.getRegion("TARDIS_" + owner);
        } else if (TARDISFloodgate.isFloodgateEnabled() && rm.hasRegion("TARDIS_" + (sanitised = TARDISFloodgate.sanitisePlayerName(owner)))) {
            protectedRegion = rm.getRegion("TARDIS_" + sanitised);
        }
        if (protectedRegion != null) {
            DefaultDomain members = protectedRegion.getMembers();
            members.removePlayer(uuid);
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not update WorldGuard flags for everyone entry & exit! " + e.getMessage());
            }
        }
    }

    public void removeAllMembersFromRegion(org.bukkit.World w, String owner, UUID uuid) {
        String sanitised;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(w));
        ProtectedRegion protectedRegion = null;
        if (rm.hasRegion("TARDIS_" + owner)) {
            protectedRegion = rm.getRegion("TARDIS_" + owner);
        } else if (TARDISFloodgate.isFloodgateEnabled() && rm.hasRegion("TARDIS_" + (sanitised = TARDISFloodgate.sanitisePlayerName(owner)))) {
            protectedRegion = rm.getRegion("TARDIS_" + sanitised);
        }
        if (protectedRegion != null) {
            DefaultDomain members = protectedRegion.getMembers();
            members.removeAll();
            members.addPlayer(uuid);
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "rg addmember TARDIS_" + owner + " " + owner + " -w " + w.getName());
        }
    }

    public void updateRegionForNameChange(org.bukkit.World world, String owner, UUID uuid, String which) {
        String region;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        if (rm.hasRegion(region = which + "_" + owner)) {
            ProtectedRegion pr = rm.getRegion(region);
            DefaultDomain owners = pr.getOwners();
            owners.addPlayer(uuid);
            pr.setOwners(owners);
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not update WorldGuard Protection for TARDIS owner name change! " + e.getMessage());
            }
        }
    }

    public void updateRegionForClaim(Location location, UUID uuid) {
        BlockVector3 vector;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(location.getWorld()));
        ApplicableRegionSet ars = rm.getApplicableRegions(vector = BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ()));
        if (ars.size() > 0) {
            ProtectedRegion pr2;
            LinkedList<String> parentNames = new LinkedList<String>();
            LinkedList<String> regions = new LinkedList<String>();
            for (ProtectedRegion pr2 : ars) {
                String id = pr2.getId();
                regions.add(id);
                for (ProtectedRegion parent = pr2.getParent(); parent != null; parent = parent.getParent()) {
                    parentNames.add(parent.getId());
                }
            }
            parentNames.forEach(regions::remove);
            String region = (String)regions.getFirst();
            pr2 = rm.getRegion(region);
            pr2.setFlag((Flag)Flags.ENTRY, (Object)StateFlag.State.DENY);
            DefaultDomain owners = pr2.getOwners();
            owners.addPlayer(uuid);
            pr2.setOwners(owners);
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not update WorldGuard Protection for abandoned TARDIS claim! " + e.getMessage());
            }
        }
    }

    public void lockContainers(org.bukkit.World world, String owner) {
        String sanitised;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        ProtectedRegion region = null;
        if (rm.hasRegion("TARDIS_" + owner)) {
            region = rm.getRegion("TARDIS_" + owner);
        } else if (TARDISFloodgate.isFloodgateEnabled() && rm.hasRegion("TARDIS_" + (sanitised = TARDISFloodgate.sanitisePlayerName(owner)))) {
            region = rm.getRegion("TARDIS_" + sanitised);
        }
        if (region != null) {
            region.setFlag((Flag)Flags.CHEST_ACCESS, (Object)StateFlag.State.DENY);
            region.setFlag((Flag)Flags.CHEST_ACCESS.getRegionGroupFlag(), (Object)RegionGroup.NON_MEMBERS);
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not set WorldGuard CHEST_ACCESS flag to DENY! " + e.getMessage());
            }
        }
    }

    public void unlockContainers(org.bukkit.World world, String owner) {
        String sanitised;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        ProtectedRegion region = null;
        if (rm.hasRegion("TARDIS_" + owner)) {
            region = rm.getRegion("TARDIS_" + owner);
        } else if (TARDISFloodgate.isFloodgateEnabled() && rm.hasRegion("TARDIS_" + (sanitised = TARDISFloodgate.sanitisePlayerName(owner)))) {
            region = rm.getRegion("TARDIS_" + sanitised);
        }
        if (region != null) {
            region.setFlag((Flag)Flags.CHEST_ACCESS, (Object)StateFlag.State.ALLOW);
            region.setFlag((Flag)Flags.CHEST_ACCESS.getRegionGroupFlag(), (Object)RegionGroup.ALL);
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not set WorldGuard CHEST_ACCESS flag to ALLOW! " + e.getMessage());
            }
        }
    }

    public boolean queryContainers(org.bukkit.World world, String owner) {
        String sanitised;
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        ProtectedRegion region = null;
        if (rm.hasRegion("TARDIS_" + owner)) {
            region = rm.getRegion("TARDIS_" + owner);
        } else if (TARDISFloodgate.isFloodgateEnabled() && rm.hasRegion("TARDIS_" + (sanitised = TARDISFloodgate.sanitisePlayerName(owner)))) {
            region = rm.getRegion("TARDIS_" + sanitised);
        }
        if (region != null) {
            StateFlag.State state = (StateFlag.State)region.getFlag((Flag)Flags.CHEST_ACCESS);
            return state == null || state.equals((Object)StateFlag.State.ALLOW);
        }
        return true;
    }

    private BlockVector3 makeBlockVector(Location location) {
        return BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ());
    }

    public ProtectedRegion getRegion(String world, String name) {
        String sanitised;
        org.bukkit.World w = TARDISAliasResolver.getWorldFromAlias(world);
        if (w == null) {
            return null;
        }
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(w));
        ProtectedRegion protectedRegion = null;
        if (rm.hasRegion("TARDIS_" + name)) {
            protectedRegion = rm.getRegion("TARDIS_" + name);
        } else if (TARDISFloodgate.isFloodgateEnabled() && rm.hasRegion("TARDIS_" + (sanitised = TARDISFloodgate.sanitisePlayerName(name)))) {
            protectedRegion = rm.getRegion("TARDIS_" + sanitised);
        }
        return protectedRegion;
    }

    public List<String> getTARDISRegions(org.bukkit.World world) {
        ArrayList<String> regions = new ArrayList<String>();
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
        rm.getRegions().forEach((key, value) -> {
            if (key.contains("tardis")) {
                regions.add((String)key);
            }
        });
        return regions;
    }

    public boolean mobsCanSpawnAtLocation(Location l) {
        RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(l.getWorld()));
        BlockVector3 vector = BlockVector3.at((double)l.getX(), (double)l.getY(), (double)l.getZ());
        ApplicableRegionSet ars = rm.getApplicableRegions(vector);
        return ars.testState(null, new StateFlag[]{Flags.MOB_SPAWNING});
    }

    public void setEntryExitFlags(String world, String owner, boolean allow) {
        org.bukkit.World w = TARDISAliasResolver.getWorldFromAlias(world);
        ProtectedRegion region = null;
        if (w != null) {
            StateFlag.State flag;
            String sanitised;
            RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(w));
            if (rm.hasRegion("TARDIS_" + owner)) {
                region = rm.getRegion("TARDIS_" + owner);
            } else if (TARDISFloodgate.isFloodgateEnabled() && rm.hasRegion("TARDIS_" + (sanitised = TARDISFloodgate.sanitisePlayerName(owner)))) {
                region = rm.getRegion("TARDIS_" + sanitised);
            }
            StateFlag.State state = flag = allow || this.plugin.getConfig().getBoolean("preferences.open_door_policy") ? StateFlag.State.ALLOW : StateFlag.State.DENY;
            if (region != null) {
                Map flags = region.getFlags();
                flags.put(Flags.ENTRY, flag);
                flags.put(Flags.EXIT, flag);
                region.setFlags(flags);
                try {
                    rm.save();
                }
                catch (StorageException e) {
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not update WorldGuard flags for everyone entry & exit! " + e.getMessage());
                }
            }
        }
    }

    public void checkEntryFlags() {
        String world_name = this.plugin.getConfig().getString("creation.default_world_name");
        org.bukkit.World world = this.plugin.getServer().getWorld(world_name);
        if (world != null) {
            StateFlag.State flag = this.plugin.getConfig().getBoolean("preferences.open_door_policy") ? StateFlag.State.ALLOW : StateFlag.State.DENY;
            RegionManager rm = this.wg.getRegionContainer().get((World)new BukkitWorld(world));
            for (ProtectedRegion region : rm.getRegions().values()) {
                if (region.getId().equals("__global__")) continue;
                Map flags = region.getFlags();
                if (region.getId().equals("tardis_junk")) {
                    flags.put(Flags.ENTRY, StateFlag.State.ALLOW);
                    flags.put(Flags.EXIT, StateFlag.State.DENY);
                } else {
                    flags.put(Flags.ENTRY, flag);
                    flags.put(Flags.EXIT, flag);
                }
                region.setFlags(flags);
            }
            try {
                rm.save();
            }
            catch (StorageException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Could not update WorldGuard flags for everyone entry & exit! " + e.getMessage());
            }
        }
    }
}

