/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class TARDISStaticUtils {
    private static final UUID ZERO_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static NamedTextColor policeBoxToNamedTextColor(String preset) {
        switch (preset) {
            case "POLICE_BOX_WHITE": {
                return NamedTextColor.WHITE;
            }
            case "POLICE_BOX_BROWN": 
            case "POLICE_BOX_ORANGE": {
                return NamedTextColor.GOLD;
            }
            case "POLICE_BOX_BLACK": {
                return NamedTextColor.BLACK;
            }
            case "POLICE_BOX_CYAN": {
                return NamedTextColor.DARK_AQUA;
            }
            case "POLICE_BOX_LIGHT_BLUE": {
                return NamedTextColor.BLUE;
            }
            case "POLICE_BOX_GRAY": {
                return NamedTextColor.DARK_GRAY;
            }
            case "POLICE_BOX_GREEN": {
                return NamedTextColor.DARK_GREEN;
            }
            case "POLICE_BOX_PURPLE": {
                return NamedTextColor.DARK_PURPLE;
            }
            case "POLICE_BOX_RED": {
                return NamedTextColor.DARK_RED;
            }
            case "POLICE_BOX_LIGHT_GRAY": {
                return NamedTextColor.GRAY;
            }
            case "POLICE_BOX_LIME": {
                return NamedTextColor.GREEN;
            }
            case "POLICE_BOX_PINK": {
                return NamedTextColor.LIGHT_PURPLE;
            }
            case "POLICE_BOX_MAGENTA": {
                return NamedTextColor.RED;
            }
            case "POLICE_BOX_YELLOW": {
                return NamedTextColor.YELLOW;
            }
        }
        return NamedTextColor.DARK_BLUE;
    }

    public static boolean isOwnerOnline(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rst = new ResultSetTardis(TARDIS.plugin, where, "", false);
        if (rst.resultSet()) {
            Tardis tardis = rst.getTardis();
            if (!tardis.isTardisInit()) {
                return false;
            }
            UUID ownerUUID = tardis.getUuid();
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(TARDIS.plugin, ownerUUID.toString());
            boolean hads_on = true;
            if (rsp.resultSet()) {
                hads_on = rsp.isHadsOn();
            }
            return TARDIS.plugin.getServer().getOfflinePlayer(ownerUUID).isOnline() && hads_on;
        }
        return false;
    }

    public static String getPlayersDirection(Player p, boolean swap) {
        String d = p.getFacing().toString();
        if (swap) {
            d = switch (p.getFacing()) {
                case BlockFace.EAST -> "WEST";
                case BlockFace.NORTH -> "SOUTH";
                case BlockFace.WEST -> "EAST";
                default -> "NORTH";
            };
        }
        return d;
    }

    public static boolean isOceanBiome(Biome b) {
        return b.getKey().getKey().endsWith("ocean");
    }

    public static String getTime(long t) {
        if (t > 0L && t <= 2000L) {
            return "early morning";
        }
        if (t > 2000L && t <= 3500L) {
            return "mid morning";
        }
        if (t > 3500L && t <= 5500L) {
            return "late morning";
        }
        if (t > 5500L && t <= 6500L) {
            return "around noon";
        }
        if (t > 6500L && t <= 8000L) {
            return "afternoon";
        }
        if (t > 8000L && t <= 10000L) {
            return "mid afternoon";
        }
        if (t > 10000L && t <= 12000L) {
            return "late afternoon";
        }
        if (t > 12000L && t <= 14000L) {
            return "twilight";
        }
        if (t > 14000L && t <= 16000L) {
            return "evening";
        }
        if (t > 16000L && t <= 17500L) {
            return "late evening";
        }
        if (t > 17500L && t <= 18500L) {
            return "around midnight";
        }
        if (t > 18500L && t <= 20000L) {
            return "the small hours";
        }
        if (t > 20000L && t <= 22000L) {
            return "the wee hours";
        }
        return "pre-dawn";
    }

    public static boolean isDoorOpen(Block door) {
        BlockData blockData = door.getBlockData();
        if (blockData instanceof Openable) {
            Openable openable = (Openable)blockData;
            return openable.isOpen();
        }
        ItemDisplay display = TARDISDisplayItemUtils.getFromBoundingBox(door);
        if (display != null) {
            TARDISDisplayItem tdi = TARDISDisplayItemUtils.get(display);
            return tdi == TARDISBlockDisplayItem.DOOR_OPEN || tdi == TARDISBlockDisplayItem.DOOR_BOTH_OPEN || tdi == TARDISBlockDisplayItem.BONE_DOOR_OPEN || tdi == TARDISBlockDisplayItem.CLASSIC_DOOR_OPEN || tdi == TARDISBlockDisplayItem.SIDRAT_DOOR_OPEN || TARDISStaticUtils.isCustomDoorOpen(display);
        }
        return false;
    }

    private static boolean isCustomDoorOpen(ItemDisplay display) {
        ItemMeta im = display.getItemStack().getItemMeta();
        if (im.hasItemModel()) {
            return display.getItemStack().getItemMeta().getItemModel().getKey().endsWith("_open");
        }
        if (im.getPersistentDataContainer().has(TARDIS.plugin.getCustomBlockKey())) {
            String str = (String)im.getPersistentDataContainer().get(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING);
            return str.endsWith("_open");
        }
        return false;
    }

    public static void setSign(String loc, int line, String text, Player p) {
        Location l;
        if (!loc.isEmpty() && (l = TARDISStaticLocationGetters.getLocationFromDB(loc)) != null) {
            Chunk chunk = l.getChunk();
            while (!chunk.isLoaded()) {
                chunk.load();
            }
            Block cc = l.getBlock();
            if (Tag.SIGNS.isTagged((Keyed)cc.getType())) {
                Sign sign = (Sign)cc.getState();
                sign.getSide(Side.FRONT).line(line, (Component)Component.text((String)text));
                sign.update();
            } else {
                TARDIS.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "CHAM", " " + text);
            }
        }
    }

    public static boolean isInfested(Material material) {
        return switch (material) {
            case Material.INFESTED_CHISELED_STONE_BRICKS, Material.INFESTED_COBBLESTONE, Material.INFESTED_CRACKED_STONE_BRICKS, Material.INFESTED_MOSSY_STONE_BRICKS, Material.INFESTED_STONE, Material.INFESTED_STONE_BRICKS -> true;
            default -> false;
        };
    }

    public static String getNick(UUID uuid) {
        Essentials essentials;
        if (TARDIS.plugin.getConfig().getBoolean("police_box.use_nick") && (essentials = (Essentials)Bukkit.getServer().getPluginManager().getPlugin("Essentials")) != null) {
            User user = essentials.getUser(uuid);
            String prefix = essentials.getSettings().getNicknamePrefix();
            return ChatColor.stripColor((String)user.getNick()).replace(prefix, "");
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            return offlinePlayer.getName() != null ? offlinePlayer.getName() : "Unknown";
        }
        return player.getName();
    }

    public static String getNick(Player player) {
        Essentials essentials;
        if (TARDIS.plugin.getConfig().getBoolean("police_box.use_nick") && (essentials = (Essentials)Bukkit.getServer().getPluginManager().getPlugin("Essentials")) != null) {
            User user = essentials.getUser(player.getUniqueId());
            String prefix = essentials.getSettings().getNicknamePrefix();
            return ChatColor.stripColor((String)user.getNick()).replace(prefix, "");
        }
        return player.getName();
    }

    public static UUID getZERO_UUID() {
        return ZERO_UUID;
    }

    public static boolean isSonic(ItemStack is) {
        ItemMeta im;
        if (is != null && is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName()) {
            return ComponentUtils.endsWith(im.displayName(), "Sonic Screwdriver");
        }
        return false;
    }

    public static boolean isKeyOrSonic(ItemStack is) {
        ItemMeta im;
        if (is != null && is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName()) {
            String stripped = ComponentUtils.stripColour(im.displayName());
            return stripped.endsWith("TARDIS Key") || stripped.endsWith("Sonic Screwdriver");
        }
        return false;
    }

    public static void warnPreset(UUID uuid) {
        Player player = TARDIS.plugin.getServer().getPlayer(uuid);
        if (player != null) {
            TARDIS.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHAM_BROKEN");
        }
    }

    public static NamedTextColor getColor(Component input) {
        JsonObject object;
        NamedTextColor colour = NamedTextColor.WHITE;
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        String json = (String)serializer.serialize(input);
        if (json.startsWith("{") && (object = JsonParser.parseString((String)json).getAsJsonObject()).has("color")) {
            String c = object.get("color").getAsString();
            for (NamedTextColor ntc : NamedTextColor.NAMES.values()) {
                if (!c.equalsIgnoreCase(ntc.toString())) continue;
                colour = ntc;
            }
        }
        return colour;
    }
}

