/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class TARDISStaticLocationGetters {
    private static final int[] threeByThree = new int[]{-1, 0, 1};

    public static World getWorldFromSplitString(String data) {
        String[] split = data.split(":");
        return Bukkit.getServer().getWorld(split[0]);
    }

    public static Location getLocationFromDB(String s) {
        String[] data = s.split(":");
        World savedw = Bukkit.getServer().getWorld(data[0]);
        if (savedw == null) {
            return null;
        }
        double savedx = TARDISNumberParsers.parseDouble(data[1]);
        double savedy = TARDISNumberParsers.parseDouble(data[2]);
        double savedz = TARDISNumberParsers.parseDouble(data[3]);
        return new Location(savedw, savedx, savedy, savedz);
    }

    public static Location getSpawnLocationFromDB(String s) {
        String[] data = s.split(":");
        World savedw = Bukkit.getServer().getWorld(data[0]);
        if (savedw == null) {
            return null;
        }
        double savedx = TARDISNumberParsers.parseDouble(data[1]) + 0.5;
        double savedy = TARDISNumberParsers.parseDouble(data[2]) + 1.0;
        double savedz = TARDISNumberParsers.parseDouble(data[3]) + 0.5;
        return new Location(savedw, savedx, savedy, savedz);
    }

    public static Location getLocationFromBukkitString(String string) {
        String[] loc_data = string.split(",");
        String[] wStr = loc_data[0].split("=");
        String[] xStr = loc_data[1].split("=");
        String[] yStr = loc_data[2].split("=");
        String[] zStr = loc_data[3].split("=");
        String tmp = wStr[2].substring(0, wStr[2].length() - 1);
        World w = Bukkit.getServer().getWorld(tmp);
        if (w == null) {
            return null;
        }
        double x = xStr[1].contains("E") ? Double.parseDouble(xStr[1]) : TARDISNumberParsers.parseDouble(xStr[1]);
        double y = TARDISNumberParsers.parseDouble(yStr[1]);
        double z = zStr[1].contains("E") ? Double.parseDouble(zStr[1]) : TARDISNumberParsers.parseDouble(zStr[1]);
        return new Location(w, x, y, z);
    }

    public static String makeLocationStr(String w, String x, String y, String z) {
        return "Location{world=CraftWorld{name=" + w + "},x=" + x + ".0,y=" + y + ".0,z=" + z + ".0,pitch=0.0,yaw=0.0}";
    }

    public static String makeLocationStr(World w, int x, int y, int z) {
        return "Location{world=CraftWorld{name=" + w.getName() + "},x=" + x + ".0,y=" + y + ".0,z=" + z + ".0,pitch=0.0,yaw=0.0}";
    }

    public static String makeTetrisLocationString(String world, double x, double y, double z) {
        return String.format("Location{world=CraftWorld{name=%s},x=%.1f,y=%.1f,z=%.1f,pitch=0.0,yaw=0.0}", world, x, y, z);
    }

    public static String makeLocationStr(Location location) {
        return location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ();
    }

    public static Chunk getChunk(String str) {
        String[] split = str.split(":");
        World cw = Bukkit.getServer().getWorld(split[0]);
        int cx = TARDISNumberParsers.parseInt(split[1]);
        int cz = TARDISNumberParsers.parseInt(split[2]);
        return cw.getChunkAt(cx, cz);
    }

    public static int getHighestYin3x3(World world, int x, int z) {
        int y = 0;
        for (int xx : threeByThree) {
            for (int zz : threeByThree) {
                int tmp = world.getHighestBlockYAt(x + xx, z + zz) + 1;
                y = Math.max(tmp, y);
                if (!world.getName().equals("siluria") || !world.getBlockAt(x, y - 1, z).getType().equals((Object)Material.BAMBOO)) continue;
                while (world.getBlockAt(x, --y, z).getType().equals((Object)Material.BAMBOO)) {
                }
            }
        }
        return y;
    }

    public static int getNetherHighest(Location location) {
        Block startBlock = location.getBlock();
        while (!startBlock.getType().isAir()) {
            startBlock = startBlock.getRelative(BlockFace.DOWN);
        }
        while (startBlock.getType().isAir() && startBlock.getLocation().getBlockY() > 30) {
            startBlock = startBlock.getRelative(BlockFace.DOWN);
        }
        return startBlock.getY() + 1;
    }
}

