/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import me.eccentric_nz.TARDIS.TARDIS;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class PerceptionFilter {
    private final TARDIS plugin;
    private Team perceptionFilter;

    public PerceptionFilter(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static void removePerceptionFilter() {
        Scoreboard board = Bukkit.getServer().getScoreboardManager().getMainScoreboard();
        Team perceptionFilter = board.getTeam("PerceptionFilter");
        if (perceptionFilter != null) {
            for (OfflinePlayer olp : Bukkit.getServer().getOfflinePlayers()) {
                String entry;
                if (olp == null || !perceptionFilter.hasEntry(entry = olp.getName())) continue;
                perceptionFilter.removeEntry(entry);
            }
            perceptionFilter.unregister();
        }
    }

    public void createPerceptionFilter() {
        Scoreboard board = this.plugin.getServer().getScoreboardManager().getMainScoreboard();
        this.perceptionFilter = board.getTeam("PerceptionFilter");
        if (this.perceptionFilter == null) {
            this.perceptionFilter = board.registerNewTeam("PerceptionFilter");
            this.perceptionFilter.setCanSeeFriendlyInvisibles(true);
            this.plugin.getServer().getOnlinePlayers().forEach(olp -> this.perceptionFilter.addEntry(olp.getName()));
        }
    }

    public void addPerceptionFilter(Player player) {
        this.perceptionFilter.addEntry(player.getName());
        this.plugin.getServer().getOnlinePlayers().forEach(this::addPlayer);
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 15));
    }

    public void addPlayer(Player player) {
        if (!this.perceptionFilter.hasEntry(player.getName())) {
            this.perceptionFilter.addEntry(player.getName());
        }
    }

    public void removePerceptionFilter(Player player) {
        if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }
}

