/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.skins;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISDisguiseTracker;
import me.eccentric_nz.TARDIS.skins.ArchSkins;
import me.eccentric_nz.TARDIS.skins.Skin;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftPlayer;

public class ChameleonArchDisguiser {
    private final TARDIS plugin;
    private final org.bukkit.entity.Player player;
    private final Field gpField;

    public ChameleonArchDisguiser(TARDIS plugin, org.bukkit.entity.Player player) {
        this.plugin = plugin;
        this.player = player;
        try {
            this.gpField = Player.class.getDeclaredField("gameProfile");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void changeSkin(String name) {
        ServerPlayer entityPlayer = ((CraftPlayer)this.player).getHandle();
        for (org.bukkit.entity.Player p : Bukkit.getOnlinePlayers()) {
            ServerPlayer ep = ((CraftPlayer)p).getHandle();
            if (ep == entityPlayer || p.getWorld() != this.player.getWorld() || !p.canSee(this.player)) continue;
            ep.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(entityPlayer.getUUID())));
        }
        TARDISDisguiseTracker.ARCHED.put(this.player.getUniqueId(), this.player.getName());
        try {
            GameProfile arch = new GameProfile(this.player.getUniqueId(), name);
            this.gpField.setAccessible(true);
            this.gpField.set(entityPlayer, arch);
            this.gpField.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            return;
        }
        Skin random = ArchSkins.DEFAULTS.get(TARDISConstants.RANDOM.nextInt(ArchSkins.DEFAULTS.size()));
        this.plugin.getSkinChanger().set(this.player, random);
    }

    public void resetSkin() {
        ServerPlayer entityPlayer = ((CraftPlayer)this.player).getHandle();
        for (org.bukkit.entity.Player p : Bukkit.getOnlinePlayers()) {
            ServerPlayer ep = ((CraftPlayer)p).getHandle();
            if (ep == entityPlayer || p.getWorld() != this.player.getWorld() || !p.canSee(this.player)) continue;
            ep.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(entityPlayer.getUUID())));
        }
        String oldName = TARDISDisguiseTracker.ARCHED.get(this.player.getUniqueId());
        if (oldName == null || oldName.isEmpty()) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER_WARNING, "Could not get backed up player name from tracker!");
            TARDISDisguiseTracker.ARCHED.remove(this.player.getUniqueId());
            return;
        }
        try {
            GameProfile arch = new GameProfile(this.player.getUniqueId(), oldName);
            Field nameField = arch.getClass().getDeclaredField("name");
            nameField.setAccessible(true);
            nameField.set(arch, oldName);
            nameField.setAccessible(false);
            this.gpField.setAccessible(true);
            this.gpField.set(entityPlayer, arch);
            this.gpField.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            TARDISDisguiseTracker.ARCHED.remove(this.player.getUniqueId());
            return;
        }
        this.plugin.getSkinChanger().remove(this.player);
        TARDISDisguiseTracker.ARCHED.remove(this.player.getUniqueId());
    }
}

