/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.actions;

import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SchematicConvert {
    public void act(TARDIS plugin, Player player, String from, String to) {
        Material lamp;
        TardisLight light;
        try {
            light = TardisLight.valueOf(from.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            light = TardisLight.TENTH;
        }
        try {
            lamp = Material.valueOf((String)to.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            lamp = Material.REDSTONE_LAMP;
        }
        UUID uuid = player.getUniqueId();
        if (!plugin.getTrackerKeeper().getStartLocation().containsKey(uuid)) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_NO_START");
            return;
        }
        if (!plugin.getTrackerKeeper().getEndLocation().containsKey(uuid)) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_NO_END");
            return;
        }
        World w = plugin.getTrackerKeeper().getStartLocation().get(uuid).getWorld();
        String chk_w = plugin.getTrackerKeeper().getEndLocation().get(uuid).getWorld().getName();
        if (!w.getName().equals(chk_w)) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_WORLD");
            return;
        }
        int sx = plugin.getTrackerKeeper().getStartLocation().get(uuid).getBlockX();
        int sy = plugin.getTrackerKeeper().getStartLocation().get(uuid).getBlockY();
        int sz = plugin.getTrackerKeeper().getStartLocation().get(uuid).getBlockZ();
        int ex = plugin.getTrackerKeeper().getEndLocation().get(uuid).getBlockX();
        int ey = plugin.getTrackerKeeper().getEndLocation().get(uuid).getBlockY();
        int ez = plugin.getTrackerKeeper().getEndLocation().get(uuid).getBlockZ();
        int minx = Math.min(sx, ex);
        int maxx = Math.max(sx, ex);
        int miny = Math.min(sy, ey);
        int maxy = Math.max(sy, ey);
        int minz = Math.min(sz, ez);
        int maxz = Math.max(sz, ez);
        for (int l = miny; l <= maxy; ++l) {
            for (int r = minx; r <= maxx; ++r) {
                for (int c = minz; c <= maxz; ++c) {
                    Block b = w.getBlockAt(r, l, c);
                    if (!b.getType().equals((Object)lamp)) continue;
                    TARDISDisplayItemUtils.set(light.getOn(), b, -1);
                    for (BlockFace face : plugin.getGeneralKeeper().getBlockFaces()) {
                        Block block = b.getRelative(face);
                        if (!block.getType().equals((Object)Material.LEVER) && !block.getType().equals((Object)Material.REDSTONE_BLOCK)) continue;
                        block.setType(Material.AIR);
                    }
                }
            }
        }
        plugin.getMessenger().message((CommandSender)player, TardisModule.TARDIS, "Light conversion complete");
    }
}

