/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.smelter;

import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SmelterFuel {
    public void processItems(Inventory inv, List<Chest> fuelChests) {
        int fsize = fuelChests.size();
        if (fsize > 0) {
            HashMap<Material, Integer> fuels = new HashMap<Material, Integer>();
            HashMap<Material, Integer> remainders = new HashMap<Material, Integer>();
            for (ItemStack is : inv.getContents()) {
                Material m;
                if (is == null || !(m = is.getType()).isFuel()) continue;
                int amount = fuels.containsKey(m) ? (Integer)fuels.get(m) + is.getAmount() : is.getAmount();
                fuels.put(m, amount);
                inv.remove(is);
            }
            fuels.forEach((key, value) -> {
                int remainder = value % fsize;
                if (remainder > 0) {
                    remainders.put((Material)key, remainder);
                }
                int distrib = value / fsize;
                fuelChests.forEach(fc -> {
                    HashMap leftoverfuel = fc.getInventory().addItem(new ItemStack[]{ItemStack.of((Material)key, (int)distrib)});
                    if (!leftoverfuel.isEmpty()) {
                        for (ItemStack f : leftoverfuel.values()) {
                            Material fm = f.getType();
                            int amount = remainders.containsKey(fm) ? (Integer)remainders.get(fm) + f.getAmount() : f.getAmount();
                            remainders.put(fm, amount);
                        }
                    }
                });
            });
            remainders.forEach((key, value) -> {
                int max = key.getMaxStackSize();
                if (value > max) {
                    int remainder = value % max;
                    for (int i = 0; i < value / max; ++i) {
                        inv.addItem(new ItemStack[]{ItemStack.of((Material)key, (int)max)});
                    }
                    if (remainder > 0) {
                        inv.addItem(new ItemStack[]{ItemStack.of((Material)key, (int)remainder)});
                    }
                } else {
                    inv.addItem(new ItemStack[]{ItemStack.of((Material)key, (int)value)});
                }
            });
        }
    }
}

