/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games.pong;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetGames;
import me.eccentric_nz.TARDIS.rooms.games.ArcadeData;
import me.eccentric_nz.TARDIS.rooms.games.ArcadeTracker;
import me.eccentric_nz.TARDIS.rooms.games.GameState;
import me.eccentric_nz.TARDIS.rooms.games.GameUtils;
import me.eccentric_nz.TARDIS.rooms.games.pong.Ball;
import me.eccentric_nz.TARDIS.rooms.games.pong.Lines;
import me.eccentric_nz.TARDIS.rooms.games.pong.PaddlePosition;
import me.eccentric_nz.TARDIS.rooms.games.tetris.GameSound;
import me.eccentric_nz.TARDIS.rooms.games.tictactoe.MatchState;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Chunk;
import org.bukkit.Input;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Pong
implements Listener {
    private final TARDIS plugin;
    private final Player player;
    private final boolean[] dirtyRows = new boolean[16];
    int p = 0;
    int t = 0;
    private List<TextDisplay> displayList;
    private Location playerLocation;
    private int id = -1;
    private char[][] CANVAS;
    private GameState state = GameState.INITIALIZING;
    private int tickTask = -1;
    private int paddleY = 8;
    private Ball ball;
    private double period = 58.0;

    public Pong(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.startGame();
    }

    public char[][] getCANVAS() {
        return this.CANVAS;
    }

    public void startGame() {
        this.getRoom(this.player);
        ArcadeTracker.PLAYERS.put(this.player.getUniqueId(), new ArcadeData(GameUtils.centre(this.player.getLocation()), this.player.getAllowFlight(), this, this.id));
        Chunk displayChunk = this.playerLocation.getWorld().getChunkAt(this.playerLocation.getBlock().getRelative(BlockFace.NORTH, 8));
        while (!displayChunk.isLoaded()) {
            displayChunk.load();
        }
        this.player.setFallDistance(0.0f);
        this.player.playSound(this.playerLocation, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        this.player.teleport(this.playerLocation);
        for (Entity e : this.playerLocation.getChunk().getEntities()) {
            if (!(e instanceof ArmorStand)) continue;
            ArmorStand stand = (ArmorStand)e;
            stand.setRotation(180.0f, 0.0f);
            stand.addPassenger((Entity)this.player);
        }
        this.player.setFallDistance(0.0f);
        if (this.state == GameState.INITIALIZING) {
            this.load();
            this.reset();
            this.state = GameState.PLAYING;
        }
    }

    private void getRoom(Player player) {
        ResultSetGames rsg;
        this.id = this.plugin.getTardisAPI().getIdOfTARDISPlayerIsIn(player.getUniqueId());
        if (this.id != -1 && (rsg = new ResultSetGames(this.plugin)).fromId(this.id)) {
            String location = rsg.getPlayerLocation();
            this.playerLocation = TARDISStaticLocationGetters.getLocationFromBukkitString(location);
            this.playerLocation.setYaw(180.0f);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInput(PlayerInputEvent event) {
        Player player = event.getPlayer();
        if (!ArcadeTracker.PLAYERS.containsKey(player.getUniqueId())) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof ArmorStand) {
            Input input = event.getInput();
            if (input.isSneak()) {
                this.abort();
            }
            if (input.isJump()) {
                if (this.tickTask == -1) {
                    this.startTick();
                } else {
                    this.pauseTick();
                }
            }
            if (input.isForward()) {
                this.paddleUp();
            }
            if (input.isBackward()) {
                this.paddleDown();
            }
        }
    }

    private void startTick() {
        long p = Math.max((long)Math.ceil(this.period / 10.0), 1L);
        this.tickTask = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            this.ball.update();
            this.drawDirty();
        }, 10L, p);
    }

    private void pauseTick() {
        this.plugin.getServer().getScheduler().cancelTask(this.tickTask);
        this.tickTask = -1;
    }

    private void paddleUp() {
        --this.paddleY;
        if (this.paddleY < 1) {
            this.paddleY = 1;
        }
        for (int p = 0; p < 16; ++p) {
            this.setChar(p, 1, '\u2007');
        }
        this.setChar(this.paddleY - 1, 1, '\u25a0');
        this.setChar(this.paddleY, 1, '\u25a0');
        this.setChar(this.paddleY + 1, 1, '\u25a0');
    }

    private void paddleDown() {
        ++this.paddleY;
        if (this.paddleY > 14) {
            this.paddleY = 14;
        }
        for (int p = 0; p < 16; ++p) {
            this.setChar(p, 1, '\u2007');
        }
        this.setChar(this.paddleY + 1, 1, '\u25a0');
        this.setChar(this.paddleY, 1, '\u25a0');
        this.setChar(this.paddleY - 1, 1, '\u25a0');
    }

    private void drawDirty() {
        if (this.state == GameState.PLAYING) {
            this.tardisPaddle();
        }
        for (int i = 0; i < this.CANVAS.length; ++i) {
            if (!this.dirtyRows[i]) continue;
            this.displayList.get(i).text((Component)Component.text((String)new String(this.CANVAS[i])));
            this.dirtyRows[i] = false;
        }
    }

    public void setChar(int y, int x, char c) {
        if (this.CANVAS[y][x] != c) {
            this.CANVAS[y][x] = c;
            this.dirtyRows[y] = true;
        }
    }

    private void tardisPaddle() {
        int targetY = this.predictBallY(this.ball);
        int imperfection = 3;
        if (TARDISConstants.RANDOM.nextInt(imperfection) == 0) {
            targetY += TARDISConstants.RANDOM.nextBoolean() ? 1 : -1;
        }
        int clamped = Math.clamp((long)targetY, 1, 14);
        for (int p = 0; p < 16; ++p) {
            this.setChar(p, 27, '\u2007');
        }
        this.setChar(clamped + 1, 27, '\u25a0');
        this.setChar(clamped, 27, '\u25a0');
        this.setChar(clamped - 1, 27, '\u25a0');
    }

    private int predictBallY(Ball ball) {
        if (ball.vx < 0 && ball.x < 27) {
            return ball.y;
        }
        int simY = ball.y;
        int vy = ball.vy;
        return simY += vy;
    }

    protected void reset() {
        if (this.state != GameState.INITIALIZING) {
            this.pauseTick();
        }
        this.CANVAS = new char[16][29];
        for (int i = 0; i < 16; ++i) {
            char[] line = Lines.newCanvas()[i];
            this.CANVAS[i] = line;
        }
        int row = TARDISConstants.RANDOM.nextInt(2, 14);
        this.CANVAS[row][14] = 9679;
        this.paddleY = 8;
        if (this.state == GameState.INITIALIZING) {
            this.ball = new Ball(row, this);
            this.updateScore(MatchState.PLAYER_WON);
        }
        this.ball.y = row;
        this.ball.x = 14;
        int[] d = GameUtils.DIRECTIONS[TARDISConstants.RANDOM.nextInt(GameUtils.DIRECTIONS.length)];
        this.ball.vx = d[0];
        this.ball.vy = d[1];
        Arrays.fill(this.dirtyRows, true);
        this.drawDirty();
        if (this.state != GameState.INITIALIZING && this.state != GameState.GAME_OVER) {
            this.startTick();
        }
    }

    private void load() {
        ResultSetGames rsg = new ResultSetGames(this.plugin);
        if (rsg.fromId(this.id)) {
            this.displayList = new ArrayList<TextDisplay>(16);
            for (UUID uuid : rsg.getPongUUIDs()) {
                TextDisplay display = (TextDisplay)this.playerLocation.getWorld().getEntity(uuid);
                this.displayList.add(display);
                if (display != null) continue;
                this.plugin.debug("Could not get text display -> " + String.valueOf(uuid));
                this.abort();
                return;
            }
        } else {
            this.abort();
        }
    }

    private void abort() {
        this.state = GameState.INITIALIZING;
        this.plugin.getServer().getScheduler().cancelTask(this.tickTask);
        this.reset();
        UUID uuid = this.player.getUniqueId();
        ArcadeData data = ArcadeTracker.PLAYERS.get(uuid);
        this.player.setFallDistance(0.0f);
        this.player.playSound(this.playerLocation, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        this.player.teleport(data.backup());
        this.player.setFallDistance(0.0f);
        this.player.setAllowFlight(data.allowFlight());
        HandlerList.unregisterAll((Listener)this);
        int id = data.id();
        ArcadeTracker.PLAYERS.remove(uuid);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("uuid", uuid.toString());
        this.plugin.getQueryFactory().doInsert("travellers", where);
    }

    public void updateScore(MatchState point) {
        String score = ComponentUtils.stripColour(this.displayList.getLast().text());
        if (!score.equals("Score") && this.state != GameState.INITIALIZING) {
            String[] split = score.split(" \\| ");
            this.p = TARDISNumberParsers.parseInt(split[0].split(" ")[1]);
            this.t = TARDISNumberParsers.parseInt(split[1].split(" ")[1]);
            if (point == MatchState.PLAYER_WON) {
                ++this.p;
                if (this.p == 11) {
                    this.state = GameState.GAME_OVER;
                    this.endGame(MatchState.PLAYER_WON);
                }
            }
            if (point == MatchState.TARDIS_WON) {
                ++this.t;
                if (this.t == 11) {
                    this.state = GameState.GAME_OVER;
                    this.endGame(MatchState.TARDIS_WON);
                }
            }
        }
        this.displayList.getLast().text((Component)Component.text((String)String.format("Player %s | TARDIS %s", this.p, this.t), (TextColor)NamedTextColor.GOLD));
    }

    private void endGame(MatchState match) {
        this.player.playSound(this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.3f, 0.7f);
        new BukkitRunnable(){
            float p = 1.8f;

            public void run() {
                Pong.this.player.playSound(Pong.this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.2f, this.p);
                this.p *= 0.9f;
                if (this.p < 0.5f) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 3L, 1L);
        String who = match == MatchState.TARDIS_WON ? "TARDIS" : "You";
        this.plugin.getMessenger().message((CommandSender)this.player, "Game Over! " + who + " won. Sneak to exit.");
    }

    public void updatePaddle(PaddlePosition position) {
        switch (position) {
            case PLAYER_TOP: 
            case PLAYER_MIDDLE: 
            case PLAYER_BOTTOM: {
                this.setChar(this.paddleY + 1, 1, '\u25a0');
                this.setChar(this.paddleY, 1, '\u25a0');
                this.setChar(this.paddleY - 1, 1, '\u25a0');
                break;
            }
        }
    }

    public void playSound(GameSound gameSound) {
        float volume;
        float pitch = switch (gameSound) {
            case GameSound.PADDLE -> {
                volume = 0.2f;
                yield 0.5f;
            }
            case GameSound.POINT -> {
                volume = 0.3f;
                yield 1.0f;
            }
            case GameSound.BOUNCE -> {
                volume = 0.1f;
                yield 1.6f;
            }
            default -> {
                volume = 0.0f;
                yield 0.0f;
            }
        };
        if (volume > 0.0f) {
            this.player.playSound(this.playerLocation, gameSound.getSound(), volume, pitch);
        }
    }

    public void reducePeriod() {
        this.period -= 3.333;
    }
}

