/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.planets;

import java.util.Locale;
import java.util.logging.Level;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.areas.PlotArea;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardischunkgenerator.worldgen.PlotListener;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WorldLoader {
    private final TARDIS plugin;

    public WorldLoader(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void loadWorld(String world) {
        try {
            World w;
            String e = this.plugin.getPlanetsConfig().getString("planets." + world + ".environment");
            World.Environment environment = World.Environment.valueOf((String)e);
            WorldCreator worldCreator = WorldCreator.name((String)world).environment(environment);
            try {
                WorldType worldType = WorldType.valueOf((String)this.plugin.getPlanetsConfig().getString("planets." + world + ".world_type"));
                worldCreator.type(worldType);
                worldCreator.seed(TARDISConstants.RANDOM.nextLong());
            }
            catch (IllegalArgumentException iae) {
                this.plugin.getMessenger().sendWithColour((CommandSender)this.plugin.getConsole(), TardisModule.DEBUG, "Invalid World Type specified for '" + world + "'! " + iae.getMessage(), "#FF5555");
            }
            String g = this.plugin.getPlanetsConfig().getString("planets." + world + ".generator");
            if (g != null && !g.equalsIgnoreCase("DEFAULT")) {
                worldCreator.generator(g);
            }
            boolean structures = true;
            if (this.plugin.getPlanetsConfig().contains("planets." + world + ".generate_structures")) {
                structures = this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".generate_structures");
            }
            worldCreator.generateStructures(structures);
            boolean hardcore = this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".hardcore");
            if (hardcore) {
                worldCreator.hardcore(true);
            }
            if ((w = worldCreator.createWorld()) != null) {
                String d;
                String gm;
                if (g != null && g.equals("TARDIS:plot")) {
                    this.plugin.getPM().registerEvents((Listener)new PlotListener(this.plugin), (Plugin)this.plugin);
                    if (this.plugin.isWorldGuardOnServer()) {
                        this.plugin.getWorldGuardUtils().addPlotWorldProtection(w);
                    }
                    if (this.plugin.getGeneratorConfig().getBoolean("plot.create_area")) {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new PlotArea(this.plugin, w), 100L);
                    }
                }
                if ((gm = this.plugin.getPlanetsConfig().getString("planets." + world + ".gamemode")) != null && gm.toUpperCase(Locale.ROOT).equals("CREATIVE")) {
                    this.plugin.getTardisHelper().setWorldGameMode(world, GameMode.CREATIVE);
                }
                if (this.plugin.getPlanetsConfig().contains("planets." + world + ".gamerules") && this.plugin.getPlanetsConfig().getConfigurationSection("planets." + world + ".gamerules") != null) {
                    for (String rule : this.plugin.getPlanetsConfig().getConfigurationSection("planets." + world + ".gamerules").getKeys(false)) {
                        GameRule gameRule = (GameRule)Registry.GAME_RULE.get(NamespacedKey.minecraft((String)rule.toLowerCase(Locale.ROOT)));
                        if (gameRule != null) {
                            w.setGameRule(gameRule, (Object)this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".gamerules." + rule));
                            continue;
                        }
                        this.plugin.getLogger().log(Level.WARNING, "Invalid game rule detected in planets.yml!");
                        this.plugin.getLogger().log(Level.WARNING, "The rule was '" + rule + "' in world '" + world + "'.");
                    }
                }
                if ((d = this.plugin.getPlanetsConfig().getString("planets." + world + ".difficulty")) != null) {
                    try {
                        Difficulty difficulty = Difficulty.valueOf((String)d.toUpperCase(Locale.ROOT));
                        w.setDifficulty(difficulty);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().sendWithColour((CommandSender)this.plugin.getConsole(), TardisModule.DEBUG, "Could not load world '" + world + "'! " + e.getMessage(), "#FF5555");
        }
    }
}

