/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.planets;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.GallifreyBlueprintTrade;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.inventory.view.builder.MerchantInventoryViewBuilder;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GallifreyTradeSelectListener
implements Listener {
    private final TARDIS plugin;

    public GallifreyTradeSelectListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onTradeSelect(TradeSelectEvent event) {
        HumanEntity humanEntity;
        int index;
        Merchant merchant = event.getMerchant();
        MerchantRecipe recipe = merchant.getRecipe(index = event.getIndex());
        if (recipe.getUses() == recipe.getMaxUses() && (humanEntity = event.getWhoClicked()) instanceof Player) {
            Player player = (Player)humanEntity;
            ItemMeta im = recipe.getResult().getItemMeta();
            PersistentDataContainer check = im.getPersistentDataContainer();
            if (check.has(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID()) && check.has(this.plugin.getBlueprintKey(), PersistentDataType.STRING)) {
                MerchantRecipe trade = index < 1 ? new GallifreyBlueprintTrade(this.plugin).getRoom() : new GallifreyBlueprintTrade(this.plugin).getConsole();
                ItemMeta meta = trade.getResult().getItemMeta();
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                pdc.set(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)player.getUniqueId());
                List lore = im.lore();
                lore.set(2, Component.text((String)player.getName()));
                im.lore(lore);
                trade.getResult().setItemMeta(im);
                MerchantRecipe newRecipe = new MerchantRecipe(trade.getResult(), 1);
                newRecipe.addIngredient((ItemStack)trade.getIngredients().getFirst());
                merchant.setRecipe(index, newRecipe);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)player).closeInventory(), 1L);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BLUEPRINT_REFRESH");
            }
        }
    }

    @EventHandler
    public void onVillagerTrade(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (!villager.getLocation().getWorld().getName().equals("gallifrey")) {
                return;
            }
            if (!villager.getPersistentDataContainer().has(this.plugin.getBlueprintKey(), PersistentDataType.BOOLEAN)) {
                return;
            }
            event.setCancelled(true);
            Player player = event.getPlayer();
            int i = 0;
            for (MerchantRecipe recipe : villager.getRecipes()) {
                ItemStack result = recipe.getResult();
                if (!result.hasItemMeta()) {
                    return;
                }
                ItemMeta im = result.getItemMeta();
                PersistentDataContainer pdc = im.getPersistentDataContainer();
                if (pdc.has(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID()) && pdc.has(this.plugin.getBlueprintKey(), PersistentDataType.STRING)) {
                    pdc.set(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)player.getUniqueId());
                    List lore = im.lore();
                    lore.set(2, Component.text((String)player.getName()));
                    im.lore(lore);
                    ItemStack is = result.clone();
                    is.setItemMeta(im);
                    MerchantRecipe newRecipe = new MerchantRecipe(is, 1);
                    newRecipe.addIngredient((ItemStack)recipe.getIngredients().getFirst());
                    villager.setRecipe(i, newRecipe);
                }
                ++i;
            }
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                MerchantView merchant = this.getView(villager, player);
                player.openInventory((InventoryView)merchant);
            }, 1L);
        }
    }

    public MerchantView getView(Villager villager, Player player) {
        return (MerchantView)((MerchantInventoryViewBuilder)MenuType.MERCHANT.builder()).merchant((Merchant)villager).checkReachable(true).title(villager.customName()).build((HumanEntity)player);
    }
}

