/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.monitor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.monitor.ColorTypeAdapter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class SnapshotLoader {
    final List<Integer> mapIDsNotToRender = new ArrayList<Integer>();
    private final TARDIS plugin;
    private final Gson gson;

    public SnapshotLoader(TARDIS plugin) {
        this.plugin = plugin;
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter());
        this.gson = builder.create();
    }

    public void load() {
        File folder = new File(String.valueOf(this.plugin.getDataFolder()) + "/monitor_snapshots");
        if (!folder.exists()) {
            folder.mkdir();
            folder.setExecutable(true);
        }
        for (File file : folder.listFiles()) {
            if (!file.isFile() || file.getName().startsWith(".")) continue;
            String[] split = file.getName().split(Pattern.quote("."));
            String name = split[0];
            String[] numSplit = name.split("_");
            final int mapId = Integer.parseInt(numSplit[1]);
            try {
                BufferedReader br = new BufferedReader(new FileReader(file));
                final Color[][] colours = (Color[][])this.gson.fromJson((Reader)br, Color[][].class);
                MapView mapView = Bukkit.getMap((int)mapId);
                if (mapView != null) {
                    mapView.setTrackingPosition(false);
                    for (MapRenderer renderer : mapView.getRenderers()) {
                        mapView.removeRenderer(renderer);
                    }
                    mapView.addRenderer(new MapRenderer(){

                        public void render(MapView mapViewNew, MapCanvas mapCanvas, Player player) {
                            if (!SnapshotLoader.this.mapIDsNotToRender.contains(mapId)) {
                                SnapshotLoader.this.mapIDsNotToRender.add(mapId);
                                for (int x = 0; x < 128; ++x) {
                                    for (int y = 0; y < 128; ++y) {
                                        mapCanvas.setPixelColor(x, y, colours[x][y]);
                                    }
                                }
                            }
                        }
                    });
                    continue;
                }
                file.delete();
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, "Could not render map with id: " + mapId);
            }
        }
    }
}

