/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.mobfarming;

import io.papermc.paper.entity.Leashable;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHappy;
import me.eccentric_nz.TARDIS.mobfarming.types.TARDISHappyGhast;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.Slime;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class HappyGhastUtils {
    public static final NamespacedKey AGE = new NamespacedKey((Plugin)TARDIS.plugin, "happy_ghast_age");
    public static final NamespacedKey BABY = new NamespacedKey((Plugin)TARDIS.plugin, "happy_ghast_baby");
    public static final NamespacedKey HARNESS = new NamespacedKey((Plugin)TARDIS.plugin, "happy_ghast_harness");
    public static final NamespacedKey HEALTH = new NamespacedKey((Plugin)TARDIS.plugin, "happy_ghast_health");
    public static final NamespacedKey HOME = new NamespacedKey((Plugin)TARDIS.plugin, "happy_ghast_home");
    public static final NamespacedKey NAME = new NamespacedKey((Plugin)TARDIS.plugin, "happy_ghast_name");
    public static final NamespacedKey ID = new NamespacedKey((Plugin)TARDIS.plugin, "happy_ghast_id");
    public static final NamespacedKey SLOT = new NamespacedKey((Plugin)TARDIS.plugin, "happy_ghast_slot");
    private static final HashMap<String, Color> COLOURS = new HashMap();

    public static Leashable getLeashed(Entity happy) {
        Location gl = happy.getLocation().clone().add(0.0, -4.0, 0.0);
        UUID hg = happy.getUniqueId();
        for (Entity h : gl.getNearbyEntities(4.0, 4.0, 4.0)) {
            if (!(h instanceof Leashable)) continue;
            Leashable leashable = (Leashable)h;
            try {
                HappyGhast ghast;
                Entity holder = leashable.getLeashHolder();
                if (!(holder instanceof HappyGhast) || !hg.equals((ghast = (HappyGhast)holder).getUniqueId())) continue;
                return leashable;
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        return null;
    }

    public static void setLeashed(Location fence, TARDISHappyGhast happy, BlockFace face) {
        LeashHitch leashHitch = (LeashHitch)fence.getWorld().spawn(fence, LeashHitch.class);
        leashHitch.setFacingDirection(face);
        Slime slime = (Slime)fence.getWorld().spawn(fence.getBlock().getRelative(face).getLocation().add(0.5, 0.5, 0.5), Slime.class);
        slime.setSize(0);
        PersistentDataContainer pdc = slime.getPersistentDataContainer();
        pdc.set(ID, PersistentDataType.INTEGER, (Object)happy.getTardis_id());
        pdc.set(SLOT, PersistentDataType.INTEGER, (Object)happy.getSlotIndex());
        String harness = "";
        if (happy.getHarness().getType().toString().endsWith("HARNESS")) {
            String h = happy.getHarness().getType().toString();
            harness = h.replace("HARNESS", "DYE");
            pdc.set(HARNESS, PersistentDataType.STRING, (Object)h);
        }
        pdc.set(BABY, PersistentDataType.BOOLEAN, (Object)happy.isBaby());
        if (happy.getHome() != null) {
            pdc.set(HOME, PersistentDataType.STRING, (Object)happy.getHome().toString());
        }
        pdc.set(HEALTH, PersistentDataType.DOUBLE, (Object)happy.getHealth());
        pdc.set(AGE, PersistentDataType.INTEGER, (Object)happy.getAge());
        String name = happy.getName();
        if (name != null && !name.isEmpty()) {
            pdc.set(NAME, PersistentDataType.STRING, (Object)name);
        }
        slime.setAI(false);
        slime.setInvisible(true);
        slime.setInvulnerable(true);
        ItemDisplay display = (ItemDisplay)fence.getWorld().spawn(fence.getBlock().getRelative(BlockFace.NORTH).getLocation(), ItemDisplay.class);
        ItemStack dried = ItemStack.of((Material)Material.DRIED_GHAST);
        display.setItemStack(dried);
        slime.addPassenger((Entity)display);
        if (!harness.isEmpty()) {
            TextDisplay text = (TextDisplay)fence.getWorld().spawn(fence.getBlock().getRelative(BlockFace.NORTH).getLocation(), TextDisplay.class);
            text.setBackgroundColor(COLOURS.get(harness));
            text.text((Component)Component.text((String)"    "));
            text.setBillboard(Display.Billboard.VERTICAL);
            slime.addPassenger((Entity)text);
        }
        TARDIS.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)TARDIS.plugin, () -> slime.setLeashHolder((Entity)leashHitch), 2L);
    }

    public static boolean isDockFree(Location dock) {
        for (Entity e : dock.getWorld().getNearbyEntities(dock, 8.0, 8.0, 8.0)) {
            if (!(e instanceof HappyGhast)) continue;
            return false;
        }
        return true;
    }

    public static int getFreeSlotCount(TARDIS plugin, int id) {
        ResultSetHappy rs = new ResultSetHappy(plugin);
        if (rs.fromId(id)) {
            return rs.getFreeSlots();
        }
        return 0;
    }

    public static int nextFreeSlot(TARDIS plugin, int id) {
        ResultSetHappy rs = new ResultSetHappy(plugin);
        if (rs.fromId(id)) {
            return rs.getAvailableIndex();
        }
        return -1;
    }

    public static void setSlotOccupied(TARDIS plugin, int slot, int id) {
        ResultSetHappy rs = new ResultSetHappy(plugin);
        if (rs.fromId(id)) {
            CharSequence[] slots = rs.getSlots().split(",");
            slots[slot] = "1";
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("slots", String.join((CharSequence)",", slots));
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            plugin.getQueryFactory().doSyncUpdate("happy", set, where);
        }
    }

    public static void setSlotUnoccupied(TARDIS plugin, int slot, int id) {
        ResultSetHappy rs = new ResultSetHappy(plugin);
        if (rs.fromId(id)) {
            CharSequence[] slots = rs.getSlots().split(",");
            slots[slot] = "0";
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("slots", String.join((CharSequence)",", slots));
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            plugin.getQueryFactory().doSyncUpdate("happy", set, where);
        }
    }

    static {
        COLOURS.put("WHITE_DYE", Color.WHITE);
        COLOURS.put("ORANGE_DYE", Color.ORANGE);
        COLOURS.put("MAGENTA_DYE", Color.fromRGB((int)13061821));
        COLOURS.put("LIGHT_BLUE_DYE", Color.fromRGB((int)3847130));
        COLOURS.put("YELLOW_DYE", Color.YELLOW);
        COLOURS.put("LIME_DYE", Color.LIME);
        COLOURS.put("PINK_DYE", Color.fromRGB((int)15961002));
        COLOURS.put("GRAY_DYE", Color.GRAY);
        COLOURS.put("LIGHT_GRAY_DYE", Color.fromRGB((int)0x9D9D97));
        COLOURS.put("CYAN_DYE", Color.fromRGB((int)1481884));
        COLOURS.put("PURPLE_DYE", Color.PURPLE);
        COLOURS.put("BLUE_DYE", Color.BLUE);
        COLOURS.put("BROWN_DYE", Color.fromRGB((int)8606770));
        COLOURS.put("GREEN_DYE", Color.GREEN);
        COLOURS.put("RED_DYE", Color.RED);
        COLOURS.put("BLACK_DYE", Color.BLACK);
    }
}

