/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.mapping;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.TARDISData;
import me.eccentric_nz.TARDIS.mapping.TARDISGetter;
import me.eccentric_nz.TARDIS.mapping.TARDISMapper;
import me.eccentric_nz.TARDIS.mapping.TARDISServerListener;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TARDISBlueMap
implements TARDISMapper {
    private final TARDIS plugin;

    public TARDISBlueMap(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void disable() {
    }

    @Override
    public void enable() {
        Plugin bluemap = this.plugin.getPM().getPlugin("BlueMap");
        this.plugin.getPM().registerEvents((Listener)new TARDISServerListener("BlueMap", this), (Plugin)this.plugin);
        if (bluemap != null && bluemap.isEnabled()) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, this::activate, 300L);
        }
    }

    @Override
    public void activate() {
        BlueMapAPI.getInstance().ifPresent(api -> {
            long period = this.plugin.getConfig().getLong("mapping.update_period") * 20L / 3L;
            this.updateMarkerSet(period);
        });
    }

    @Override
    public void updateMarkerSet(long period) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new BlueMapMarkerUpdate(), period);
    }

    private class BlueMapMarkerUpdate
    implements Runnable {
        ArrayList<World> worldsToDo = null;
        List<TARDISData> toDo = null;
        int tardisIndex = 0;
        World curWorld = null;

        private BlueMapMarkerUpdate() {
        }

        @Override
        public void run() {
            if (this.worldsToDo == null) {
                this.worldsToDo = new ArrayList();
                for (String planet : TARDISBlueMap.this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false)) {
                    World world;
                    if (!TARDISBlueMap.this.plugin.getPlanetsConfig().getBoolean("planets." + planet + ".time_travel") || (world = TARDISBlueMap.this.plugin.getServer().getWorld(planet)) == null) continue;
                    this.worldsToDo.add(world);
                }
            }
            while (this.toDo == null) {
                if (this.worldsToDo.isEmpty()) {
                    long delay = TARDISBlueMap.this.plugin.getConfig().getLong("mapping.update_period", 30L) * 20L;
                    TARDISBlueMap.this.updateMarkerSet(delay);
                    break;
                }
                this.curWorld = this.worldsToDo.removeFirst();
                BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)this.curWorld)).ifPresent(w -> {
                    TARDISGetter getter = new TARDISGetter(TARDISBlueMap.this.plugin, this.curWorld);
                    getter.resultSetAsync(results -> {
                        MarkerSet markerSet = new MarkerSet("TARDIS");
                        this.toDo = results;
                        this.tardisIndex = 0;
                        if (this.toDo != null && this.toDo.isEmpty()) {
                            this.toDo = null;
                        } else {
                            int limit = TARDISBlueMap.this.plugin.getConfig().getInt("mapping.updates_per_tick", 10);
                            for (int cnt = 0; cnt < limit; ++cnt) {
                                if (this.tardisIndex >= this.toDo.size()) {
                                    this.toDo = null;
                                    break;
                                }
                                TARDISData data = this.toDo.get(this.tardisIndex);
                                ++this.tardisIndex;
                                String id = this.curWorld.getName() + "/" + data.owner();
                                Location loc = data.location();
                                String label = String.format("%s (TARDIS)", data.owner());
                                String desc = TARDISBlueMap.this.formatInfoWindow(data);
                                POIMarker marker = new POIMarker(label, new Vector3d(loc.getX(), loc.getY(), loc.getZ()));
                                marker.setIcon("https://raw.githubusercontent.com/eccentricdevotion/TARDIS/master/src/main/resources/tardis.png", 0, 0);
                                marker.setDetail(desc);
                                markerSet.put(id, (Marker)marker);
                            }
                        }
                        for (BlueMapMap map : w.getMaps()) {
                            map.getMarkerSets().put("TARDIS", markerSet);
                        }
                    });
                });
            }
        }
    }
}

