/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class TARDISTagListener
implements Listener {
    private final TARDIS plugin;
    private final Calendar eggcal = Calendar.getInstance();

    public TARDISTagListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerTagJoin(PlayerJoinEvent event) {
        if (this.eggcal.after(this.plugin.getBeforeCal()) && this.eggcal.before(this.plugin.getAfterCal())) {
            if (this.eggcal.get(2) == 10 && this.eggcal.get(5) == 23) {
                int age = this.eggcal.get(1) - 1963;
                String ordinal = this.getOrdinal(age);
                this.plugin.getMessenger().message((CommandSender)event.getPlayer(), TardisModule.TARDIS, "Happy " + age + ordinal + " Birthday Doctor Who!");
            }
            this.plugin.getMessenger().message((CommandSender)event.getPlayer(), TardisModule.TARDIS, "Today, and today only, you can play 'Tag the OOD'!");
            this.plugin.getMessenger().message((CommandSender)event.getPlayer(), TardisModule.TARDIS, Component.text((String)"To see tag stats (and who is currently 'it'), use the command ").append((Component)Component.text((String)"/tardis tag_the_ood", (TextColor)NamedTextColor.AQUA)));
            if (this.plugin.getTagConfig().getString("it", "").isEmpty()) {
                Player starter = this.getRandomPlayer();
                this.plugin.getMessenger().broadcast(TardisModule.TARDIS, starter.getName() + " is now the 'OOD'!");
                this.setConfig(starter.getName());
                this.setConfig(System.currentTimeMillis());
            }
        }
    }

    @EventHandler
    public void onPlayerTagLeave(PlayerQuitEvent event) {
        Player p;
        if (this.eggcal.after(this.plugin.getBeforeCal()) && this.eggcal.before(this.plugin.getAfterCal()) && (p = event.getPlayer()).getName().equals(this.plugin.getTagConfig().getString("it"))) {
            Player newit = this.getRandomPlayer();
            if (TARDISPermission.hasPermission(p, "tardis.tag")) {
                this.plugin.getMessenger().broadcast(TardisModule.TARDIS, newit.getName() + " is now the 'OOD'!");
            }
            this.setConfig(newit.getName());
            long now = System.currentTimeMillis();
            long timewasit = now - this.plugin.getTagConfig().getLong("time");
            if (TARDISPermission.hasPermission(p, "tardis.tag")) {
                this.plugin.getMessenger().broadcast(TardisModule.TARDIS, String.valueOf(p) + " was 'OOD' for " + this.getHoursMinutesSeconds(timewasit) + " seconds.");
            }
            this.setConfig(now);
            this.updateTagStats(p.getName(), timewasit);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTagPlayerInteractTagPlayer(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof Player) {
            Player clicked = (Player)entity;
            if (this.eggcal.after(this.plugin.getBeforeCal()) && this.eggcal.before(this.plugin.getAfterCal())) {
                String p = clicked.getName();
                if (clicked.getName().equals(this.plugin.getTagConfig().getString("it"))) {
                    Player newit = event.getPlayer();
                    if (TARDISPermission.hasPermission(newit, "tardis.tag")) {
                        this.plugin.getMessenger().broadcast(TardisModule.TARDIS, newit.getName() + " is now the 'OOD'!");
                    }
                    this.setConfig(newit.getName());
                    long now = System.currentTimeMillis();
                    long timewasit = now - this.plugin.getTagConfig().getLong("time");
                    if (TARDISPermission.hasPermission(newit, "tardis.tag")) {
                        this.plugin.getMessenger().broadcast(TardisModule.TARDIS, p + " was 'OOD' for " + this.getHoursMinutesSeconds(timewasit) + " seconds.");
                    }
                    this.setConfig(now);
                    this.updateTagStats(p, timewasit);
                }
            }
        }
    }

    private Player getRandomPlayer() {
        ArrayList players = new ArrayList(this.plugin.getServer().getOnlinePlayers());
        int num = players.size();
        return (Player)players.get(TARDISConstants.RANDOM.nextInt(num));
    }

    private String getOrdinal(int age) {
        return switch (age % 10) {
            case 1 -> "st";
            case 2 -> "nd";
            case 3 -> "rd";
            default -> "th";
        };
    }

    private void setConfig(String s) {
        this.plugin.getTagConfig().set("it", (Object)s);
        try {
            this.plugin.getTagConfig().save(new File(this.plugin.getDataFolder(), "tag.yml"));
        }
        catch (IOException io) {
            this.plugin.debug("Could not save tag.yml, " + String.valueOf(io));
        }
    }

    private void setConfig(long l) {
        this.plugin.getTagConfig().set("time", (Object)l);
        try {
            this.plugin.getTagConfig().save(new File(this.plugin.getDataFolder(), "tag.yml"));
        }
        catch (IOException io) {
            this.plugin.debug("Could not save tag.yml, " + String.valueOf(io));
        }
    }

    private String getHoursMinutesSeconds(long millis) {
        return String.format("%02dh:%02dm:%02ds", TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis)), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }

    private void updateTagStats(String p, long t) {
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("player", p);
        set.put("time", t);
        this.plugin.getQueryFactory().doSyncInsert("tag", set);
    }
}

