/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.InventoryManager;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISMultiverseInventoriesChecker;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TARDISMinecartListener
implements Listener {
    private final TARDIS plugin;

    public TARDISMinecartListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleBlockCollision(VehicleBlockCollisionEvent event) {
        Block block;
        Material material;
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Minecart && vehicle instanceof InventoryHolder && (Tag.DOORS.isTagged((Keyed)(material = (block = event.getBlock()).getType())) || Tag.FENCES.isTagged((Keyed)material))) {
            String[] data = null;
            UUID playerUUID = null;
            int id = 0;
            COMPASS d = COMPASS.SOUTH;
            Location block_loc = block.getLocation();
            String bw = block_loc.getWorld().getName();
            int bx = block_loc.getBlockX();
            int by = block_loc.getBlockY();
            int bz = block_loc.getBlockZ();
            String db_loc = bw + ":" + bx + ":" + by + ":" + bz;
            if (Tag.DOORS.isTagged((Keyed)material)) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("door_location", db_loc);
                where.put("door_type", 0);
                ResultSetDoors rsd = new ResultSetDoors(this.plugin, where, false);
                if (rsd.resultSet()) {
                    if (rsd.isLocked()) {
                        return;
                    }
                    id = rsd.getTardis_id();
                    HashMap<String, Object> whereid = new HashMap<String, Object>();
                    whereid.put("tardis_id", id);
                    ResultSetTardis rs = new ResultSetTardis(this.plugin, whereid, "", false);
                    if (rs.resultSet() && !this.plugin.getTrackerKeeper().getMinecart().contains(id)) {
                        Tardis tardis = rs.getTardis();
                        data = tardis.getRail().split(":");
                        playerUUID = tardis.getUuid();
                        this.plugin.getTrackerKeeper().getMinecart().add(id);
                    }
                }
            }
            if (Tag.FENCES.isTagged((Keyed)material)) {
                HashMap<String, Object> wherep = new HashMap<String, Object>();
                wherep.put("rail", db_loc);
                ResultSetTardis rsp = new ResultSetTardis(this.plugin, wherep, "", false);
                if (rsp.resultSet()) {
                    Tardis tardis = rsp.getTardis();
                    playerUUID = tardis.getUuid();
                    id = tardis.getTardisId();
                    HashMap<String, Object> whereinner = new HashMap<String, Object>();
                    whereinner.put("tardis_id", id);
                    whereinner.put("door_type", 1);
                    ResultSetDoors rsdinner = new ResultSetDoors(this.plugin, whereinner, false);
                    if (rsdinner.resultSet() && rsdinner.isLocked()) {
                        return;
                    }
                    HashMap<String, Object> whered = new HashMap<String, Object>();
                    whered.put("tardis_id", id);
                    whered.put("door_type", 0);
                    ResultSetDoors rspb = new ResultSetDoors(this.plugin, whered, false);
                    if (rspb.resultSet()) {
                        data = rspb.getDoor_location().split(":");
                        d = this.switchDirection(rspb.getDoor_direction());
                        this.plugin.getTrackerKeeper().getMinecart().remove(id);
                    }
                }
            }
            if (data != null && data.length > 3) {
                boolean shouldPrevent = this.plugin.getInvManager() == InventoryManager.MULTIVERSE ? !TARDISMultiverseInventoriesChecker.checkWorldsCanShare(bw, (String)data[0]) : false;
                if (shouldPrevent) {
                    if (playerUUID != null && this.plugin.getServer().getPlayer(playerUUID).isOnline()) {
                        this.plugin.getMessenger().send((CommandSender)this.plugin.getServer().getPlayer(playerUUID), TardisModule.TARDIS, "WORLD_NO_CART", bw, data[0]);
                    }
                    this.plugin.getTrackerKeeper().getMinecart().remove(id);
                } else {
                    World w = TARDISAliasResolver.getWorldFromAlias((String)data[0]);
                    int x = TARDISNumberParsers.parseInt((String)data[1]);
                    int y = TARDISNumberParsers.parseInt((String)data[2]);
                    int z = TARDISNumberParsers.parseInt((String)data[3]);
                    Location in_out = new Location(w, (double)x, (double)y, (double)z);
                    if (Tag.DOORS.isTagged((Keyed)material)) {
                        d = this.getDirection(in_out);
                        w.getChunkAt(in_out).addPluginChunkTicket((Plugin)this.plugin);
                    } else {
                        w.getChunkAt(in_out).removePluginChunkTicket((Plugin)this.plugin);
                    }
                    Inventory inventory = ((InventoryHolder)vehicle).getInventory();
                    ItemStack[] inv = Arrays.copyOf(inventory.getContents(), inventory.getSize());
                    inventory.clear();
                    this.teleportMinecart(vehicle, in_out, d, inv, vehicle.getType());
                }
            }
        }
    }

    private void teleportMinecart(Vehicle minecart, Location targetLocation, COMPASS d, ItemStack[] inv, EntityType cart) {
        Location trackLocation = this.findTrack(targetLocation);
        if (trackLocation == null) {
            return;
        }
        double speed = minecart.getVelocity().length();
        Chunk thisChunk = trackLocation.getChunk();
        while (!thisChunk.isLoaded()) {
            thisChunk.load();
        }
        thisChunk.addPluginChunkTicket((Plugin)this.plugin);
        long delay = 200L;
        for (ItemStack is : inv) {
            if (is == null) continue;
            delay += (long)is.getAmount() * 8L;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> thisChunk.removePluginChunkTicket((Plugin)this.plugin), delay);
        minecart.remove();
        Entity e = trackLocation.getWorld().spawnEntity(trackLocation, cart);
        InventoryHolder smc = (InventoryHolder)e;
        smc.getInventory().setContents(inv);
        switch (d) {
            case NORTH: {
                e.setVelocity(new Vector(0.0, 0.0, -speed));
                break;
            }
            case SOUTH: {
                e.setVelocity(new Vector(0.0, 0.0, speed));
                break;
            }
            case WEST: {
                e.setVelocity(new Vector(-speed, 0.0, 0.0));
                break;
            }
            default: {
                e.setVelocity(new Vector(speed, 0.0, 0.0));
            }
        }
    }

    private Location findTrack(Location center) {
        Block centerBlock = center.getBlock();
        for (BlockFace f : this.plugin.getGeneralKeeper().getFaces()) {
            Block block = centerBlock.getRelative(f);
            if (!this.isTrack(block.getType())) continue;
            return block.getLocation();
        }
        return null;
    }

    private boolean isTrack(Material mat) {
        return Tag.RAILS.isTagged((Keyed)mat);
    }

    private COMPASS getDirection(Location l) {
        Block centerBlock = l.getBlock();
        for (BlockFace f : this.plugin.getGeneralKeeper().getFaces()) {
            Block block = centerBlock.getRelative(f);
            if (!this.isTrack(block.getType())) continue;
            return COMPASS.valueOf(f.toString());
        }
        return null;
    }

    private COMPASS switchDirection(COMPASS d) {
        return switch (d) {
            case COMPASS.NORTH -> COMPASS.SOUTH;
            case COMPASS.SOUTH -> COMPASS.NORTH;
            case COMPASS.WEST -> COMPASS.EAST;
            default -> COMPASS.WEST;
        };
    }
}

