/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.utility.LightLevel;
import me.eccentric_nz.TARDIS.control.actions.ConsoleLampAction;
import me.eccentric_nz.TARDIS.control.actions.LightLevelAction;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.lights.LightLevelsInventory;
import me.eccentric_nz.TARDIS.lights.LightsInventory;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LightLevelsGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public LightLevelsGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onLightLevelsMenuClick(InventoryClickEvent event) {
        InventoryView view;
        ItemStack is;
        if (!(event.getInventory().getHolder(false) instanceof LightLevelsInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        if (slot >= 0 && slot < 54 && (is = (view = event.getView()).getItem(slot)) != null) {
            int id = -1;
            ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
            if (rst.fromUUID(uuid.toString())) {
                id = rst.getTardisId();
            }
            switch (slot) {
                case 9: {
                    StateResult setLevel = this.getNewState(view, 10, false);
                    if (!setLevel.success.booleanValue()) break;
                    this.setState(view, 10, setLevel.strength);
                    this.setLightLevel(setLevel.level, 50, id);
                    break;
                }
                case 11: {
                    StateResult setLevel = this.getNewState(view, 10, true);
                    if (!setLevel.success.booleanValue()) break;
                    this.setState(view, 10, setLevel.strength);
                    this.setLightLevel(setLevel.level, 50, id);
                    break;
                }
                case 15: {
                    StateResult setLevel = this.getNewState(view, 16, false);
                    if (!setLevel.success.booleanValue()) break;
                    this.setState(view, 16, setLevel.strength);
                    this.setLightLevel(setLevel.level, 49, id);
                    break;
                }
                case 17: {
                    StateResult setLevel = this.getNewState(view, 16, true);
                    if (!setLevel.success.booleanValue()) break;
                    this.setState(view, 16, setLevel.strength);
                    this.setLightLevel(setLevel.level, 49, id);
                    break;
                }
                case 30: {
                    StateResult setLevel = this.getNewState(view, 31, false);
                    if (!setLevel.success.booleanValue()) break;
                    this.setState(view, 31, setLevel.strength);
                    this.setLightLevel(setLevel.level, 56, id);
                    break;
                }
                case 32: {
                    StateResult setLevel = this.getNewState(view, 31, true);
                    if (!setLevel.success.booleanValue()) break;
                    this.setState(view, 31, setLevel.strength);
                    this.setLightLevel(setLevel.level, 56, id);
                    break;
                }
                case 45: {
                    player.openInventory(new LightsInventory(this.plugin, id, uuid).getInventory());
                    break;
                }
                case 53: {
                    this.close(player);
                }
            }
        }
    }

    private StateResult getNewState(InventoryView view, int slot, boolean next) {
        ItemStack is = view.getItem(slot);
        ItemMeta im = is.getItemMeta();
        String lore = ComponentUtils.stripColour((Component)im.lore().getFirst());
        int currentStrength = TARDISNumberParsers.parseInt(lore);
        if (slot == 16) {
            int index = ArrayUtils.indexOf((int[])LightLevel.exterior_level, (int)currentStrength);
            if (next && index - 1 >= 0) {
                return new StateResult(true, LightLevel.exterior_level[index - 1], index - 1);
            }
            if (!next && index + 1 < LightLevel.exterior_level.length) {
                return new StateResult(true, LightLevel.exterior_level[index + 1], index + 1);
            }
        } else {
            int index = ArrayUtils.indexOf((int[])LightLevel.interior_level, (int)currentStrength);
            if (next && index - 1 >= 0) {
                return new StateResult(true, LightLevel.interior_level[index - 1], index - 1);
            }
            if (!next && index + 1 < LightLevel.interior_level.length) {
                return new StateResult(true, LightLevel.interior_level[index + 1], index + 1);
            }
        }
        return new StateResult(false, currentStrength, 0);
    }

    private void setState(InventoryView view, int slot, int strength) {
        ItemStack is = view.getItem(slot);
        ItemMeta im = is.getItemMeta();
        List lore = im.lore();
        lore.set(0, Component.text((int)strength));
        im.lore(lore);
        is.setItemMeta(im);
    }

    private void setLightLevel(int setLevel, int which, int id) {
        ResultSetLightLevel rs = new ResultSetLightLevel(this.plugin);
        if (rs.fromTypeAndID(which, id)) {
            if (which > 50) {
                new ConsoleLampAction(this.plugin).illuminate(id, setLevel, rs.getControlId());
            } else {
                new LightLevelAction(this.plugin).illuminate(setLevel - 1, rs.getControlId(), rs.isPowered(), which, rs.isPoliceBox(), id, rs.isLightsOn());
            }
        }
    }

    private static class StateResult {
        final Boolean success;
        final Integer strength;
        final Integer level;

        public StateResult(Boolean success, Integer strength, Integer level) {
            this.success = success;
            this.strength = strength;
            this.level = level;
        }
    }
}

