/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus;

import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISGeneticManipulatorDisguiseEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISGeneticManipulatorUndisguiseEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.GUIGeneticManipulator;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.lazarus.LazarusAdjacentInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusCharacterInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusCompanionInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusDisguise;
import me.eccentric_nz.TARDIS.lazarus.LazarusDoctorInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusHostileInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusLibsDisguises;
import me.eccentric_nz.TARDIS.lazarus.LazarusMonstersInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusNeutralInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusPassiveInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusRunnable;
import me.eccentric_nz.TARDIS.lazarus.LazarusUtils;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.plugin.Plugin;

public class LazarusChoiceListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public LazarusChoiceListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onLazarusClick(InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (!(holder instanceof LazarusInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        Block b = this.plugin.getTrackerKeeper().getLazarus().get(uuid);
        if (b == null) {
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 1: {
                LazarusUtils.pagers.add(uuid);
                LazarusPassiveInventory ih = new LazarusPassiveInventory(this.plugin);
                player.openInventory(ih.getInventory());
                break;
            }
            case 3: {
                LazarusUtils.pagers.add(uuid);
                LazarusNeutralInventory ih = new LazarusNeutralInventory(this.plugin);
                player.openInventory(ih.getInventory());
                break;
            }
            case 5: {
                LazarusUtils.pagers.add(uuid);
                LazarusHostileInventory ih = new LazarusHostileInventory(this.plugin);
                player.openInventory(ih.getInventory());
                break;
            }
            case 7: {
                LazarusUtils.pagers.add(uuid);
                LazarusAdjacentInventory ih = new LazarusAdjacentInventory(this.plugin);
                player.openInventory(ih.getInventory());
                break;
            }
            case 9: {
                LazarusUtils.pagers.add(uuid);
                LazarusDoctorInventory ih = new LazarusDoctorInventory(this.plugin);
                player.openInventory(ih.getInventory());
                break;
            }
            case 11: {
                LazarusUtils.pagers.add(uuid);
                LazarusCompanionInventory ih = new LazarusCompanionInventory(this.plugin);
                player.openInventory(ih.getInventory());
                break;
            }
            case 13: {
                LazarusUtils.pagers.add(uuid);
                LazarusCharacterInventory ih = new LazarusCharacterInventory(this.plugin);
                player.openInventory(ih.getInventory());
                break;
            }
            case 15: {
                LazarusUtils.pagers.add(uuid);
                LazarusMonstersInventory ih = new LazarusMonstersInventory(this.plugin);
                player.openInventory(ih.getInventory());
                break;
            }
            case 17: {
                ItemStack masterButton = view.getItem(slot);
                ItemMeta masterMeta = masterButton.getItemMeta();
                if (TARDISPermission.hasPermission(player, "tardis.themaster")) {
                    if (this.plugin.getTrackerKeeper().getImmortalityGate().isEmpty()) {
                        boolean isOff = ComponentUtils.stripColour((Component)masterMeta.lore().getFirst()).equals(this.plugin.getLanguage().getString("SET_OFF", "OFF"));
                        TextComponent onoff = isOff ? Component.text((String)this.plugin.getLanguage().getString("SET_ON", "ON")) : Component.text((String)this.plugin.getLanguage().getString("SET_OFF", "OFF"));
                        masterMeta.lore(List.of(onoff));
                        CustomModelDataComponent component = masterMeta.getCustomModelDataComponent();
                        component.setFloats(isOff ? List.of(Float.valueOf(252.0f)) : List.of(Float.valueOf(152.0f)));
                        masterMeta.setCustomModelDataComponent(component);
                        if (!this.isReversedPolarity(view)) {
                            this.plugin.getTrackerKeeper().setImmortalityGate(player.getName());
                            if (this.plugin.isDisguisesOnServer()) {
                                LazarusLibsDisguises.runImmortalityGate(player);
                            } else {
                                LazarusDisguise.runImmortalityGate(player);
                            }
                            this.plugin.getMessenger().broadcast(TardisModule.TARDIS, "The Master (aka " + player.getName() + ") has cloned his genetic template to all players. Behold the Master Race!");
                            this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorDisguiseEvent(player, player.getName()));
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                this.plugin.getServer().getOnlinePlayers().forEach(p -> {
                                    if (this.plugin.isDisguisesOnServer()) {
                                        LazarusLibsDisguises.removeDisguise(p);
                                    } else {
                                        LazarusDisguise.removeDisguise(p);
                                    }
                                });
                                this.plugin.getMessenger().broadcast(TardisModule.TARDIS, "Lord Rassilon has reset the Master Race back to human form.");
                                this.plugin.getTrackerKeeper().setImmortalityGate("");
                                this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorUndisguiseEvent(player));
                            }, 3600L);
                        }
                    } else {
                        masterMeta.lore(List.of(Component.text((String)"The Master Race is already"), Component.text((String)(" set to " + this.plugin.getTrackerKeeper().getImmortalityGate() + "!")), Component.text((String)"Use the Restore button"), Component.text((String)"and try again later.")));
                    }
                } else {
                    masterMeta.lore(List.of(Component.text((String)"You do not have permission"), Component.text((String)"to be The Master!")));
                }
                masterButton.setItemMeta(masterMeta);
                break;
            }
            case 51: {
                LazarusUtils.pagers.remove(uuid);
                this.plugin.getTrackerKeeper().getGeneticManipulation().add(uuid);
                this.close(player);
                if (!this.plugin.getTrackerKeeper().getImmortalityGate().isEmpty()) {
                    this.plugin.getServer().getOnlinePlayers().forEach(p -> {
                        if (this.plugin.isDisguisesOnServer()) {
                            LazarusLibsDisguises.removeDisguise(p);
                        } else {
                            LazarusDisguise.removeDisguise(p);
                        }
                    });
                    this.plugin.getMessenger().broadcast(TardisModule.TARDIS, "Lord Rassilon has reset the Master Race back to human form.");
                    this.plugin.getTrackerKeeper().setImmortalityGate("");
                    this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorUndisguiseEvent(player));
                }
                LazarusRunnable runnable = new LazarusRunnable(this.plugin, b);
                int taskId = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 6L, 6L);
                runnable.setTaskID(taskId);
                TARDISSounds.playTARDISSound(player.getLocation(), "lazarus_machine");
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    LazarusUtils.geneticModificationOff(player);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GENETICS_RESTORED");
                    this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorUndisguiseEvent(player));
                }, 80L);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    LazarusUtils.openDoor(b);
                    this.untrack(uuid, true);
                    this.plugin.getTrackerKeeper().getGeneticallyModified().remove(uuid);
                }, 100L);
                break;
            }
            case 53: {
                LazarusUtils.pagers.remove(uuid);
                this.close(player);
                LazarusUtils.openDoor(b);
                this.untrack(uuid, false);
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onLazarusClose(InventoryCloseEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (this.plugin.getTrackerKeeper().getGeneticManipulation().contains(uuid)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (holder instanceof LazarusInventory || holder instanceof LazarusPassiveInventory || holder instanceof LazarusNeutralInventory || holder instanceof LazarusHostileInventory || holder instanceof LazarusAdjacentInventory || holder instanceof LazarusMonstersInventory || holder instanceof LazarusDoctorInventory || holder instanceof LazarusCompanionInventory || holder instanceof LazarusCharacterInventory) {
            Block b = this.plugin.getTrackerKeeper().getLazarus().get(uuid);
            if (b != null && b.getRelative(BlockFace.SOUTH).getType().equals((Object)Material.COBBLESTONE_WALL)) {
                b.getRelative(BlockFace.SOUTH).setType(Material.AIR);
                b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).setType(Material.AIR);
            }
            this.untrack(uuid, false);
            LazarusUtils.pagers.remove(uuid);
        }
    }

    private void untrack(UUID uuid, boolean remove) {
        if (!LazarusUtils.pagers.contains(uuid)) {
            this.plugin.getTrackerKeeper().getLazarus().remove(uuid);
        }
        if (remove) {
            this.plugin.getTrackerKeeper().getDisguises().remove(uuid);
        }
        this.plugin.getTrackerKeeper().getGeneticManipulation().remove(uuid);
    }

    private boolean isReversedPolarity(InventoryView i) {
        ItemStack is = i.getItem(GUIGeneticManipulator.BUTTON_MASTER.slot());
        ItemMeta im = is.getItemMeta();
        return ComponentUtils.stripColour((Component)im.lore().getFirst()).equals(this.plugin.getLanguage().getString("SET_ON", "ON"));
    }
}

