/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.junk;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.admin.DeleteTARDISCommand;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class JunkDelete {
    private final TARDIS plugin;

    public JunkDelete(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void delete(CommandSender sender) {
        if (!sender.hasPermission("tardis.admin")) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
            return;
        }
        ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
        if (rs.fromUUID("00000000-aaaa-bbbb-cccc-000000000000")) {
            int id = rs.getTardisId();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return;
            }
            Current current = rsc.getCurrent();
            DestroyData dd = new DestroyData();
            dd.setDirection(COMPASS.SOUTH);
            dd.setLocation(current.location());
            dd.setHide(false);
            dd.setOutside(false);
            dd.setSubmarine(current.submarine());
            dd.setTardisID(id);
            dd.setThrottle(SpaceTimeThrottle.JUNK);
            this.plugin.getPresetDestroyer().destroyPreset(dd);
            World cw = this.plugin.getServer().getWorld(this.plugin.getConfig().getString("creation.default_world_name"));
            if (cw != null) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.plugin.getInteriorDestroyer().destroyInner(Desktops.schematicFor("junk"), id, cw, -999);
                    DeleteTARDISCommand.cleanDatabase(id);
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "JUNK_DELETED");
                }, 20L);
            }
        }
    }
}

