/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.handles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.custommodels.keys.DiskVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.GuiVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.HandlesVariant;
import me.eccentric_nz.TARDIS.handles.HandlesCategory;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;

public enum HandlesBlock {
    COMEHERE(HandlesCategory.COMMAND, "/tardis come_here command", List.of(Component.text((String)"Make the TARDIS"), Component.text((String)"travel to you")), HandlesVariant.HANDLES_COMMAND_COMEHERE.getKey()),
    HIDE(HandlesCategory.COMMAND, "/tardis hide command", List.of(Component.text((String)"Make the TARDIS"), Component.text((String)"exterior invisible")), HandlesVariant.HANDLES_COMMAND_HIDE.getKey()),
    REBUILD(HandlesCategory.COMMAND, "/tardis rebuild command", List.of(Component.text((String)"Rebuild the"), Component.text((String)"TARDIS exterior")), HandlesVariant.HANDLES_COMMAND_REBUILD.getKey()),
    SCAN(HandlesCategory.COMMAND, "TARDIS scan command", List.of(Component.text((String)"Scan the environment"), Component.text((String)"outside the TARDIS")), HandlesVariant.HANDLES_COMMAND_SCAN.getKey()),
    TAKE_OFF(HandlesCategory.COMMAND, "TARDIS take off command", List.of(Component.text((String)"Make the TARDIS enter"), Component.text((String)"the Time Vortex")), HandlesVariant.HANDLES_COMMAND_TAKE_OFF.getKey()),
    TRAVEL(HandlesCategory.COMMAND, "/tardistravel command", List.of(Component.text((String)"Make the TARDIS"), Component.text((String)"travel somewhere")), HandlesVariant.HANDLES_COMMAND_TRAVEL.getKey()),
    LAND(HandlesCategory.COMMAND, "TARDIS land command", List.of(Component.text((String)"Make the TARDIS exit"), Component.text((String)"the Time Vortex")), HandlesVariant.HANDLES_COMMAND_LAND.getKey()),
    FOR(HandlesCategory.CONTROL, "FOR loop", List.of(Component.text((String)"Use to start a loop"), Component.text((String)"with a counter")), HandlesVariant.HANDLES_CONTROL_FOR.getKey()),
    TO(HandlesCategory.CONTROL, "TO", List.of(Component.text((String)"Use with a FOR loop"), Component.text((String)"to specify the number"), Component.text((String)"of loops")), HandlesVariant.HANDLES_CONTROL_TO.getKey()),
    DO(HandlesCategory.CONTROL, "DO", List.of(Component.text((String)"Use after an"), Component.text((String)"IF or FOR loop")), HandlesVariant.HANDLES_CONTROL_DO.getKey()),
    END(HandlesCategory.CONTROL, "END", List.of(Component.text((String)"Use to finish"), Component.text((String)"a conditional or"), Component.text((String)"loop statement")), HandlesVariant.HANDLES_CONTROL_END.getKey()),
    IF(HandlesCategory.CONTROL, "IF", List.of(Component.text((String)"Check whether a"), Component.text((String)"condition is"), Component.text((String)"true or false")), HandlesVariant.HANDLES_CONTROL_IF.getKey()),
    ELSE(HandlesCategory.CONTROL, "ELSE", List.of(Component.text((String)"Use to run actions"), Component.text((String)"if an IF is false")), HandlesVariant.HANDLES_CONTROL_ELSE.getKey()),
    ELSE_IF(HandlesCategory.CONTROL, "ELSE IF", List.of(Component.text((String)"Check another condition")), HandlesVariant.HANDLES_CONTROL_ELSE_IF.getKey()),
    BREAK(HandlesCategory.CONTROL, "BREAK", List.of(Component.text((String)"Use to break"), Component.text((String)"out of a loop")), HandlesVariant.HANDLES_CONTROL_BREAK.getKey()),
    MATERIALISE(HandlesCategory.EVENT, "TARDIS materialisation event", null, HandlesVariant.HANDLES_EVENT_MATERIALISE.getKey()),
    DEMATERIALISE(HandlesCategory.EVENT, "TARDIS dematerialisation event", null, HandlesVariant.HANDLES_EVENT_DEMATERIALISE.getKey()),
    ARTRON(HandlesCategory.EVENT, "Artron Level event", List.of(Component.text((String)"Use with Operator"), Component.text((String)"and Number blocks")), HandlesVariant.HANDLES_EVENT_ARTRON.getKey()),
    DEATH(HandlesCategory.EVENT, "Time Lord Death event", null, HandlesVariant.HANDLES_EVENT_DEATH.getKey()),
    ENTER(HandlesCategory.EVENT, "TARDIS Entry event", null, HandlesVariant.HANDLES_EVENT_ENTER.getKey()),
    EXIT(HandlesCategory.EVENT, "TARDIS Exit event", null, HandlesVariant.HANDLES_EVENT_EXIT.getKey()),
    HADS(HandlesCategory.EVENT, "TARDIS H.A.D.S event", null, HandlesVariant.HANDLES_EVENT_HADS.getKey()),
    SIEGE_ON(HandlesCategory.EVENT, "Siege Mode On event", null, HandlesVariant.HANDLES_EVENT_SIEGE_ON.getKey()),
    SIEGE_OFF(HandlesCategory.EVENT, "Siege Mode Off event", null, HandlesVariant.HANDLES_EVENT_SIEGE_OFF.getKey()),
    LOG_OUT(HandlesCategory.EVENT, "Player log out event", null, HandlesVariant.HANDLES_EVENT_LOG_OUT.getKey()),
    ZERO(HandlesCategory.NUMBER, "0", List.of(Component.text((String)"The number zero")), HandlesVariant.HANDLES_NUMBER_ZERO.getKey()),
    ONE(HandlesCategory.NUMBER, "1", List.of(Component.text((String)"The number one")), HandlesVariant.HANDLES_NUMBER_ONE.getKey()),
    TWO(HandlesCategory.NUMBER, "2", List.of(Component.text((String)"The number two")), HandlesVariant.HANDLES_NUMBER_TWO.getKey()),
    THREE(HandlesCategory.NUMBER, "3", List.of(Component.text((String)"The number three")), HandlesVariant.HANDLES_NUMBER_THREE.getKey()),
    FOUR(HandlesCategory.NUMBER, "4", List.of(Component.text((String)"The number four")), HandlesVariant.HANDLES_NUMBER_FOUR.getKey()),
    FIVE(HandlesCategory.NUMBER, "5", List.of(Component.text((String)"The number five")), HandlesVariant.HANDLES_NUMBER_FIVE.getKey()),
    SIX(HandlesCategory.NUMBER, "6", List.of(Component.text((String)"The number six")), HandlesVariant.HANDLES_NUMBER_SIX.getKey()),
    SEVEN(HandlesCategory.NUMBER, "7", List.of(Component.text((String)"The number seven")), HandlesVariant.HANDLES_NUMBER_SEVEN.getKey()),
    EIGHT(HandlesCategory.NUMBER, "8", List.of(Component.text((String)"The number eight")), HandlesVariant.HANDLES_NUMBER_EIGHT.getKey()),
    NINE(HandlesCategory.NUMBER, "9", List.of(Component.text((String)"The number nine")), HandlesVariant.HANDLES_NUMBER_NINE.getKey()),
    COIN(HandlesCategory.NUMBER, "Flip a coin", List.of(Component.text((String)"Returns a true"), Component.text((String)"or false value")), HandlesVariant.HANDLES_NUMBER_COIN.getKey()),
    RANDOM(HandlesCategory.NUMBER, "Random number", List.of(Component.text((String)"Generate a random number"), Component.text((String)"between 0 and the"), Component.text((String)"number that follows")), HandlesVariant.HANDLES_NUMBER_RANDOM.getKey()),
    ASSIGNMENT(HandlesCategory.OPERATOR, "Assignment operator", List.of(Component.text((String)"Used to assign a"), Component.text((String)"value to a variable")), HandlesVariant.HANDLES_OPERATOR_ASSIGNMENT.getKey()),
    ADDITION(HandlesCategory.OPERATOR, "Addition operator", List.of(Component.text((String)"Use to add two"), Component.text((String)"numbers together")), HandlesVariant.HANDLES_OPERATOR_ADDITION.getKey()),
    SUBTRACTION(HandlesCategory.OPERATOR, "Subtraction operator", List.of(Component.text((String)"Use to subtract one"), Component.text((String)"number from anther")), HandlesVariant.HANDLES_OPERATOR_SUBTRACTION.getKey()),
    MULTIPLICATION(HandlesCategory.OPERATOR, "Multiplication operator", List.of(Component.text((String)"Use to multiply two"), Component.text((String)"numbers together")), HandlesVariant.HANDLES_OPERATOR_MULTIPLICATION.getKey()),
    DIVISION(HandlesCategory.OPERATOR, "Division operator", List.of(Component.text((String)"Use to divide one"), Component.text((String)"number by another")), HandlesVariant.HANDLES_OPERATOR_DIVISION.getKey()),
    AND(HandlesCategory.OPERATOR, "AND operator", List.of(Component.text((String)"Use to check"), Component.text((String)"both conditions"), Component.text((String)"are is true")), HandlesVariant.HANDLES_OPERATOR_AND.getKey()),
    OR(HandlesCategory.OPERATOR, "OR operator", List.of(Component.text((String)"Use to check"), Component.text((String)"if either"), Component.text((String)"condition is true")), HandlesVariant.HANDLES_OPERATOR_OR.getKey()),
    EQUALS(HandlesCategory.OPERATOR, "Equality operator", List.of(Component.text((String)"Checks if two"), Component.text((String)"objects are equal")), HandlesVariant.HANDLES_OPERATOR_EQUALS.getKey()),
    NOT_EQUAL(HandlesCategory.OPERATOR, "Not equal operator", List.of(Component.text((String)"Checks if two objects"), Component.text((String)"are not the same")), HandlesVariant.HANDLES_OPERATOR_NOT_EQUAL.getKey()),
    LESS_THAN(HandlesCategory.OPERATOR, "Less than operator", List.of(Component.text((String)"Checks if one number"), Component.text((String)"is smaller than another")), HandlesVariant.HANDLES_OPERATOR_LESS_THAN.getKey()),
    LESS_THAN_EQUAL(HandlesCategory.OPERATOR, "Less than or equal to operator", List.of(Component.text((String)"Checks if one number"), Component.text((String)"is smaller than or"), Component.text((String)"equal to another")), HandlesVariant.HANDLES_OPERATOR_LESS_THAN_EQUAL.getKey()),
    GREATER_THAN(HandlesCategory.OPERATOR, "Greater than operator", List.of(Component.text((String)"Checks if one number"), Component.text((String)"is bigger than another")), HandlesVariant.HANDLES_OPERATOR_GREATER_THAN.getKey()),
    GREATER_THAN_EQUAL(HandlesCategory.OPERATOR, "Greater than or equal to operator", List.of(Component.text((String)"Checks if one number"), Component.text((String)"is bigger than or"), Component.text((String)"equal to another")), HandlesVariant.HANDLES_OPERATOR_GREATER_THAN_EQUAL.getKey()),
    MODULO(HandlesCategory.OPERATOR, "Modulo operator", List.of(Component.text((String)"Gets the remainder"), Component.text((String)"left over after"), Component.text((String)"dividing two numbers")), HandlesVariant.HANDLES_OPERATOR_MODULO.getKey()),
    TIME_LORD(HandlesCategory.SELECTOR, "Target Time Lord", null, HandlesVariant.HANDLES_SELECTOR_TIME_LORD.getKey()),
    COMPANIONS(HandlesCategory.SELECTOR, "Target companions", null, HandlesVariant.HANDLES_SELECTOR_COMPANIONS.getKey()),
    TARDIS(HandlesCategory.SELECTOR, "The TARDIS", null, HandlesVariant.HANDLES_SELECTOR_TARDIS.getKey()),
    DOOR(HandlesCategory.SELECTOR, "TARDIS Door", List.of(Component.text((String)"Use with an"), Component.text((String)"Open, Close"), Component.text((String)"Lock or Unlock block")), HandlesVariant.HANDLES_SELECTOR_DOOR.getKey()),
    LIGHTS(HandlesCategory.SELECTOR, "TARDIS Lights", List.of(Component.text((String)"Use with an"), Component.text((String)"On or Off block")), HandlesVariant.HANDLES_SELECTOR_LIGHTS.getKey()),
    POWER(HandlesCategory.SELECTOR, "TARDIS Power action", List.of(Component.text((String)"Use with a Show,"), Component.text((String)"On or Off block")), HandlesVariant.HANDLES_SELECTOR_POWER.getKey()),
    SIEGE(HandlesCategory.SELECTOR, "Siege Mode action", List.of(Component.text((String)"Use with an"), Component.text((String)"On or Off block")), HandlesVariant.HANDLES_SELECTOR_SIEGE.getKey()),
    VARIABLE(HandlesCategory.VARIABLE, "Variable", List.of(Component.text((String)"A generic container"), Component.text((String)"to hold a value")), HandlesVariant.HANDLES_VARIABLE_VARIABLE.getKey()),
    X(HandlesCategory.VARIABLE, "X coordinate", List.of(Component.text((String)"Use with a number"), Component.text((String)"to specify a location")), HandlesVariant.HANDLES_VARIABLE_X.getKey()),
    Y(HandlesCategory.VARIABLE, "Y coordinate", List.of(Component.text((String)"Use with a number"), Component.text((String)"to specify a location")), HandlesVariant.HANDLES_VARIABLE_Y.getKey()),
    Z(HandlesCategory.VARIABLE, "Z coordinate", List.of(Component.text((String)"Use with a number"), Component.text((String)"to specify a location")), HandlesVariant.HANDLES_VARIABLE_Z.getKey()),
    OPEN(HandlesCategory.VARIABLE, "Open Door action", null, HandlesVariant.HANDLES_VARIABLE_OPEN.getKey()),
    CLOSE(HandlesCategory.VARIABLE, "Close Door action", null, HandlesVariant.HANDLES_VARIABLE_CLOSE.getKey()),
    LOCK(HandlesCategory.VARIABLE, "Lock Door action", null, HandlesVariant.HANDLES_VARIABLE_LOCK.getKey()),
    UNLOCK(HandlesCategory.VARIABLE, "Unlock Door action", null, HandlesVariant.HANDLES_VARIABLE_UNLOCK.getKey()),
    ON(HandlesCategory.VARIABLE, "On action", null, HandlesVariant.HANDLES_VARIABLE_ON.getKey()),
    OFF(HandlesCategory.VARIABLE, "Off action", null, HandlesVariant.HANDLES_VARIABLE_OFF.getKey()),
    SHOW(HandlesCategory.VARIABLE, "Show Artron Levels action", null, HandlesVariant.HANDLES_VARIABLE_SHOW.getKey()),
    REDSTONE(HandlesCategory.VARIABLE, "Send Redstone signal", List.of(Component.text((String)"Use to power the block"), Component.text((String)"Handles is placed on")), HandlesVariant.HANDLES_VARIABLE_REDSTONE.getKey()),
    HOME(HandlesCategory.VARIABLE, "Home Location", null, HandlesVariant.HANDLES_VARIABLE_HOME.getKey()),
    RECHARGER(HandlesCategory.VARIABLE, "Travel to recharger", null, HandlesVariant.HANDLES_VARIABLE_RECHARGER.getKey()),
    CONTROL(HandlesCategory.BUTTON, "Show control blocks", null, GuiVariant.CONTROL.getKey()),
    OPERATOR(HandlesCategory.BUTTON, "Show operator blocks", null, GuiVariant.OPERATOR.getKey()),
    VAR(HandlesCategory.BUTTON, "Show variable blocks", null, GuiVariant.VAR.getKey()),
    NUMBER(HandlesCategory.BUTTON, "Show number blocks", null, GuiVariant.NUMBER.getKey()),
    EVENT(HandlesCategory.BUTTON, "Show event blocks", null, GuiVariant.EVENT.getKey()),
    COMMAND(HandlesCategory.BUTTON, "Show command blocks", null, GuiVariant.COMMAND.getKey()),
    SELECTOR(HandlesCategory.BUTTON, "Show selector blocks", null, GuiVariant.SELECTOR.getKey()),
    PROGRAMS(HandlesCategory.BUTTON, "Show saved programs", null, GuiVariant.HANDLES_DISK.getKey()),
    SAVE(HandlesCategory.BUTTON, "Save the program to disk", null, GuiVariant.SAVE.getKey()),
    LEFT(HandlesCategory.BUTTON, "Scroll left", null, GuiVariant.LEFT.getKey()),
    RIGHT(HandlesCategory.BUTTON, "Scroll right", null, GuiVariant.RIGHT.getKey()),
    AREA_DISK(HandlesCategory.DISK, "Area Storage Disk", null, DiskVariant.AREA_DISK.getKey()),
    BIOME_DISK(HandlesCategory.DISK, "Biome Storage Disk", null, DiskVariant.BIOME_DISK.getKey()),
    PLAYER_DISK(HandlesCategory.DISK, "Player Storage Disk", null, DiskVariant.PLAYER_DISK.getKey()),
    SAVE_DISK(HandlesCategory.DISK, "Save Storage Disk", null, DiskVariant.SAVE_DISK.getKey());

    public static final HashMap<String, HandlesBlock> BY_NAME;
    private static final List<HandlesBlock> commands;
    private static final List<HandlesBlock> controls;
    private static final List<HandlesBlock> events;
    private static final List<HandlesBlock> numbers;
    private static final List<HandlesBlock> operators;
    private static final List<HandlesBlock> selectors;
    private static final List<HandlesBlock> variables;
    private static final List<HandlesBlock> buttons;
    private final HandlesCategory category;
    private final String displayName;
    private final List<Component> lore;
    private final NamespacedKey model;

    private HandlesBlock(HandlesCategory category, String displayName, List<Component> lore, NamespacedKey model) {
        this.category = category;
        this.displayName = displayName;
        this.lore = lore;
        this.model = model;
    }

    public static List<HandlesBlock> getCommands() {
        return commands;
    }

    public static List<HandlesBlock> getControls() {
        return controls;
    }

    public static List<HandlesBlock> getEvents() {
        return events;
    }

    public static List<HandlesBlock> getNumbers() {
        return numbers;
    }

    public static List<HandlesBlock> getOperators() {
        return operators;
    }

    public static List<HandlesBlock> getSelectors() {
        return selectors;
    }

    public static List<HandlesBlock> getVariables() {
        return variables;
    }

    public static List<HandlesBlock> getButtons() {
        return buttons;
    }

    public HandlesCategory getCategory() {
        return this.category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<Component> getLore() {
        return this.lore;
    }

    public NamespacedKey getModel() {
        return this.model;
    }

    static {
        BY_NAME = new HashMap();
        commands = new ArrayList<HandlesBlock>();
        controls = new ArrayList<HandlesBlock>();
        events = new ArrayList<HandlesBlock>();
        numbers = new ArrayList<HandlesBlock>();
        operators = new ArrayList<HandlesBlock>();
        selectors = new ArrayList<HandlesBlock>();
        variables = new ArrayList<HandlesBlock>();
        buttons = new ArrayList<HandlesBlock>();
        for (HandlesBlock block : HandlesBlock.values()) {
            switch (block.getCategory()) {
                case BUTTON: {
                    buttons.add(block);
                    break;
                }
                case COMMAND: {
                    commands.add(block);
                    break;
                }
                case CONTROL: {
                    controls.add(block);
                    break;
                }
                case EVENT: {
                    events.add(block);
                    break;
                }
                case NUMBER: {
                    numbers.add(block);
                    break;
                }
                case OPERATOR: {
                    operators.add(block);
                    break;
                }
                case SELECTOR: {
                    selectors.add(block);
                    break;
                }
                case VARIABLE: {
                    variables.add(block);
                    break;
                }
            }
            BY_NAME.put(block.displayName, block);
        }
    }
}

