/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISDematerialisationEvent;
import me.eccentric_nz.TARDIS.builders.exterior.EmergencyRelocation;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetNextLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class DematerialiseToVortex
implements Runnable {
    private final TARDIS plugin;
    private final int id;
    private final Player player;
    private final Location handbrake;
    private final Throticle throticle;

    public DematerialiseToVortex(TARDIS plugin, int id, Player player, Location handbrake, Throticle throticle) {
        this.plugin = plugin;
        this.id = id;
        this.player = player;
        this.handbrake = handbrake;
        this.throticle = throticle;
    }

    @Override
    public void run() {
        UUID uuid = this.player.getUniqueId();
        this.plugin.getTrackerKeeper().getInVortex().add(this.id);
        this.plugin.getTrackerKeeper().getDidDematToVortex().add(this.id);
        HashMap<String, Object> wherei = new HashMap<String, Object>();
        wherei.put("tardis_id", this.id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wherei, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, this.id);
            if (!rsc.resultSet()) {
                new EmergencyRelocation(this.plugin).relocate(this.id, this.player);
                return;
            }
            Current current = rsc.getCurrent();
            String resetw = current.location().getWorld().getName();
            HashMap<String, Object> bid = new HashMap<String, Object>();
            bid.put("tardis_id", this.id);
            HashMap<String, Object> bset = new HashMap<String, Object>();
            bset.put("world", current.location().getWorld().getName());
            bset.put("x", current.location().getBlockX());
            bset.put("y", current.location().getBlockY());
            bset.put("z", current.location().getBlockZ());
            bset.put("direction", current.direction().toString());
            bset.put("submarine", current.submarine());
            this.plugin.getQueryFactory().doUpdate("back", bset, bid);
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
            boolean minecart = rsp.resultSet() && rsp.isMinecartOn();
            DestroyData dd = new DestroyData();
            dd.setDirection(current.direction());
            dd.setLocation(current.location());
            dd.setPlayer((OfflinePlayer)this.player);
            dd.setHide(false);
            dd.setOutside(false);
            dd.setSubmarine(current.submarine());
            dd.setTardisID(this.id);
            dd.setThrottle(this.throticle.throttle());
            dd.setParticles(this.throticle.particles());
            ChameleonPreset preset = tardis.getPreset();
            if (preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                ResultSetNextLocation rsn = new ResultSetNextLocation(this.plugin, this.id);
                if (!rsn.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_NO_LOAD");
                    return;
                }
                Location exit = new Location(rsn.getWorld(), (double)rsn.getX(), (double)rsn.getY(), (double)rsn.getZ());
                dd.setFromToLocation(exit);
                dd.setThrottle(SpaceTimeThrottle.JUNK);
            }
            this.plugin.getPM().callEvent((Event)new TARDISDematerialisationEvent(this.player, tardis, current.location()));
            if (!tardis.isHidden() && !this.plugin.getTrackerKeeper().getResetWorlds().contains(resetw)) {
                if (!minecart) {
                    if (!preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                        String sound;
                        if (this.plugin.getTrackerKeeper().getMalfunction().get(this.id).booleanValue() && this.plugin.getTrackerKeeper().getHasDestination().containsKey(this.id)) {
                            sound = "tardis_malfunction_takeoff";
                        } else {
                            sound = switch (this.throticle.throttle()) {
                                case SpaceTimeThrottle.WARP -> "tardis_takeoff_warp";
                                case SpaceTimeThrottle.RAPID -> "tardis_takeoff_rapid";
                                case SpaceTimeThrottle.FASTER -> "tardis_takeoff_faster";
                                default -> "tardis_takeoff";
                            };
                        }
                        TARDISSounds.playTARDISSound(this.handbrake, sound);
                        TARDISSounds.playTARDISSound(current.location(), sound);
                    } else {
                        TARDISSounds.playTARDISSound(this.handbrake, "junk_takeoff");
                    }
                } else {
                    this.handbrake.getWorld().playSound(this.handbrake, Sound.ENTITY_MINECART_INSIDE, 1.0f, 0.0f);
                }
                this.plugin.getTrackerKeeper().getDematerialising().add(this.id);
                this.plugin.getPresetDestroyer().destroyPreset(dd);
            } else {
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("hidden", 0);
                HashMap<String, Object> whereh = new HashMap<String, Object>();
                whereh.put("tardis_id", this.id);
                this.plugin.getQueryFactory().doUpdate("tardis", set, whereh);
                this.plugin.getPresetDestroyer().removeBlockProtection(this.id);
            }
        }
    }
}

