/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.destroyers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.destroyers.Exterminator;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class TARDISPruner {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public TARDISPruner(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void list(CommandSender sender, int days) {
        long millis = this.getTime(days);
        Timestamp prune = this.getTimestamp(millis);
        String query = "SELECT * FROM " + this.prefix + "tardis WHERE lastuse < " + millis;
        try (Statement statement = this.connection.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            try {
                String file = String.valueOf(this.plugin.getDataFolder()) + File.separator + "TARDIS_Prune_List.txt";
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));){
                    if (rs.isBeforeFirst()) {
                        this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "Prune List:");
                    } else {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "PRUNE_NONE");
                    }
                    while (rs.next()) {
                        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, rs.getInt("tardis_id"));
                        if (rsc.resultSet()) {
                            Timestamp lastuse = new Timestamp(rs.getLong("lastuse"));
                            if (!lastuse.before(prune)) continue;
                            Current current = rsc.getCurrent();
                            String line = "Time Lord: " + rs.getString("owner") + ", Location: " + current.location().getWorld().getName() + ":" + current.location().getBlockX() + ":" + current.location().getBlockY() + ":" + current.location().getBlockZ();
                            bw.write(line);
                            bw.newLine();
                            sender.sendMessage(line);
                            continue;
                        }
                        this.plugin.debug(this.plugin.getLanguage().getString("CURRENT_NOT_FOUND"));
                    }
                }
                catch (IOException e) {
                    this.plugin.debug("Could not create and write to TARDIS_Prune_List.txt! " + e.getMessage());
                }
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error trying to display prune list! " + e.getMessage());
            }
        }
        catch (SQLException e) {
            this.plugin.debug(e.getMessage());
        }
    }

    public void prune(CommandSender sender, int days) {
        long millis = this.getTime(days);
        Timestamp prune = this.getTimestamp(millis);
        String query = "SELECT * FROM " + this.prefix + "tardis WHERE lastuse < " + millis;
        try (Statement statement = this.connection.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            try {
                Exterminator te = new Exterminator(this.plugin);
                while (rs.next()) {
                    Timestamp lastuse = new Timestamp(rs.getLong("lastuse"));
                    if (!lastuse.before(prune) || !te.pruneExterminate(rs.getInt("tardis_id"))) continue;
                    sender.sendMessage("Pruned " + rs.getString("owner") + "'s TARDIS");
                }
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error trying to prune! " + e.getMessage());
            }
        }
        catch (SQLException e) {
            this.plugin.debug(e.getMessage());
        }
    }

    private long getTime(int day) {
        long period = (long)day * 86400000L;
        long now = System.currentTimeMillis();
        return now - period;
    }

    private Timestamp getTimestamp(long l) {
        return new Timestamp(l);
    }
}

