/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import com.destroystokyo.paper.MaterialTags;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.ARSMethods;
import me.eccentric_nz.TARDIS.ARS.JettisonSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISBuilderInstanceKeeper;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.event.TARDISDesktopThemeEvent;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.builders.utility.FractalFence;
import me.eccentric_nz.TARDIS.console.ConsoleBuilder;
import me.eccentric_nz.TARDIS.console.ConsoleDestroyer;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Archive;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetARS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetScreenInteraction;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.desktop.ChunkUtils;
import me.eccentric_nz.TARDIS.desktop.DesktopThemeRunnable;
import me.eccentric_nz.TARDIS.desktop.UpgradeData;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.mobfarming.FollowerSpawner;
import me.eccentric_nz.TARDIS.rotors.TimeRotor;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.schematic.archive.ArchiveReset;
import me.eccentric_nz.TARDIS.schematic.archive.ResultSetArchiveByUse;
import me.eccentric_nz.TARDIS.schematic.setters.ArmourStandSetter;
import me.eccentric_nz.TARDIS.schematic.setters.BannerSetter;
import me.eccentric_nz.TARDIS.schematic.setters.HeadSetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemDisplaySetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemFrameSetter;
import me.eccentric_nz.TARDIS.schematic.setters.MannequinSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PaintingSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PotSetter;
import me.eccentric_nz.TARDIS.schematic.setters.SIDRATFenceSetter;
import me.eccentric_nz.TARDIS.schematic.setters.ShelfSetter;
import me.eccentric_nz.TARDIS.schematic.setters.SignSetter;
import me.eccentric_nz.TARDIS.utility.TARDISBannerData;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.protection.TARDISProtectionRemover;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Switch;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FullDesktopThemeRunnable
extends DesktopThemeRunnable {
    private final TARDIS plugin;
    private final UUID uuid;
    private final UpgradeData tud;
    private final HashMap<Block, BlockData> postBedBlocks = new HashMap();
    private final HashMap<Block, BlockData> postDoorBlocks = new HashMap();
    private final HashMap<Block, BlockData> postDripstoneBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLanternBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLeverBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLichenBlocks = new HashMap();
    private final HashMap<Block, BlockData> postPistonBaseBlocks = new HashMap();
    private final HashMap<Block, BlockData> postPistonExtensionBlocks = new HashMap();
    private final HashMap<Block, BlockData> postRedstoneTorchBlocks = new HashMap();
    private final HashMap<Block, BlockData> postRepeaterBlocks = new HashMap();
    private final HashMap<Block, BlockData> postSculkVeinBlocks = new HashMap();
    private final HashMap<Block, BlockData> postStickyPistonBaseBlocks = new HashMap();
    private final HashMap<Block, BlockData> postTorchBlocks = new HashMap();
    private final HashMap<Block, BlockData> sidratFenceBlocks = new HashMap();
    private final HashMap<Block, JsonObject> postSignBlocks = new HashMap();
    private final HashMap<Block, TARDISBannerData> postBannerBlocks = new HashMap();
    private final List<Block> fractalBlocks = new ArrayList<Block>();
    private final List<Block> iceBlocks = new ArrayList<Block>();
    private final List<Block> postLightBlocks = new ArrayList<Block>();
    private boolean running;
    private int id;
    private int slot;
    private int c;
    private int height;
    private int previousHeight;
    private int width;
    private int level = 0;
    private int row = 0;
    private int startX;
    private int startY;
    private int startZ;
    private int resetX;
    private int resetZ;
    private int j = 2;
    private World world;
    private List<Chunk> chunks;
    private List<Chunk> previousChunks;
    private Block postBedrock;
    private Location postOod;
    private JsonObject obj;
    private JsonArray arr;
    private Material wall_type;
    private Material floor_type;
    private HashMap<String, Object> set;
    private HashMap<String, Object> where;
    private boolean own_world;
    private Location wg1;
    private Location wg2;
    private boolean downgrade = false;
    private Chunk chunk;
    private Player player;
    private Location ender = null;
    private Archive archive_next;
    private Archive archive_prev;
    private ConsoleSize size_next;
    private ConsoleSize size_prev;

    FullDesktopThemeRunnable(TARDIS plugin, UUID uuid, UpgradeData tud) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.tud = tud;
    }

    @Override
    public void run() {
        if (!this.running) {
            Location loc;
            String uuids;
            Entity screen;
            ResultSetScreenInteraction rssi;
            JsonObject dimensions;
            int previousWidth;
            ResultSetArchiveByUse rs;
            if (this.tud.getSchematic().getPermission().equals("archive")) {
                rs = new ResultSetArchiveByUse(this.plugin, this.uuid.toString(), 1);
                if (rs.resultSet()) {
                    this.archive_next = rs.getArchive();
                } else {
                    Player cp = this.plugin.getServer().getPlayer(this.uuid);
                    this.plugin.getMessenger().send((CommandSender)cp, TardisModule.TARDIS, "ARCHIVE_NOT_FOUND");
                    new ArchiveReset(this.plugin, this.uuid.toString(), 1, 0).resetUse();
                    if (this.tud.getPrevious().getPermission().equals("archive")) {
                        new ArchiveReset(this.plugin, this.uuid.toString(), 2, 1).resetUse();
                    }
                    this.plugin.getServer().getScheduler().cancelTask(this.taskID);
                    return;
                }
            }
            if (this.tud.getPrevious().getPermission().equals("archive")) {
                rs = new ResultSetArchiveByUse(this.plugin, this.uuid.toString(), 2);
                if (rs.resultSet()) {
                    this.archive_prev = rs.getArchive();
                } else {
                    Player cp = this.plugin.getServer().getPlayer(this.uuid);
                    this.plugin.getMessenger().send((CommandSender)cp, TardisModule.TARDIS, "ARCHIVE_NOT_FOUND");
                    if (this.tud.getSchematic().getPermission().equals("archive")) {
                        new ArchiveReset(this.plugin, this.uuid.toString(), 1, 0).resetUse();
                    }
                    new ArchiveReset(this.plugin, this.uuid.toString(), 2, 1).resetUse();
                    this.plugin.getServer().getScheduler().cancelTask(this.taskID);
                    return;
                }
            }
            this.set = new HashMap();
            this.where = new HashMap();
            if (this.archive_next == null) {
                this.obj = SchematicGZip.getObject(this.plugin, "consoles", this.tud.getSchematic().getPermission(), this.tud.getSchematic().isCustom());
                if (this.obj == null) {
                    this.plugin.getServer().getScheduler().cancelTask(this.taskID);
                    return;
                }
                this.size_next = this.tud.getSchematic().getConsoleSize();
            } else {
                this.obj = this.archive_next.getJSON();
                this.size_next = this.archive_next.getConsoleSize();
            }
            if (this.archive_prev == null) {
                JsonObject prevObj = SchematicGZip.getObject(this.plugin, "consoles", this.tud.getPrevious().getPermission(), this.tud.getPrevious().isCustom());
                if (prevObj == null) {
                    this.plugin.getServer().getScheduler().cancelTask(this.taskID);
                    return;
                }
                JsonObject prevDimensions = prevObj.get("dimensions").getAsJsonObject();
                this.previousHeight = prevDimensions.get("height").getAsInt();
                previousWidth = prevDimensions.get("width").getAsInt();
                this.size_prev = this.tud.getPrevious().getConsoleSize();
            } else {
                dimensions = this.archive_prev.getJSON().get("dimensions").getAsJsonObject();
                this.previousHeight = dimensions.get("height").getAsInt();
                previousWidth = dimensions.get("width").getAsInt();
                this.size_prev = this.archive_prev.getConsoleSize();
            }
            dimensions = this.obj.get("dimensions").getAsJsonObject();
            this.height = dimensions.get("height").getAsInt();
            this.width = dimensions.get("width").getAsInt();
            this.c = dimensions.get("length").getAsInt();
            HashMap<String, Object> whereT = new HashMap<String, Object>();
            whereT.put("uuid", this.uuid.toString());
            ResultSetTardis rs2 = new ResultSetTardis(this.plugin, whereT, "", false);
            if (!rs2.resultSet()) {
                HashMap<String, Object> whereA = new HashMap<String, Object>();
                whereA.put("uuid", this.uuid.toString());
                int amount = this.plugin.getArtronConfig().getInt("upgrades." + this.tud.getSchematic().getPermission());
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", amount, whereA, this.player);
                if (this.tud.getSchematic().getPermission().equals("archive")) {
                    new ArchiveReset(this.plugin, this.uuid.toString(), 1, 0).resetUse();
                }
                if (this.tud.getPrevious().getPermission().equals("archive")) {
                    new ArchiveReset(this.plugin, this.uuid.toString(), 2, 1).resetUse();
                }
            }
            Tardis tardis = rs2.getTardis();
            this.slot = tardis.getTIPS();
            this.id = tardis.getTardisId();
            this.chunk = TARDISStaticLocationGetters.getChunk(tardis.getChunk());
            if (this.tud.getPrevious().getPermission().equals("ender")) {
                for (Entity entity : this.chunk.getEntities()) {
                    if (!entity.getType().equals((Object)EntityType.END_CRYSTAL)) continue;
                    entity.remove();
                }
            }
            HashMap<String, Object> whereRelDiff = new HashMap<String, Object>();
            whereRelDiff.put("tardis_id", this.id);
            whereRelDiff.put("type", 47);
            this.plugin.getQueryFactory().doDelete("controls", whereRelDiff);
            if (tardis.getRotor() != null) {
                ItemFrame itemFrame = TimeRotor.getItemFrame(tardis.getRotor());
                if (itemFrame != null) {
                    ItemFrame engine;
                    if (this.tud.getPrevious().getPermission().equals("mechanical") && (engine = ItemFrameSetter.getItemFrameFromLocation(itemFrame.getLocation().add(0.0, -4.0, 0.0))) != null) {
                        engine.setItem(null, false);
                        engine.remove();
                    }
                    itemFrame.setItem(null, false);
                    itemFrame.remove();
                }
                TimeRotor.updateRotorRecord(this.id, "");
                this.plugin.getGeneralKeeper().getTimeRotors().add(tardis.getRotor());
            }
            if ((rssi = new ResultSetScreenInteraction(this.plugin, this.id)).resultSet() && rssi.getUuid() != null && (screen = this.plugin.getServer().getEntity(rssi.getUuid())) != null && screen.getPersistentDataContainer().has(this.plugin.getUnaryKey(), PersistentDataType.STRING) && (uuids = (String)screen.getPersistentDataContainer().get(this.plugin.getUnaryKey(), PersistentDataType.STRING)) != null) {
                new ConsoleDestroyer(this.plugin).returnStack(uuids, this.id);
            }
            this.chunks = ChunkUtils.getConsoleChunks(this.chunk, this.tud.getSchematic());
            this.previousChunks = ChunkUtils.getConsoleChunks(this.chunk, this.tud.getPrevious());
            if (!tardis.getCreeper().isEmpty()) {
                Location creeper = TARDISStaticLocationGetters.getLocationFromDB(tardis.getCreeper());
                if (this.tud.getPrevious().getPermission().equals("division") || this.tud.getPrevious().getPermission().equals("hospital")) {
                    new FollowerSpawner(this.plugin).removeDivisionOod(creeper);
                }
                Entity ent = creeper.getWorld().spawnEntity(creeper, EntityType.EGG);
                ent.getNearbyEntities(1.5, 1.5, 1.5).forEach(e -> {
                    if (e instanceof Creeper) {
                        e.remove();
                    }
                });
                ent.remove();
            }
            if (this.slot != -1000001) {
                TARDISInteriorPostioning tintPos = new TARDISInteriorPostioning(this.plugin);
                TIPSData pos = tintPos.getTIPSData(this.slot);
                this.startX = pos.getCentreX();
                this.resetX = pos.getCentreX();
                this.startZ = pos.getCentreZ();
                this.resetZ = pos.getCentreZ();
            } else {
                int[] gsl = this.plugin.getLocationUtils().getStartLocation(tardis.getTardisId());
                this.startX = gsl[0];
                this.resetX = gsl[1];
                this.startZ = gsl[2];
                this.resetZ = gsl[3];
            }
            this.startY = this.tud.getSchematic().getPermission().equals("archive") ? this.archive_next.getY() : this.tud.getSchematic().getStartY();
            this.downgrade = this.height < this.previousHeight || this.width < previousWidth;
            this.world = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
            if (this.tud.getPrevious().getPermission().equals("cave")) {
                Block water = this.world.getBlockAt(this.startX + 1, this.startY + 9, this.startZ + 10);
                Block water2 = this.world.getBlockAt(this.startX + 8, this.startY + 14, this.startZ + 8);
                Block water3 = this.world.getBlockAt(this.startX + 8, this.startY + 14, this.startZ + 5);
                Block water4 = this.world.getBlockAt(this.startX + 8, this.startY + 13, this.startZ + 5);
                water.setType(Material.AIR);
                water2.setType(Material.AIR);
                water3.setType(Material.AIR);
                water4.setType(Material.AIR);
            }
            this.own_world = this.plugin.getConfig().getBoolean("creation.create_worlds");
            this.wg1 = new Location(this.world, (double)this.startX, (double)this.startY, (double)this.startZ);
            this.wg2 = new Location(this.world, (double)(this.startX + (this.width - 1)), (double)(this.startY + (this.height - 1)), (double)(this.startZ + (this.c - 1)));
            String[] wall = this.tud.getWall().split(":");
            String[] floor = this.tud.getFloor().split(":");
            this.wall_type = Material.valueOf((String)wall[0]);
            this.floor_type = Material.valueOf((String)floor[0]);
            this.arr = this.obj.get("input").getAsJsonArray();
            new TARDISProtectionRemover(this.plugin).cleanInteriorBlocks(this.id);
            this.running = true;
            this.player = this.plugin.getServer().getPlayer(this.uuid);
            this.plugin.getTrackerKeeper().getUpgrades().remove(this.uuid);
            if (this.tud.getSchematic().getPermission().equals("twelfth") || this.tud.getPrevious().getPermission().equals("twelfth")) {
                loc = this.chunk.getBlock(9, 69, 3).getLocation();
            } else {
                int floorLevel = this.tud.getSchematic().getPermission().equals("bigger") ? 70 : 69;
                loc = this.chunk.getBlock(8, floorLevel, 4).getLocation();
            }
            loc.getBlock().getRelative(BlockFace.DOWN).setType(Material.BARRIER);
            HashMap<String, Object> whereV = new HashMap<String, Object>();
            whereV.put("tardis_id", this.id);
            ResultSetTravellers rsv = new ResultSetTravellers(this.plugin, whereV, true);
            if (rsv.resultSet()) {
                rsv.getData().forEach(u -> {
                    Player pv = this.plugin.getServer().getPlayer(u);
                    if (pv != null) {
                        pv.teleport(loc);
                        this.plugin.getMessenger().send((CommandSender)pv, TardisModule.TARDIS, "UPGRADE_TELEPORT");
                    }
                });
            }
            HashMap<String, Object> whereL = new HashMap<String, Object>();
            whereL.put("tardis_id", this.id);
            this.plugin.getQueryFactory().doDelete("lamps", whereL);
            this.previousChunks.forEach(c -> TARDISDisplayItemUtils.removeEntitiesInChunk(c, 62, 64 + this.previousHeight));
            this.plugin.getPM().callEvent((Event)new TARDISDesktopThemeEvent(this.player, tardis, this.tud));
        }
        if (this.level == this.height - 1 && this.row == this.width - 1) {
            HashMap<String, Object> whereR = new HashMap<String, Object>();
            whereR.put("tardis_id", this.id);
            ResultSetARS rsa = new ResultSetARS(this.plugin, whereR);
            if (rsa.resultSet()) {
                String control;
                String[][][] existing = ARSMethods.getGridFromJSON(rsa.getJson());
                if (this.downgrade) {
                    switch (this.size_prev) {
                        case MASSIVE: {
                            existing[1][4][5] = "STONE";
                            existing[1][4][6] = "STONE";
                            existing[1][5][4] = "STONE";
                            existing[1][5][5] = "STONE";
                            existing[1][5][6] = "STONE";
                            existing[1][6][4] = "STONE";
                            existing[1][6][5] = "STONE";
                            existing[1][6][6] = "STONE";
                            existing[2][4][4] = "STONE";
                            existing[2][4][5] = "STONE";
                            existing[2][4][6] = "STONE";
                            existing[2][5][4] = "STONE";
                            existing[2][5][5] = "STONE";
                            existing[2][5][6] = "STONE";
                            existing[2][6][4] = "STONE";
                            existing[2][6][5] = "STONE";
                            existing[2][6][6] = "STONE";
                            break;
                        }
                        case WIDE: {
                            existing[1][4][5] = "STONE";
                            existing[1][4][6] = "STONE";
                            existing[1][5][4] = "STONE";
                            existing[1][5][5] = "STONE";
                            existing[1][5][6] = "STONE";
                            existing[1][6][4] = "STONE";
                            existing[1][6][5] = "STONE";
                            existing[1][6][6] = "STONE";
                            break;
                        }
                        case TALL: {
                            existing[1][4][5] = "STONE";
                            existing[1][5][4] = "STONE";
                            existing[1][5][5] = "STONE";
                            existing[2][4][4] = "STONE";
                            existing[2][4][5] = "STONE";
                            existing[2][5][4] = "STONE";
                            existing[2][5][5] = "STONE";
                            break;
                        }
                        case MEDIUM: {
                            existing[1][4][5] = "STONE";
                            existing[1][5][4] = "STONE";
                            existing[1][5][5] = "STONE";
                            break;
                        }
                    }
                }
                existing[1][4][4] = control = this.tud.getSchematic().getSeedMaterial().toString();
                switch (this.size_next) {
                    case MASSIVE: {
                        existing[1][4][5] = control;
                        existing[1][4][6] = control;
                        existing[1][5][4] = control;
                        existing[1][5][5] = control;
                        existing[1][5][6] = control;
                        existing[1][6][4] = control;
                        existing[1][6][5] = control;
                        existing[1][6][6] = control;
                        existing[2][4][4] = control;
                        existing[2][4][5] = control;
                        existing[2][4][6] = control;
                        existing[2][5][4] = control;
                        existing[2][5][5] = control;
                        existing[2][5][6] = control;
                        existing[2][6][4] = control;
                        existing[2][6][5] = control;
                        existing[2][6][6] = control;
                        break;
                    }
                    case WIDE: {
                        existing[1][4][5] = control;
                        existing[1][4][6] = control;
                        existing[1][5][4] = control;
                        existing[1][5][5] = control;
                        existing[1][5][6] = control;
                        existing[1][6][4] = control;
                        existing[1][6][5] = control;
                        existing[1][6][6] = control;
                        break;
                    }
                    case TALL: {
                        existing[1][4][5] = control;
                        existing[1][5][4] = control;
                        existing[1][5][5] = control;
                        existing[2][4][4] = control;
                        existing[2][4][5] = control;
                        existing[2][5][4] = control;
                        existing[2][5][5] = control;
                        break;
                    }
                    case MEDIUM: {
                        existing[1][4][5] = control;
                        existing[1][5][4] = control;
                        existing[1][5][5] = control;
                        break;
                    }
                }
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                JsonArray json = JsonParser.parseString((String)gson.toJson((Object)existing)).getAsJsonArray();
                HashMap<String, Object> seta = new HashMap<String, Object>();
                seta.put("json", json.toString());
                HashMap<String, Object> wheres = new HashMap<String, Object>();
                wheres.put("tardis_id", this.id);
                this.plugin.getQueryFactory().doUpdate("ars", seta, wheres);
            }
            this.previousChunks.forEach(chink -> {
                for (Entity e : chink.getEntities()) {
                    if (!(e instanceof Item)) continue;
                    e.remove();
                }
            });
            this.postBedBlocks.forEach(Block::setBlockData);
            this.postDoorBlocks.forEach(Block::setBlockData);
            this.postRedstoneTorchBlocks.forEach(Block::setBlockData);
            this.postLeverBlocks.forEach(Block::setBlockData);
            this.postTorchBlocks.forEach(Block::setBlockData);
            this.postLanternBlocks.forEach(Block::setBlockData);
            this.postRepeaterBlocks.forEach(Block::setBlockData);
            this.postDripstoneBlocks.forEach(Block::setBlockData);
            this.postLichenBlocks.forEach(Block::setBlockData);
            this.postSculkVeinBlocks.forEach(Block::setBlockData);
            this.postStickyPistonBaseBlocks.forEach(Block::setBlockData);
            this.postPistonBaseBlocks.forEach(Block::setBlockData);
            this.postPistonExtensionBlocks.forEach(Block::setBlockData);
            SignSetter.setSigns(this.postSignBlocks, this.plugin, this.id);
            BannerSetter.setBanners(this.postBannerBlocks);
            SIDRATFenceSetter.update(this.sidratFenceBlocks);
            this.postLightBlocks.forEach(block -> {
                if (block.getType().isAir()) {
                    Levelled levelled = TARDISConstants.LIGHT;
                    levelled.setLevel(15);
                    block.setBlockData((BlockData)levelled);
                }
            });
            if (this.tud.getSchematic().getPermission().equals("cave")) {
                this.iceBlocks.forEach(ice -> ice.setBlockData(TARDISConstants.WATER));
                this.iceBlocks.clear();
            }
            for (int f = 0; f < this.fractalBlocks.size(); ++f) {
                FractalFence.grow(this.fractalBlocks.get(f), f);
            }
            if (this.postBedrock != null) {
                this.postBedrock.setBlockData(TARDISConstants.GLASS);
            }
            if (this.postOod != null) {
                new FollowerSpawner(this.plugin).spawnDivisionOod(this.postOod);
            }
            if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && this.slot == -1) {
                this.plugin.getWorldGuardUtils().addWGProtection(this.player, this.wg1, this.wg2);
            }
            if (this.ender != null) {
                Entity ender_crystal = this.world.spawnEntity(this.ender, EntityType.END_CRYSTAL);
                ((EnderCrystal)ender_crystal).setShowingBottom(false);
            }
            if (this.obj.has("mannequins")) {
                JsonArray mannequins = this.obj.get("mannequins").getAsJsonArray();
                MannequinSetter.setMannequins(mannequins, this.world, this.resetX, this.startY, this.resetZ);
            }
            if (this.obj.has("armour_stands")) {
                JsonArray stands = this.obj.get("armour_stands").getAsJsonArray();
                ArmourStandSetter.setStands(stands, this.world, this.resetX, this.startY, this.resetZ);
            }
            if (this.obj.has("paintings")) {
                JsonArray paintings = (JsonArray)this.obj.get("paintings");
                PaintingSetter.setArt(paintings, this.world, this.resetX, this.startY, this.resetZ);
            }
            if (this.obj.has("item_frames")) {
                JsonArray frames = this.obj.get("item_frames").getAsJsonArray();
                ItemFrameSetter.curate(frames, this.wg1, this.id);
            }
            if (this.obj.has("item_displays")) {
                JsonArray displays = this.obj.get("item_displays").getAsJsonArray();
                ItemDisplaySetter.process(displays, this.player, this.wg1, this.id);
            }
            if (!this.set.isEmpty()) {
                this.where.put("tardis_id", this.id);
                this.plugin.getQueryFactory().doUpdate("tardis", this.set, this.where);
            }
            if (this.tud.getPrevious().getPermission().equals("archive") && !this.tud.getSchematic().getPermission().equals("archive")) {
                new ArchiveReset(this.plugin, this.uuid.toString(), 1, 0).resetUse();
            }
            if (this.downgrade) {
                if (this.tud.getPrevious().getPermission().equals("mechanical") || this.tud.getPrevious().getPermission().equals("cursed")) {
                    for (Chunk u2 : this.previousChunks) {
                        int cx = u2.getX() * 16;
                        int cz = u2.getZ() * 16;
                        for (int y = 63; y > 61; --y) {
                            for (int col = cx; col < cx + 16; ++col) {
                                for (int row = cz; row < cz + 16; ++row) {
                                    u2.getWorld().getBlockAt(row, y, col).setBlockData(TARDISConstants.AIR);
                                }
                            }
                        }
                    }
                }
                int minusY = this.tud.getPrevious().getPermission().equals("mechanical") ? 2 : 0;
                List<JettisonSlot> jettisons = this.getJettisons(this.size_next, this.size_prev, this.chunk);
                jettisons.forEach(jet -> this.setAir(jet.getX(), jet.getY(), jet.getZ(), jet.getChunk().getWorld(), minusY, 16));
                int tidy = this.startY + this.height;
                int plus = 16 - this.height;
                this.setAir(this.chunk.getBlock(0, 64, 0).getX(), tidy, this.chunk.getBlock(0, 64, 0).getZ(), this.chunk.getWorld(), 0, plus);
                for (Entity e2 : this.chunk.getEntities()) {
                    if (!(e2 instanceof Item)) continue;
                    e2.remove();
                }
                int big = this.plugin.getArtronConfig().getInt("upgrades." + this.tud.getPrevious().getPermission());
                int small = this.plugin.getArtronConfig().getInt("upgrades." + this.tud.getSchematic().getPermission());
                int refund = Math.round((float)this.plugin.getArtronConfig().getInt("jettison") / 100.0f * (float)(big - small));
                HashMap<String, Object> setR = new HashMap<String, Object>();
                setR.put("tardis_id", this.id);
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", refund, setR, null);
                if (this.player.isOnline()) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ENERGY_RECOVERED", String.format("%d", refund));
                }
            } else if (this.tud.getSchematic().getPermission().equals("coral") && this.tud.getPrevious().getConsoleSize().equals((Object)ConsoleSize.TALL)) {
                int tidy = this.startY + this.height;
                int plus = 32 - this.height;
                this.chunks.forEach(chk -> this.setAir(chk.getBlock(0, 64, 0).getX(), tidy, chk.getBlock(0, 64, 0).getZ(), chk.getWorld(), 0, plus));
            }
            HashMap<String, Object> whereC = new HashMap<String, Object>();
            whereC.put("tardis_id", this.id);
            this.plugin.getQueryFactory().doDelete("chunks", whereC);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.chunks.forEach(hunk -> {
                HashMap<String, Object> setC = new HashMap<String, Object>();
                setC.put("tardis_id", this.id);
                setC.put("world", this.world.getName());
                setC.put("x", hunk.getX());
                setC.put("z", hunk.getZ());
                this.plugin.getQueryFactory().doInsert("chunks", setC);
            }), 20L);
            this.plugin.getServer().getScheduler().cancelTask(this.taskID);
            this.taskID = 0;
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPGRADE_FINISHED");
        } else {
            JsonArray floor = this.arr.get(this.level).getAsJsonArray();
            JsonArray r = (JsonArray)floor.get(this.row);
            for (int col = 0; col < this.c; ++col) {
                JsonObject state;
                Bisected bisected;
                Material type;
                BlockData data;
                JsonObject bb = r.get(col).getAsJsonObject();
                int x = this.startX + this.row;
                int y = this.startY + this.level;
                int z = this.startZ + col;
                Block b = this.world.getBlockAt(x, y, z);
                if (b.getType().equals((Object)Material.BARRIER) || b.getType().equals((Object)Material.LIGHT)) {
                    TARDISDisplayItemUtils.remove(b);
                }
                try {
                    data = this.plugin.getServer().createBlockData(bb.get("data").getAsString());
                    type = data.getMaterial();
                }
                catch (IllegalArgumentException e3) {
                    String[] split1 = bb.get("data").getAsString().split("\\[");
                    Object split2 = split1[0].split(":");
                    String upper = split2[1].toUpperCase(Locale.ROOT);
                    type = Material.valueOf((String)upper);
                    data = this.plugin.getServer().createBlockData(type);
                }
                if (type.equals((Object)Material.BEDROCK)) {
                    String bedrockLoc = this.world.getName() + ":" + x + ":" + y + ":" + z;
                    this.set.put("beacon", bedrockLoc);
                    this.postBedrock = b;
                }
                if (type.equals((Object)Material.LIGHT_GRAY_CONCRETE) && (this.tud.getSchematic().getPermission().equals("bone") || this.tud.getSchematic().getPermission().equals("rustic") || this.tud.getSchematic().getPermission().equals("diner") || this.tud.getSchematic().getPermission().equals("hell_bent"))) {
                    Block block2 = new Location(this.world, (double)x, (double)y, (double)z).getBlock();
                    String ct = switch (this.tud.getSchematic().getPermission()) {
                        case "bone" -> "console_light_gray";
                        case "rustic" -> "console_rustic";
                        default -> "console_white";
                    };
                    new ConsoleBuilder(this.plugin).create(block2, ct, this.id, this.uuid.toString());
                }
                if (type.equals((Object)Material.SCULK_SHRIEKER)) {
                    String shrieker = new Location(this.world, (double)x, (double)y, (double)z).toString();
                    TimeRotor.updateRotorRecord(this.id, shrieker);
                }
                if (type.equals((Object)Material.NOTE_BLOCK)) {
                    String storage = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                    this.plugin.getQueryFactory().insertSyncControl(this.id, 14, storage, 0);
                    data = TARDISConstants.BARRIER;
                    TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.DISK_STORAGE, this.world, x, y, z);
                }
                if (type.equals((Object)Material.ORANGE_WOOL)) {
                    if (this.wall_type == Material.ORANGE_WOOL) {
                        if (!TARDISFloodgate.isFloodgateEnabled() || !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId())) {
                            data = TARDISConstants.BARRIER;
                            TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.HEXAGON, this.world, x, y, z);
                        }
                    } else {
                        data = this.wall_type.createBlockData();
                    }
                }
                if (!(!type.equals((Object)Material.BLUE_WOOL) || TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId()))) {
                    data = TARDISConstants.BARRIER;
                    TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.BLUE_BOX, this.world, x, y, z);
                }
                if ((type.equals((Object)Material.WARPED_FENCE) || type.equals((Object)Material.CRIMSON_FENCE)) && this.tud.getSchematic().getPermission().equals("delta")) {
                    this.fractalBlocks.add(b);
                }
                if (type.equals((Object)Material.DEEPSLATE_REDSTONE_ORE) && (this.tud.getSchematic().getPermission().equals("division") || this.tud.getSchematic().getPermission().equals("hospital"))) {
                    BlockData blockData = data = this.tud.getSchematic().getPermission().equals("division") ? Material.GRAY_CONCRETE.createBlockData() : Material.LIGHT_GRAY_CONCRETE.createBlockData();
                    if (this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
                        this.postOod = new Location(this.world, (double)x, (double)(y + 1), (double)z);
                    }
                }
                if (this.level == 0 && type.equals((Object)Material.PINK_STAINED_GLASS) && this.tud.getSchematic().getPermission().equals("division")) {
                    this.postLightBlocks.add(this.world.getBlockAt(x, y - 1, z));
                }
                if (type.equals((Object)Material.WHITE_STAINED_GLASS) && (this.tud.getSchematic().getPermission().equals("war") || this.tud.getSchematic().getPermission().equals("diner") || this.tud.getSchematic().getPermission().equals("hell_bent")) && (!TARDISFloodgate.isFloodgateEnabled() || !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId()))) {
                    data = TARDISConstants.BARRIER;
                    TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.ROUNDEL, this.world, x, y, z);
                }
                if (type.equals((Object)Material.WHITE_TERRACOTTA) && (this.tud.getSchematic().getPermission().equals("war") || this.tud.getSchematic().getPermission().equals("diner") || this.tud.getSchematic().getPermission().equals("hell_bent")) && (!TARDISFloodgate.isFloodgateEnabled() || !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId()))) {
                    data = TARDISConstants.BARRIER;
                    TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.ROUNDEL_OFFSET, this.world, x, y, z);
                }
                if (type.equals((Object)Material.LIGHT_GRAY_WOOL)) {
                    data = this.floor_type.createBlockData();
                }
                if (type.equals((Object)Material.SPAWNER)) {
                    String scanner = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                    this.plugin.getQueryFactory().insertSyncControl(this.id, 33, scanner, 0);
                }
                if (type.equals((Object)Material.CHEST)) {
                    String condenser = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                    this.plugin.getQueryFactory().insertSyncControl(this.id, 34, condenser, 0);
                }
                if (type.equals((Object)Material.IRON_DOOR) && (bisected = (Bisected)data).getHalf().equals((Object)Bisected.Half.BOTTOM)) {
                    HashMap<String, Object> setD = new HashMap<String, Object>();
                    String doorLoc = this.world.getName() + ":" + x + ":" + y + ":" + z;
                    setD.put("door_location", doorLoc);
                    HashMap<String, Object> whereD = new HashMap<String, Object>();
                    whereD.put("tardis_id", this.id);
                    whereD.put("door_type", 1);
                    this.plugin.getQueryFactory().doUpdate("doors", setD, whereD);
                    if (this.own_world) {
                        this.world.setSpawnLocation(x, y, z + 1);
                    }
                }
                if (type.equals((Object)Material.STONE_BUTTON)) {
                    String button = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                    this.plugin.getQueryFactory().insertSyncControl(this.id, 1, button, 0);
                }
                if (!(!type.equals((Object)Material.JUKEBOX) || this.tud.getSchematic().getPermission().equals("eighth") && this.world.getBlockAt(x, y, z).getRelative(BlockFace.DOWN).getType() == Material.ANDESITE || this.tud.getSchematic().getPermission().equals("diner") && this.world.getBlockAt(x, y, z).getRelative(BlockFace.DOWN).getType() == Material.WHITE_CONCRETE)) {
                    String advanced = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                    this.plugin.getQueryFactory().insertSyncControl(this.id, 15, advanced, 0);
                    data = TARDISConstants.BARRIER;
                    TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.ADVANCED_CONSOLE, this.world, x, y, z);
                }
                if (type.equals((Object)Material.CAKE)) {
                    if (this.tud.getSchematic().getPermission().equals("rustic") || this.tud.getSchematic().getPermission().equals("diner") || this.tud.getSchematic().getPermission().equals("hell_bent") || this.tud.getSchematic().getPermission().equals("bone")) {
                        HashMap<String, Object> whereD = new HashMap<String, Object>();
                        whereD.put("tardis_id", this.id);
                        whereD.put("type", 0);
                        whereD.put("secondary", 0);
                        this.plugin.getQueryFactory().doDelete("controls", whereD);
                    } else {
                        String handbrakeLoc = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                        this.plugin.getQueryFactory().insertSyncControl(this.id, 0, handbrakeLoc, 0);
                    }
                    if (this.tud.getSchematic().getPermission().equals("sidrat")) {
                        BlockData blockData = Material.LEVER.createBlockData();
                        Switch lever = (Switch)blockData;
                        lever.setAttachedFace(FaceAttachable.AttachedFace.WALL);
                        lever.setFacing(BlockFace.WEST);
                        data = lever;
                    }
                }
                if (type.equals((Object)Material.LIGHT)) {
                    HashMap<String, Object> setLB = new HashMap<String, Object>();
                    Object lightLoc = this.world.getName() + ":" + x + ":" + y + ":" + z;
                    setLB.put("tardis_id", this.id);
                    setLB.put("location", lightLoc);
                    this.plugin.getQueryFactory().doInsert("lamps", setLB);
                }
                if (type.equals((Object)Material.ICE) && this.tud.getSchematic().getPermission().equals("cave")) {
                    this.iceBlocks.add(b);
                }
                if (type.equals((Object)Material.PALE_OAK_FENCE) && this.tud.getSchematic().getPermission().equals("sidrat")) {
                    this.sidratFenceBlocks.put(b, data);
                }
                if (type.equals((Object)Material.COMMAND_BLOCK) || (this.tud.getSchematic().getPermission().equals("bigger") || this.tud.getSchematic().getPermission().equals("coral") || this.tud.getSchematic().getPermission().equals("deluxe") || this.tud.getSchematic().getPermission().equals("twelfth")) && type.equals((Object)Material.BEACON)) {
                    String creepLoc = this.world.getName() + ":" + ((double)x + 0.5) + ":" + y + ":" + ((double)z + 0.5);
                    this.set.put("creeper", creepLoc);
                    if (type.equals((Object)Material.COMMAND_BLOCK)) {
                        switch (this.tud.getSchematic().getPermission()) {
                            case "ender": {
                                BlockData blockData = Material.END_STONE_BRICKS.createBlockData();
                                break;
                            }
                            case "delta": 
                            case "cursed": {
                                BlockData blockData = Material.BLACKSTONE.createBlockData();
                                break;
                            }
                            case "ancient": 
                            case "bone": 
                            case "fugitive": {
                                BlockData blockData = Material.GRAY_WOOL.createBlockData();
                                break;
                            }
                            case "hospital": {
                                BlockData blockData = Material.LIGHT_GRAY_WOOL.createBlockData();
                                break;
                            }
                            case "sidrat": {
                                BlockData blockData = Material.RED_CONCRETE.createBlockData();
                                break;
                            }
                            default: {
                                BlockData blockData = data = Material.STONE_BRICKS.createBlockData();
                            }
                        }
                    }
                }
                if (type.equals((Object)Material.OAK_BUTTON)) {
                    String woodButtonLoc = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                    this.plugin.getQueryFactory().insertSyncControl(this.id, 6, woodButtonLoc, 0);
                }
                if (type.equals((Object)Material.DAYLIGHT_DETECTOR)) {
                    String telepathicLoc = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                    this.plugin.getQueryFactory().insertSyncControl(this.id, 23, telepathicLoc, 0);
                }
                if (type.equals((Object)Material.BEACON) && this.tud.getSchematic().getPermission().equals("ender")) {
                    this.ender = b.getLocation().add(0.5, 4.0, 0.5);
                }
                if (TARDISBuilderInstanceKeeper.getPrecious().contains(type)) {
                    HashMap<String, Object> setPB = new HashMap<String, Object>();
                    String loc = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                    setPB.put("tardis_id", this.id);
                    setPB.put("location", loc);
                    setPB.put("data", "minecraft:air");
                    setPB.put("police_box", 0);
                    this.plugin.getQueryFactory().doInsert("blocks", setPB);
                    this.plugin.getGeneralKeeper().getProtectBlockMap().put(loc, this.id);
                }
                if (type.equals((Object)Material.IRON_DOOR)) {
                    this.postDoorBlocks.put(b, data);
                    continue;
                }
                if (Tag.BEDS.isTagged((Keyed)type)) {
                    this.postBedBlocks.put(b, data);
                    continue;
                }
                if (type.equals((Object)Material.LEVER)) {
                    this.postLeverBlocks.put(b, data);
                    continue;
                }
                if (type.equals((Object)Material.REDSTONE_TORCH) || type.equals((Object)Material.REDSTONE_WALL_TORCH)) {
                    this.postRedstoneTorchBlocks.put(b, data);
                    continue;
                }
                if (type.equals((Object)Material.TORCH) || type.equals((Object)Material.WALL_TORCH) || type.equals((Object)Material.SOUL_TORCH) || type.equals((Object)Material.SOUL_WALL_TORCH)) {
                    this.postTorchBlocks.put(b, data);
                    continue;
                }
                if (type.equals((Object)Material.STICKY_PISTON)) {
                    this.postStickyPistonBaseBlocks.put(b, data);
                    continue;
                }
                if (type.equals((Object)Material.PISTON)) {
                    this.postPistonBaseBlocks.put(b, data);
                    continue;
                }
                if (type.equals((Object)Material.PISTON_HEAD)) {
                    this.postPistonExtensionBlocks.put(b, data);
                    continue;
                }
                if (Tag.ALL_SIGNS.isTagged((Keyed)type)) {
                    this.postSignBlocks.put(b, bb);
                    continue;
                }
                if (type.equals((Object)Material.POINTED_DRIPSTONE)) {
                    this.postDripstoneBlocks.put(b, data);
                    continue;
                }
                if (type.equals((Object)Material.GLOW_LICHEN)) {
                    this.postLichenBlocks.put(b, data);
                    continue;
                }
                if (type.equals((Object)Material.LANTERN) || type.equals((Object)Material.SOUL_LANTERN)) {
                    this.postLanternBlocks.put(b, data);
                    continue;
                }
                if (type.equals((Object)Material.SCULK_VEIN)) {
                    this.postSculkVeinBlocks.put(b, data);
                    continue;
                }
                if (Tag.BANNERS.isTagged((Keyed)type)) {
                    JsonObject jsonObject = state = bb.has("banner") ? bb.getAsJsonObject("banner") : null;
                    if (state == null) continue;
                    TARDISBannerData tbd = new TARDISBannerData(data, state);
                    this.postBannerBlocks.put(b, tbd);
                    continue;
                }
                if (type.equals((Object)Material.PLAYER_HEAD) || type.equals((Object)Material.PLAYER_WALL_HEAD)) {
                    JsonObject head;
                    TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                    if (!bb.has("head") || !(head = bb.get("head").getAsJsonObject()).has("uuid")) continue;
                    try {
                        UUID uuid = UUID.fromString(head.get("uuid").getAsString());
                        HeadSetter.textureSkull(this.plugin, uuid, head, b);
                    }
                    catch (IllegalArgumentException uuid) {}
                    continue;
                }
                if (type.equals((Object)Material.DECORATED_POT)) {
                    TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                    if (!bb.has("pot")) continue;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> PotSetter.decorate(this.plugin, bb.get("pot").getAsJsonObject(), b), 1L);
                    continue;
                }
                if (Tag.WOODEN_SHELVES.isTagged((Keyed)type)) {
                    TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                    if (!bb.has("items")) continue;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ShelfSetter.stock(b, bb.get("items").getAsJsonArray()), 3L);
                    continue;
                }
                if (MaterialTags.INFESTED_BLOCKS.isTagged(type)) {
                    TARDISBlockSetters.setBlock(this.world, x, y, z, Material.AIR);
                    continue;
                }
                if (type.equals((Object)Material.MUSHROOM_STEM)) {
                    if (this.j >= 6) continue;
                    String repeater = this.world.getName() + ":" + x + ":" + y + ":" + z;
                    data = Material.REPEATER.createBlockData();
                    Directional directional = (Directional)data;
                    switch (this.j) {
                        case 2: {
                            directional.setFacing(BlockFace.WEST);
                            this.postRepeaterBlocks.put(b, (BlockData)directional);
                            this.plugin.getQueryFactory().insertSyncControl(this.id, 3, repeater, 0);
                            break;
                        }
                        case 3: {
                            directional.setFacing(BlockFace.NORTH);
                            this.postRepeaterBlocks.put(b, (BlockData)directional);
                            this.plugin.getQueryFactory().insertSyncControl(this.id, 2, repeater, 0);
                            break;
                        }
                        case 4: {
                            directional.setFacing(BlockFace.SOUTH);
                            this.postRepeaterBlocks.put(b, (BlockData)directional);
                            this.plugin.getQueryFactory().insertSyncControl(this.id, 5, repeater, 0);
                            break;
                        }
                        default: {
                            directional.setFacing(BlockFace.EAST);
                            this.postRepeaterBlocks.put(b, (BlockData)directional);
                            this.plugin.getQueryFactory().insertSyncControl(this.id, 4, repeater, 0);
                        }
                    }
                    ++this.j;
                    continue;
                }
                if (type.equals((Object)Material.BROWN_MUSHROOM) && this.tud.getSchematic().getPermission().equals("master")) {
                    TARDISBlockSetters.setBlock(this.world, x, y, z, Material.AIR);
                    this.plugin.setTardisSpawn(true);
                    this.world.spawnEntity(new Location(this.world, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5), EntityType.VILLAGER);
                    continue;
                }
                if (type.equals((Object)Material.SPONGE)) {
                    TARDISBlockSetters.setBlock(this.world, x, y, z, Material.AIR);
                    continue;
                }
                state = b.getState();
                this.plugin.getTardisHelper().removeTileEntity((BlockState)state);
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
            }
            this.chunks.forEach(chink -> {
                for (Entity e : chink.getEntities()) {
                    if (!(e instanceof Item)) continue;
                    e.remove();
                }
            });
            if (this.row < this.width) {
                ++this.row;
            }
            if (this.row == this.width && this.level < this.height) {
                this.row = 0;
                ++this.level;
            }
        }
    }

    private List<JettisonSlot> getJettisons(ConsoleSize next, ConsoleSize prev, Chunk chunk) {
        ArrayList<JettisonSlot> list = new ArrayList<JettisonSlot>();
        block0 : switch (prev) {
            case MASSIVE: {
                switch (next) {
                    case WIDE: {
                        list.add(new JettisonSlot(chunk, 2, 4, 4));
                        list.add(new JettisonSlot(chunk, 2, 4, 5));
                        list.add(new JettisonSlot(chunk, 2, 4, 6));
                        list.add(new JettisonSlot(chunk, 2, 5, 4));
                        list.add(new JettisonSlot(chunk, 2, 5, 5));
                        list.add(new JettisonSlot(chunk, 2, 5, 6));
                        list.add(new JettisonSlot(chunk, 2, 6, 4));
                        list.add(new JettisonSlot(chunk, 2, 6, 5));
                        list.add(new JettisonSlot(chunk, 2, 6, 6));
                        break block0;
                    }
                    case TALL: {
                        list.add(new JettisonSlot(chunk, 1, 4, 6));
                        list.add(new JettisonSlot(chunk, 1, 5, 6));
                        list.add(new JettisonSlot(chunk, 1, 6, 4));
                        list.add(new JettisonSlot(chunk, 1, 6, 5));
                        list.add(new JettisonSlot(chunk, 1, 6, 6));
                        list.add(new JettisonSlot(chunk, 2, 4, 6));
                        list.add(new JettisonSlot(chunk, 2, 5, 6));
                        list.add(new JettisonSlot(chunk, 2, 6, 4));
                        list.add(new JettisonSlot(chunk, 2, 6, 5));
                        list.add(new JettisonSlot(chunk, 2, 6, 6));
                        break block0;
                    }
                    case MEDIUM: {
                        list.add(new JettisonSlot(chunk, 1, 4, 6));
                        list.add(new JettisonSlot(chunk, 1, 5, 6));
                        list.add(new JettisonSlot(chunk, 1, 6, 4));
                        list.add(new JettisonSlot(chunk, 1, 6, 5));
                        list.add(new JettisonSlot(chunk, 1, 6, 6));
                        list.add(new JettisonSlot(chunk, 2, 4, 4));
                        list.add(new JettisonSlot(chunk, 2, 4, 5));
                        list.add(new JettisonSlot(chunk, 2, 4, 6));
                        list.add(new JettisonSlot(chunk, 2, 5, 4));
                        list.add(new JettisonSlot(chunk, 2, 5, 5));
                        list.add(new JettisonSlot(chunk, 2, 5, 6));
                        list.add(new JettisonSlot(chunk, 2, 6, 4));
                        list.add(new JettisonSlot(chunk, 2, 6, 5));
                        list.add(new JettisonSlot(chunk, 2, 6, 6));
                        break block0;
                    }
                    case SMALL: {
                        list.add(new JettisonSlot(chunk, 1, 4, 5));
                        list.add(new JettisonSlot(chunk, 1, 4, 6));
                        list.add(new JettisonSlot(chunk, 1, 5, 4));
                        list.add(new JettisonSlot(chunk, 1, 5, 5));
                        list.add(new JettisonSlot(chunk, 1, 5, 6));
                        list.add(new JettisonSlot(chunk, 1, 6, 4));
                        list.add(new JettisonSlot(chunk, 1, 6, 5));
                        list.add(new JettisonSlot(chunk, 1, 6, 6));
                        list.add(new JettisonSlot(chunk, 2, 4, 4));
                        list.add(new JettisonSlot(chunk, 2, 4, 5));
                        list.add(new JettisonSlot(chunk, 2, 4, 6));
                        list.add(new JettisonSlot(chunk, 2, 5, 4));
                        list.add(new JettisonSlot(chunk, 2, 5, 5));
                        list.add(new JettisonSlot(chunk, 2, 5, 6));
                        list.add(new JettisonSlot(chunk, 2, 6, 4));
                        list.add(new JettisonSlot(chunk, 2, 6, 5));
                        list.add(new JettisonSlot(chunk, 2, 6, 6));
                        break block0;
                    }
                }
                break;
            }
            case TALL: {
                switch (next) {
                    case WIDE: 
                    case MEDIUM: {
                        list.add(new JettisonSlot(chunk, 2, 4, 4));
                        list.add(new JettisonSlot(chunk, 2, 4, 5));
                        list.add(new JettisonSlot(chunk, 2, 5, 4));
                        list.add(new JettisonSlot(chunk, 2, 5, 5));
                        break block0;
                    }
                    case SMALL: {
                        list.add(new JettisonSlot(chunk, 1, 4, 5));
                        list.add(new JettisonSlot(chunk, 1, 5, 4));
                        list.add(new JettisonSlot(chunk, 1, 5, 5));
                        list.add(new JettisonSlot(chunk, 2, 4, 4));
                        list.add(new JettisonSlot(chunk, 2, 4, 5));
                        list.add(new JettisonSlot(chunk, 2, 5, 4));
                        list.add(new JettisonSlot(chunk, 2, 5, 5));
                        break block0;
                    }
                }
                break;
            }
            case WIDE: {
                switch (next) {
                    case TALL: 
                    case MEDIUM: {
                        list.add(new JettisonSlot(chunk, 1, 4, 6));
                        list.add(new JettisonSlot(chunk, 1, 5, 6));
                        list.add(new JettisonSlot(chunk, 1, 6, 4));
                        list.add(new JettisonSlot(chunk, 1, 6, 5));
                        list.add(new JettisonSlot(chunk, 1, 6, 6));
                        break block0;
                    }
                    case SMALL: {
                        list.add(new JettisonSlot(chunk, 1, 4, 5));
                        list.add(new JettisonSlot(chunk, 1, 4, 6));
                        list.add(new JettisonSlot(chunk, 1, 5, 4));
                        list.add(new JettisonSlot(chunk, 1, 5, 5));
                        list.add(new JettisonSlot(chunk, 1, 5, 6));
                        list.add(new JettisonSlot(chunk, 1, 6, 4));
                        list.add(new JettisonSlot(chunk, 1, 6, 5));
                        list.add(new JettisonSlot(chunk, 1, 6, 6));
                        break block0;
                    }
                }
                break;
            }
            case MEDIUM: {
                if (next != ConsoleSize.SMALL) break;
                list.add(new JettisonSlot(chunk, 1, 4, 5));
                list.add(new JettisonSlot(chunk, 1, 5, 4));
                list.add(new JettisonSlot(chunk, 1, 5, 5));
                break;
            }
        }
        return list;
    }

    private void setAir(int jx, int jy, int jz, World jw, int minusY, int plusY) {
        for (int yy = jy - minusY; yy < jy + plusY; ++yy) {
            for (int xx = jx; xx < jx + 16; ++xx) {
                for (int zz = jz; zz < jz + 16; ++zz) {
                    Block b = jw.getBlockAt(xx, yy, zz);
                    this.world.setBiome(xx, yy, zz, Biome.THE_VOID);
                    BlockState state = b.getState();
                    this.plugin.getTardisHelper().removeTileEntity(state);
                    b.setBlockData(TARDISConstants.AIR);
                }
            }
        }
    }
}

