/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetRegenerations {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private int artronLevel = 0;
    private int count = 0;
    private boolean regenBlockOn = false;

    public ResultSetRegenerations(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromUUID(String uuid) {
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT artron_level, regenerations, regen_block_on FROM " + this.prefix + "player_prefs WHERE " + this.prefix + "player_prefs.uuid = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, uuid);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.artronLevel = rs.getInt("artron_level");
                    this.count = rs.getInt("regenerations");
                    this.regenBlockOn = rs.getBoolean("regen_block_on");
                    break block16;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for player_prefs (regenerations from UUID) table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing player_prefs (regenerations from UUID) statement! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getArtronLevel() {
        return this.artronLevel;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isRegenBlockOn() {
        return this.regenBlockOn;
    }
}

