/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.telepathic;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.console.telepathic.TelepathicBiome;
import me.eccentric_nz.TARDIS.console.telepathic.TelepathicInventory;
import me.eccentric_nz.TARDIS.console.telepathic.TelepathicStructure;
import me.eccentric_nz.TARDIS.custommodels.keys.SwitchVariant;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TelepathicGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TelepathicGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onTelepathicMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TelepathicInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String uuid = player.getUniqueId().toString();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid);
        ResultSetTravellers rs = new ResultSetTravellers(this.plugin, where, false);
        if (rs.resultSet()) {
            CircuitChecker tcc = null;
            if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true)) {
                tcc = new CircuitChecker(this.plugin, rs.getTardis_id());
                tcc.getCircuits();
            }
            if (tcc != null && !tcc.hasTelepathic()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TELEPATHIC_CIRCUIT");
                event.setCancelled(true);
                return;
            }
            int slot = event.getRawSlot();
            if (slot < 0 || slot > 53) {
                ClickType click = event.getClick();
                if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                    this.plugin.debug("TelepathicGUIListener");
                    event.setCancelled(true);
                }
                return;
            }
            event.setCancelled(true);
            ItemStack choice = event.getView().getItem(slot);
            if (slot > 0 && slot < 8 && this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid, SystemTree.TELEPATHIC_CIRCUIT)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Telepathic Circuit");
                return;
            }
            switch (slot) {
                case 0: {
                    ItemMeta im = choice.getItemMeta();
                    int b = im.hasLore() && ComponentUtils.endsWith((Component)im.lore().getFirst(), "ON") ? 0 : 1;
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    HashMap<String, Object> whereu = new HashMap<String, Object>();
                    whereu.put("uuid", player.getUniqueId().toString());
                    set.put("telepathy_on", b);
                    this.plugin.getQueryFactory().doUpdate("player_prefs", set, whereu);
                    NamespacedKey model = im.getItemModel();
                    im.setItemModel(model == SwitchVariant.TELEPATHIC_CIRCUIT_OFF.getKey() ? SwitchVariant.TELEPATHIC_CIRCUIT_ON.getKey() : SwitchVariant.TELEPATHIC_CIRCUIT_OFF.getKey());
                    choice.setItemMeta(im);
                    this.plugin.getMessenger().announceRepeater(player, "Telepathic Circuit " + (b == 1 ? "ON" : "OFF"));
                    this.close(player);
                    break;
                }
                case 2: {
                    if (choice == null) break;
                    player.performCommand("tardistravel cave");
                    this.close(player);
                    break;
                }
                case 4: {
                    if (choice == null) break;
                    player.openInventory(new TelepathicStructure(this.plugin).getInventory());
                    break;
                }
                case 6: {
                    if (choice == null) break;
                    player.openInventory(new TelepathicBiome(this.plugin, rs.getTardis_id()).getInventory());
                    break;
                }
                case 8: {
                    this.close(player);
                    break;
                }
            }
        }
    }
}

