/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.RoomsWorld;
import me.eccentric_nz.TARDIS.planets.TARDISAcidWater;
import me.eccentric_nz.TARDIS.planets.TARDISGallifreySpawnListener;
import me.eccentric_nz.TARDIS.planets.TARDISSiluriaSpawnListener;
import me.eccentric_nz.TARDIS.planets.TARDISSkaroSpawnListener;
import me.eccentric_nz.TARDIS.planets.TARDISTelosSpawnListener;
import me.eccentric_nz.TARDIS.planets.TARDISVastialListener;
import me.eccentric_nz.TARDIS.planets.WorldLoader;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.GameRules;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WorldUtility {
    public static void disable(TARDIS plugin, CommandSender sender, World world) {
        String w = world.getName();
        if (!plugin.getPlanetsConfig().contains("planets." + w)) {
            plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld load", plugin);
            return;
        }
        plugin.getPlanetsConfig().set("planets." + w + ".enabled", (Object)false);
        plugin.savePlanetsConfig();
        plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_DISABLED", w);
        if (TARDISConstants.isTARDISPlanetExact(w)) {
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_DISABLED_RESTART");
        }
        Location spawn = ((World)plugin.getServer().getWorlds().getFirst()).getSpawnLocation();
        for (Player player : world.getPlayers()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WORLD_DISABLED_TELEPORT");
            player.teleport(spawn);
        }
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> plugin.getServer().unloadWorld(world, true), 5L);
    }

    public static void enable(TARDIS plugin, CommandSender sender, String world) {
        if (!plugin.getPlanetsConfig().contains("planets." + world)) {
            plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld load", plugin);
            return;
        }
        plugin.getPlanetsConfig().set("planets." + world + ".enabled", (Object)true);
        plugin.savePlanetsConfig();
        plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_ENABLED", world);
        if (TARDISConstants.isTARDISPlanetExact(world)) {
            switch (world) {
                case "rooms": {
                    plugin.debug("Rooms world enabled, checking transmat location");
                    new RoomsWorld().check(plugin);
                    break;
                }
                case "gallifrey": {
                    plugin.debug("Gallifrey enabled, registering planet event listeners");
                    plugin.getPM().registerEvents((Listener)new TARDISGallifreySpawnListener(plugin), (Plugin)plugin);
                    break;
                }
                case "siluria": {
                    plugin.debug("Siluria enabled, registering planet event listeners");
                    if (!plugin.getConfig().getBoolean("modules.weeping_angels")) break;
                    plugin.getPM().registerEvents((Listener)new TARDISSiluriaSpawnListener(plugin), (Plugin)plugin);
                    break;
                }
                case "skaro": {
                    plugin.debug("Skaro enabled, registering planet event listeners");
                    if (plugin.getPlanetsConfig().getBoolean("planets.skaro.acid")) {
                        plugin.getPM().registerEvents((Listener)new TARDISAcidWater(plugin), (Plugin)plugin);
                    }
                    if (!plugin.getConfig().getBoolean("modules.weeping_angels")) break;
                    plugin.getPM().registerEvents((Listener)new TARDISSkaroSpawnListener(plugin), (Plugin)plugin);
                    break;
                }
                default: {
                    plugin.debug("Telos enabled, registering planet event listeners");
                    if (plugin.getPlanetsConfig().getBoolean("planets.telos.vastial.enabled")) {
                        plugin.getPM().registerEvents((Listener)new TARDISVastialListener(plugin), (Plugin)plugin);
                    }
                    plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
                        if (plugin.getPlanetsConfig().getBoolean("planets.telos.twilight")) {
                            World telos = plugin.getServer().getWorld("telos");
                            if (telos != null) {
                                telos.setTime(13000L);
                                telos.setGameRule(GameRules.ADVANCE_TIME, (Object)false);
                                plugin.getPlanetsConfig().set("planets.telos.gamerules.advance_time", (Object)false);
                            }
                        } else {
                            plugin.getPlanetsConfig().set("planets.telos.gamerules.advance_time", (Object)true);
                        }
                        String planetsPath = String.valueOf(plugin.getDataFolder()) + File.separator + "planets.yml";
                        try {
                            plugin.getPlanetsConfig().save(new File(planetsPath));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }, 300L);
                    if (!plugin.getConfig().getBoolean("modules.weeping_angels")) break;
                    plugin.getPM().registerEvents((Listener)new TARDISTelosSpawnListener(plugin), (Plugin)plugin);
                }
            }
        }
        new WorldLoader(plugin).loadWorld(world);
    }

    public static void load(TARDIS plugin, CommandSender sender, String name, String type, String env, String gen) {
        WorldType worldType = WorldType.NORMAL;
        World.Environment environment = World.Environment.NORMAL;
        WorldCreator creator = new WorldCreator(name);
        if (!type.isEmpty()) {
            try {
                worldType = WorldType.valueOf((String)type.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_TYPE", type);
                return;
            }
        }
        creator.type(worldType);
        if (!env.isEmpty()) {
            try {
                environment = World.Environment.valueOf((String)env.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_ENV", env);
                return;
            }
        }
        creator.environment(environment);
        if (!gen.isEmpty()) {
            String[] split = gen.split(":", 2);
            Plugin p = plugin.getPM().getPlugin(split[0]);
            if (p == null) {
                plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_GEN", gen);
                return;
            }
            creator.generator(gen);
        }
        if (creator.createWorld() == null) {
            plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld load", plugin);
            return;
        }
        plugin.getPlanetsConfig().set("planets." + name + ".enabled", (Object)true);
        plugin.getPlanetsConfig().set("planets." + name + ".resource_pack", (Object)"default");
        plugin.getPlanetsConfig().set("planets." + name + ".gamemode", (Object)"SURVIVAL");
        plugin.getPlanetsConfig().set("planets." + name + ".time_travel", (Object)false);
        plugin.getPlanetsConfig().set("planets." + name + ".world_type", (Object)worldType.toString());
        plugin.getPlanetsConfig().set("planets." + name + ".environment", (Object)environment.toString());
        plugin.getPlanetsConfig().set("planets." + name + ".spawn_chunk_radius", (Object)0);
        plugin.getPlanetsConfig().set("planets." + name + ".spawn_other_mobs", (Object)true);
        plugin.getPlanetsConfig().set("planets." + name + ".gamerules", List.of());
        plugin.getPlanetsConfig().set("planets." + name + ".allow_portals", (Object)true);
        plugin.getPlanetsConfig().set("planets." + name + ".alias", (Object)TARDISStringUtils.uppercaseFirst(name));
        plugin.getPlanetsConfig().set("planets." + name + ".icon", (Object)(switch (environment) {
            case World.Environment.NETHER -> "NETHERRACK";
            case World.Environment.THE_END -> "END_STONE";
            default -> "STONE";
        }));
        plugin.getPlanetsConfig().set("planets." + name + ".helmic_regulator_order", (Object)-1);
        if (!TARDISConstants.isTARDISPlanetExact(name)) {
            plugin.getPlanetsConfig().set("planets." + name + ".generator", (Object)(!gen.isEmpty() ? gen : "DEFAULT"));
        }
        plugin.savePlanetsConfig();
    }

    public static void unload(TARDIS plugin, CommandSender sender, World world) {
        String w = world.getName();
        plugin.getServer().unloadWorld(world, true);
        plugin.getPlanetsConfig().set("planets." + w + ".enabled", (Object)false);
        plugin.getPlanetsConfig().set("planets." + w + ".time_travel", (Object)false);
        plugin.savePlanetsConfig();
        plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_UNLOAD_SUCCESS", w);
    }

    public static void sendInfo(TARDIS plugin, Player player) {
        World world = player.getWorld();
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WORLD_INFO", world.getName());
        plugin.getMessenger().message((CommandSender)player, "Gamemode -> " + plugin.getPlanetsConfig().getString("planets." + world.getName() + ".gamemode"));
        plugin.getMessenger().message((CommandSender)player, "Environment -> " + String.valueOf(world.getEnvironment()));
        plugin.getMessenger().message((CommandSender)player, "Generator -> " + plugin.getPlanetsConfig().getString("planets." + world.getName() + ".generator"));
        plugin.getMessenger().message((CommandSender)player, "Difficulty -> " + String.valueOf(world.getDifficulty()));
        plugin.getMessenger().message((CommandSender)player, "Gamerules -> ");
        for (String s : world.getGameRules()) {
            GameRule rule = (GameRule)Registry.GAME_RULE.getOrThrow(NamespacedKey.minecraft((String)s.toLowerCase(Locale.ROOT)));
            if (rule == null) continue;
            plugin.getMessenger().message((CommandSender)player, "     " + s + " -> " + String.valueOf(world.getGameRuleValue(rule)));
        }
        plugin.getMessenger().message((CommandSender)player, "Spawn chunk radius -> " + plugin.getPlanetsConfig().getInt("planets." + world.getName() + ".spawn_chunk_radius"));
        plugin.getMessenger().message((CommandSender)player, "Time travel -> " + plugin.getPlanetsConfig().getString("planets." + world.getName() + ".time_travel"));
    }

    public static void rename(TARDIS plugin, CommandSender sender, World world, String newName) {
        String oldName = world.getName();
        List players = world.getPlayers();
        Location spawn = ((World)plugin.getServer().getWorlds().getFirst()).getSpawnLocation();
        players.forEach(p -> {
            plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "WORLD_RENAME");
            p.teleport(spawn);
        });
        plugin.getServer().unloadWorld(world, true);
        plugin.getTardisHelper().setLevelName(oldName, newName);
        ConfigurationSection section = plugin.getPlanetsConfig().getConfigurationSection("planets." + oldName);
        if (section != null) {
            Map map = section.getValues(true);
            plugin.getPlanetsConfig().set("planets." + newName, (Object)map);
            plugin.getPlanetsConfig().set("planets." + oldName, null);
            plugin.savePlanetsConfig();
        }
        new WorldLoader(plugin).loadWorld(newName);
        plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_RENAME_SUCCESS", newName);
    }

    public static void setGameMode(TARDIS plugin, CommandSender sender, String world, GameMode gm) {
        plugin.getTardisHelper().setWorldGameMode(world, gm);
        plugin.getPlanetsConfig().set("planets." + world + ".gamemode", (Object)gm.toString());
        plugin.savePlanetsConfig();
        plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_GM_SET", world, gm.toString());
    }
}

