/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import io.papermc.paper.math.BlockPosition;
import me.eccentric_nz.tardischunkgenerator.worldgen.RoomGenerator;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class TeleportUtility {
    public static void notForPlayers(Player player, World world, BlockPosition pos) {
        Location spawn = new Location(world, (double)pos.blockX(), (double)pos.blockY(), (double)pos.blockZ());
        TeleportUtility.teleport(player, spawn);
    }

    public static void teleport(Player player, World world) {
        Location spawn = world.getGenerator() instanceof RoomGenerator ? new Location(world, 8.0, 68.0, 8.0) : world.getSpawnLocation();
        TeleportUtility.teleport(player, spawn);
    }

    private static void teleport(Player player, Location spawn) {
        while (!spawn.getWorld().getChunkAt(spawn).isLoaded()) {
            spawn.getWorld().getChunkAt(spawn).load();
        }
        int highest = spawn.getBlockY();
        if (!spawn.getBlock().getType().isAir() || !spawn.getBlock().getRelative(BlockFace.UP).getType().isAir()) {
            highest = spawn.getWorld().getEnvironment() == World.Environment.NETHER ? spawn.getBlockY() : spawn.getWorld().getHighestBlockYAt(spawn) + 1;
        }
        float yaw = player.getLocation().getYaw();
        float pitch = player.getLocation().getPitch();
        spawn.setYaw(yaw);
        spawn.setPitch(pitch);
        spawn.setY((double)highest);
        player.teleport(spawn);
    }
}

