/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import com.mojang.datafixers.util.Pair;
import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TravelUtilities {
    public static int getId(TARDIS plugin, Player player) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(plugin, where, "", false);
        if (!rs.resultSet()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            return -1;
        }
        Tardis tardis = rs.getTardis();
        return tardis.getTardisId();
    }

    public static Pair<Integer, ChameleonPreset> getIdAndPreset(TARDIS plugin, Player player) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(plugin, where, "", false);
        if (!rs.resultSet()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            return null;
        }
        Tardis tardis = rs.getTardis();
        return new Pair((Object)tardis.getTardisId(), (Object)tardis.getPreset());
    }

    public static void listBiomes(TARDIS plugin, Player player) {
        StringBuilder buf = new StringBuilder();
        for (Biome b : RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME)) {
            if (b.equals((Object)Biome.THE_VOID)) continue;
            buf.append(b.getKey().getKey().toUpperCase(Locale.ROOT)).append(", ");
        }
        String b = buf.substring(0, buf.length() - 2);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOMES", b);
    }

    public static void random(TARDIS plugin, Player player, World world, int id) {
        if (world == null) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COULD_NOT_FIND_WORLD");
            return;
        }
        if (!plugin.getPlanetsConfig().getBoolean("planets." + world.getName() + ".time_travel")) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
            return;
        }
        List<String> worlds = List.of(world.getName());
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(plugin, id);
        if (rsc.resultSet()) {
            Parameters parameters = new Parameters(player, Flag.getNoMessageFlags());
            parameters.setCompass(rsc.getCurrent().direction());
            Location l = plugin.getTardisAPI().getRandomLocation(worlds, world.getEnvironment(), parameters);
            if (l != null) {
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("world", l.getWorld().getName());
                set.put("x", l.getBlockX());
                set.put("y", l.getBlockY());
                set.put("z", l.getBlockZ());
                set.put("submarine", 0);
                HashMap<String, Object> tid = new HashMap<String, Object>();
                tid.put("tardis_id", id);
                plugin.getQueryFactory().doSyncUpdate("next", set, tid);
                plugin.getMessenger().send(player, "LOC_SAVED", true);
                plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(plugin.getArtronConfig().getInt("travel"), TravelType.RANDOM));
                plugin.getTrackerKeeper().getRescue().remove(id);
                if (plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                    new TARDISLand(plugin, id, player).exitVortex();
                    plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.RANDOM, id));
                }
            }
        } else {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
        }
    }

    public static void coords(TARDIS plugin, Player player, World world, BlockPosition pos, int id) {
        if (world == null) {
            world = TravelUtilities.getCurrentWorld(plugin, player, id);
        }
        if (world == null) {
            return;
        }
        Location location = new Location(world, (double)pos.blockX(), (double)pos.blockY(), (double)pos.blockZ());
        int count = TravelUtilities.checkLocation(plugin, location, player, id);
        if (count > 0) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_SAFE");
        } else {
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("world", location.getWorld().getName());
            set.put("x", location.getBlockX());
            set.put("y", location.getBlockY());
            set.put("z", location.getBlockZ());
            set.put("submarine", 0);
            HashMap<String, Object> tid = new HashMap<String, Object>();
            tid.put("tardis_id", id);
            plugin.getQueryFactory().doSyncUpdate("next", set, tid);
            plugin.getMessenger().send(player, "LOC_SAVED", true);
            plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(plugin.getArtronConfig().getInt("travel"), TravelType.COORDINATES));
            plugin.getTrackerKeeper().getRescue().remove(id);
            if (plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                new TARDISLand(plugin, id, player).exitVortex();
                plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.COORDINATES, id));
            }
        }
    }

    private static World getCurrentWorld(TARDIS plugin, Player player, int id) {
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(plugin, id);
        if (!rsc.resultSet()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            return null;
        }
        Current current = rsc.getCurrent();
        if (current.submarine()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SUB_NO_CMD");
            return null;
        }
        World world = current.location().getWorld();
        if (!plugin.getPlanetsConfig().getBoolean("planets." + world.getName() + ".time_travel")) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
            return null;
        }
        return world;
    }

    private static int checkLocation(TARDIS plugin, Location location, Player player, int id) {
        if (location.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) && location.getY() > 127.0) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NETHER");
            return 1;
        }
        if (plugin.getTardisArea().isInExistingArea(location)) {
            plugin.getMessenger().sendColouredCommand((CommandSender)player, "TRAVEL_IN_AREA", "/tardistravel area [area name]", plugin);
            return 1;
        }
        if (!plugin.getPluginRespect().getRespect(location, new Parameters(player, Flag.getDefaultFlags()))) {
            return 1;
        }
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(plugin, id);
        if (!rsc.resultSet()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            return 1;
        }
        int[] start_loc = TARDISTimeTravel.getStartLocation(location, rsc.getCurrent().direction());
        return TARDISTimeTravel.safeLocation(start_loc[0], location.getBlockY(), start_loc[2], start_loc[1], start_loc[3], location.getWorld(), rsc.getCurrent().direction());
    }
}

