/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.ExteriorFlight;
import me.eccentric_nz.TARDIS.flight.FlightReturnData;
import me.eccentric_nz.TARDIS.rotors.TimeRotor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class StopCommand {
    private final TARDIS plugin;

    public StopCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void action(Player player, int id) {
        ItemFrame itemFrame;
        Tardis tardis;
        if (!(this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id))) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_TRAVELLING");
            return;
        }
        this.plugin.getTrackerKeeper().getMaterialising().removeAll(Collections.singleton(id));
        this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(id));
        this.plugin.getTrackerKeeper().getHadsDamage().remove(id);
        this.plugin.getTrackerKeeper().getMalfunction().remove(id);
        if (this.plugin.getTrackerKeeper().getDidDematToVortex().contains(id)) {
            this.plugin.getTrackerKeeper().getDidDematToVortex().removeAll(Collections.singleton(id));
        }
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            int taskID = this.plugin.getTrackerKeeper().getDestinationVortex().get(id);
            this.plugin.getServer().getScheduler().cancelTask(taskID);
            this.plugin.getTrackerKeeper().getDestinationVortex().remove(id);
        }
        UUID uuid = player.getUniqueId();
        if (this.plugin.getTrackerKeeper().getFlyingReturnLocation().containsKey(uuid)) {
            this.plugin.getTrackerKeeper().getStillFlyingNotReturning().remove(uuid);
            FlightReturnData frd = this.plugin.getTrackerKeeper().getFlyingReturnLocation().get(uuid);
            Entity stand = this.plugin.getServer().getEntity(frd.stand());
            if (stand != null) {
                stand.setVelocity(new Vector(0, 0, 0));
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new ExteriorFlight(this.plugin).stopFlying(player, (ArmorStand)stand));
            } else {
                for (Entity e : player.getLocation().getWorld().getNearbyEntities(player.getLocation(), 4.0, 4.0, 4.0, s -> s.getType() == EntityType.ARMOR_STAND)) {
                    if (!(e instanceof ArmorStand)) continue;
                    ArmorStand armorStand = (ArmorStand)e;
                    e.setVelocity(new Vector(0, 0, 0));
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new ExteriorFlight(this.plugin).stopFlying(player, armorStand));
                }
            }
        } else {
            HashMap<String, Object> wherehl = new HashMap<String, Object>();
            wherehl.put("tardis_id", id);
            ResultSetHomeLocation rsh = new ResultSetHomeLocation(this.plugin, wherehl);
            if (!rsh.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HOME_NOT_FOUND");
                return;
            }
            HashMap<String, Object> setlocs = new HashMap<String, Object>();
            setlocs.put("world", rsh.getWorld().getName());
            setlocs.put("x", rsh.getX());
            setlocs.put("y", rsh.getY());
            setlocs.put("z", rsh.getZ());
            setlocs.put("direction", rsh.getDirection().toString());
            setlocs.put("submarine", rsh.isSubmarine() ? 1 : 0);
            Location l = new Location(rsh.getWorld(), (double)rsh.getX(), (double)rsh.getY(), (double)rsh.getZ());
            this.plugin.getQueryFactory().updateLocations(setlocs, id);
            BuildData bd = new BuildData(uuid.toString());
            bd.setDirection(rsh.getDirection());
            bd.setLocation(l);
            bd.setMalfunction(false);
            bd.setOutside(true);
            bd.setPlayer((OfflinePlayer)player);
            bd.setRebuild(true);
            bd.setSubmarine(rsh.isSubmarine());
            bd.setTardisID(id);
            bd.setThrottle(SpaceTimeThrottle.REBUILD);
            if (!rsh.getPreset().isEmpty()) {
                HashMap<String, Object> wherep = new HashMap<String, Object>();
                wherep.put("tardis_id", id);
                HashMap<String, Object> setp = new HashMap<String, Object>();
                setp.put("chameleon_preset", rsh.getPreset());
                setp.put("adapti_on", 0);
                this.plugin.getQueryFactory().doSyncUpdate("tardis", setp, wherep);
            }
            this.plugin.getPresetBuilder().buildPreset(bd);
            HashMap<String, Object> seth = new HashMap<String, Object>();
            seth.put("handbrake_on", 1);
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("tardis_id", id);
            this.plugin.getQueryFactory().doSyncUpdate("tardis", seth, whereh);
            HashMap<String, Object> setc = new HashMap<String, Object>();
            setc.put("state", 1);
            HashMap<String, Object> wherec = new HashMap<String, Object>();
            wherec.put("tardis_id", id);
            wherec.put("control", "HANDBRAKE");
            this.plugin.getQueryFactory().doSyncUpdate("interactions", setc, wherec);
            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.STOP, id));
        }
        HashMap<String, Object> wherei = new HashMap<String, Object>();
        wherei.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wherei, "", false);
        if (rs.resultSet() && (tardis = rs.getTardis()).getRotor() != null && (itemFrame = TimeRotor.getItemFrame(tardis.getRotor())) != null) {
            int task = TimeRotor.ANIMATED_ROTORS.getOrDefault(itemFrame.getUniqueId(), -1);
            this.plugin.getServer().getScheduler().cancelTask(task);
            TimeRotor.setRotor(TimeRotor.getRotorOffModel(itemFrame), itemFrame);
        }
    }
}

