/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.SerializeInventory;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISBiomeReaderListener;
import me.eccentric_nz.TARDIS.travel.TARDISBiomeFinder;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BiomeCommand {
    private final TARDIS plugin;

    public BiomeCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void action(Player player, Biome biome, World world, int id) {
        if (!TARDISPermission.hasPermission(player, "tardis.timetravel.biome")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_PERM_BIOME");
            return;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.TELEPATHIC_CIRCUIT)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Telepathic Circuit");
            return;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true)) {
            CircuitChecker tcc = new CircuitChecker(this.plugin, id);
            tcc.getCircuits();
            if (!tcc.hasTelepathic()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TELEPATHIC_CIRCUIT");
                return;
            }
        }
        String upper = biome.getKey().getKey().toUpperCase(Locale.ROOT);
        if (this.plugin.getConfig().getBoolean("difficulty.disks") && !this.plugin.getUtils().inGracePeriod(player, false) && !upper.equals("LIST")) {
            if (this.plugin.getConfig().getBoolean("difficulty.biome_reader")) {
                boolean hasBiomeDisk = false;
                UUID uuid = player.getUniqueId();
                HashMap<String, Object> whereb = new HashMap<String, Object>();
                whereb.put("uuid", uuid.toString());
                ResultSetDiskStorage rsb = new ResultSetDiskStorage(this.plugin, whereb);
                if (rsb.resultSet()) {
                    try {
                        ItemStack[] disks1 = SerializeInventory.itemStacksFromString(rsb.getBiomesOne());
                        if (TARDISBiomeReaderListener.hasBiomeDisk(disks1, upper)) {
                            hasBiomeDisk = true;
                        } else {
                            ItemStack[] disks2 = SerializeInventory.itemStacksFromString(rsb.getBiomesTwo());
                            if (TARDISBiomeReaderListener.hasBiomeDisk(disks2, upper)) {
                                hasBiomeDisk = true;
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.plugin.debug("Could not deserialize inventory!");
                    }
                }
                if (!hasBiomeDisk) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_DISK_NOT_FOUND");
                    return;
                }
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ADV_BIOME");
                return;
            }
        }
        if (upper.equals("LIST")) {
            StringBuilder buf = new StringBuilder();
            for (Biome b : RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME)) {
                if (b.equals((Object)Biome.THE_VOID)) continue;
                buf.append(b.getKey().getKey().toUpperCase(Locale.ROOT)).append(", ");
            }
            String b = buf.substring(0, buf.length() - 2);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOMES", b);
        } else {
            World w;
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return;
            }
            Current current = rsc.getCurrent();
            if (world != null) {
                if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_FROM_VORTEX");
                    return;
                }
                planet = world.getName();
                if (TARDISConstants.isTARDISPlanet(planet)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_NOT_PLANET", planet);
                    return;
                }
                w = world;
            } else {
                planet = current.location().getWorld().getName();
                if (TARDISConstants.isTARDISPlanet(planet)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_NOT_PLANET", current.location().getWorld().getName());
                    return;
                }
                w = current.location().getWorld();
            }
            new TARDISBiomeFinder(this.plugin).run(w, upper, player, id, current.direction(), current.location());
        }
    }
}

