/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.DiskWriterCommand;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.commands.tardis.SaveLocationCommand;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisCommand;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import me.eccentric_nz.TARDIS.monitor.MonitorUtils;
import me.eccentric_nz.TARDIS.rotors.TimeRotor;
import me.eccentric_nz.TARDIS.sonic.SonicDock;
import me.eccentric_nz.TARDIS.update.TARDISUpdateableChecker;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TardisUtility {
    public static Pair<Player, Integer> check(TARDIS plugin, CommandSender sender, TardisCommand tc) {
        if (sender instanceof Player) {
            ResultSetTardisID rs = new ResultSetTardisID(plugin);
            Player player = (Player)sender;
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return null;
            }
            if (plugin.getTrackerKeeper().getInSiegeMode().contains(rs.getTardisId()) && tc.noSiege()) {
                plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CMD");
                return null;
            }
            return new Pair((Object)player, (Object)rs.getTardisId());
        }
        return null;
    }

    public static Pair<Player, Tardis> updateCheck(TARDIS plugin, CommandSender sender, TardisCommand tc) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            HashMap<String, Object> where = new HashMap<String, Object>();
            UUID uuid = TARDISSudoTracker.SUDOERS.getOrDefault(player.getUniqueId(), player.getUniqueId());
            where.put("uuid", uuid);
            ResultSetTardis rs = new ResultSetTardis(plugin, where, "", false);
            if (!rs.resultSet()) {
                plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return null;
            }
            if (plugin.getTrackerKeeper().getInSiegeMode().contains(rs.getTardis().getTardisId()) && tc.noSiege()) {
                plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CMD");
                return null;
            }
            return new Pair((Object)player, (Object)rs.getTardis());
        }
        return null;
    }

    public static void doSave(TARDIS plugin, Player player, String name, boolean preset) {
        if (plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(plugin).has(player.getUniqueId().toString(), SystemTree.SAVES)) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Saves");
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack.getType().equals((Object)Material.MUSIC_DISC_FAR)) {
            new DiskWriterCommand(plugin).writeSaveToControlDisk(player, name);
        } else if (plugin.getConfig().getBoolean("difficulty.disks") && !plugin.getUtils().inGracePeriod(player, true)) {
            if (plugin.getConfig().getBoolean("difficulty.disk_in_hand_for_write") && TardisUtility.heldDiskIsWrong(itemStack, "Save Storage Disk")) {
                plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_HAND_SAVE");
                return;
            }
            new DiskWriterCommand(plugin).writeSave(player, name);
        } else {
            new SaveLocationCommand(plugin).doSave(player, name, preset);
        }
    }

    public static boolean heldDiskIsWrong(ItemStack is, String dn) {
        boolean complexBool = false;
        if (is == null) {
            complexBool = true;
        } else if (!is.hasItemMeta()) {
            complexBool = true;
        } else if (!is.getItemMeta().hasDisplayName()) {
            complexBool = true;
        } else if (!ComponentUtils.endsWith(is.getItemMeta().displayName(), dn)) {
            complexBool = true;
        }
        return complexBool;
    }

    public static void update(TARDIS plugin, Player player, Updateable updateable, Tardis tardis) {
        String tardis_block;
        Block block;
        if (updateable.equals((Object)Updateable.STORAGE) && ((block = player.getTargetBlock(plugin.getGeneralKeeper().getTransparent(), 10)).getType().equals((Object)Material.NOTE_BLOCK) || block.getType().equals((Object)Material.MUSHROOM_STEM))) {
            block.setBlockData(TARDISConstants.BARRIER, true);
            TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.DISK_STORAGE, block, tardis.getTardisId());
        }
        if (new TARDISUpdateableChecker(plugin, updateable, player, tardis, tardis_block = updateable.toString()).canUpdate()) {
            plugin.getTrackerKeeper().getUpdatePlayers().put(player.getUniqueId(), tardis_block);
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_CLICK", tardis_block);
            if (updateable.equals((Object)Updateable.DIRECTION)) {
                plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HOOK_REMIND");
            }
        }
    }

    public static void unlock(TARDIS plugin, Player player, Updateable updateable, Tardis tardis) {
        ItemFrame itemFrame = null;
        switch (updateable) {
            case ROTOR: {
                itemFrame = TimeRotor.getItemFrame(tardis.getRotor());
                break;
            }
            case MONITOR: {
                itemFrame = MonitorUtils.getItemFrameFromLocation(tardis.getTardisId(), true);
                break;
            }
            case MONITOR_FRAME: {
                itemFrame = MonitorUtils.getItemFrameFromLocation(tardis.getTardisId(), false);
                ItemStack glass = itemFrame.getItem();
                ItemMeta im = glass.getItemMeta();
                im.displayName((Component)ComponentUtils.toWhite("Monitor Frame"));
                glass.setItemMeta(im);
                break;
            }
            case SONIC_DOCK: {
                itemFrame = SonicDock.getItemFrame(tardis.getTardisId());
            }
        }
        if (itemFrame != null) {
            TimeRotor.unlockItemFrame(itemFrame);
            plugin.getGeneralKeeper().getTimeRotors().remove(itemFrame.getUniqueId());
            Block block = itemFrame.getLocation().getBlock();
            String location = block.getLocation().toString();
            plugin.getGeneralKeeper().getProtectBlockMap().remove(location);
            String under = block.getRelative(BlockFace.DOWN).getLocation().toString();
            plugin.getGeneralKeeper().getProtectBlockMap().remove(under);
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROTOR_UNFIXED");
        }
    }
}

