/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetHomeCommand {
    private final TARDIS plugin;

    public SetHomeCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void setHome(Player player, String p, String t) {
        if (TARDISPermission.hasPermission(player, "tardis.timetravel")) {
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return;
            }
            int id = rs.getTardisId();
            if (p.equalsIgnoreCase("preset")) {
                String which;
                if (this.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false).contains(t)) {
                    which = t;
                } else {
                    try {
                        which = t.toUpperCase(Locale.ROOT);
                        ChameleonPreset.valueOf(which);
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_PRESET");
                        return;
                    }
                }
                if (!which.isEmpty()) {
                    HashMap<String, Object> whereh = new HashMap<String, Object>();
                    whereh.put("tardis_id", id);
                    HashMap<String, Object> seth = new HashMap<String, Object>();
                    seth.put("preset", which);
                    this.plugin.getQueryFactory().doUpdate("homes", seth, whereh);
                    this.plugin.getMessenger().sendInsertedColour((CommandSender)player, "CHAM_SET", which, this.plugin);
                }
            } else {
                Location eyeLocation = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 50).getLocation();
                String world = eyeLocation.getWorld().getName();
                COMPASS player_d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
                if (!this.plugin.getConfig().getBoolean("travel.include_default_world") && this.plugin.getConfig().getBoolean("creation.default_world") && world.equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                    return;
                }
                if (this.plugin.getTardisArea().isInExistingArea(eyeLocation)) {
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NO_HOME", "/tardistravel area [area name]", this.plugin);
                    return;
                }
                if (!this.plugin.getPluginRespect().getRespect(eyeLocation, new Parameters(player, Flag.getDefaultFlags()))) {
                    return;
                }
                Material m = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 50).getType();
                if (m != Material.SNOW) {
                    int yplusone = eyeLocation.getBlockY();
                    eyeLocation.setY((double)(yplusone + 1));
                }
                if (!this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".time_travel")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                    return;
                }
                CircuitChecker tcc = null;
                if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, false)) {
                    tcc = new CircuitChecker(this.plugin, id);
                    tcc.getCircuits();
                }
                if (tcc != null && !tcc.hasMemory()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MEM_CIRCUIT");
                    return;
                }
                HashMap<String, Object> wherettrav = new HashMap<String, Object>();
                wherettrav.put("uuid", player.getUniqueId().toString());
                wherettrav.put("tardis_id", id);
                ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherettrav, false);
                if (rst.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_NO_INSIDE");
                    return;
                }
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("world", eyeLocation.getWorld().getName());
                where.put("x", eyeLocation.getBlockX());
                where.put("y", eyeLocation.getBlockY());
                where.put("z", eyeLocation.getBlockZ());
                ResultSetHomeLocation rsh = new ResultSetHomeLocation(this.plugin, where);
                if (rsh.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_NO_HOME");
                    return;
                }
                HashMap<String, Object> tid = new HashMap<String, Object>();
                HashMap<String, Object> set = new HashMap<String, Object>();
                tid.put("tardis_id", id);
                set.put("world", eyeLocation.getWorld().getName());
                set.put("x", eyeLocation.getBlockX());
                set.put("y", eyeLocation.getBlockY());
                set.put("z", eyeLocation.getBlockZ());
                set.put("direction", player_d.toString());
                set.put("submarine", this.isSub(eyeLocation) ? 1 : 0);
                this.plugin.getQueryFactory().doUpdate("homes", set, tid);
                this.plugin.getMessenger().sendStatus(player, "HOME_SET");
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        }
    }

    private boolean isSub(Location l) {
        return l.getBlock().getType().equals((Object)Material.WATER);
    }
}

