/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class SaveLocationCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_]{2,16}");
    private final TARDIS plugin;

    SaveLocationCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    void doSave(Player player, String name, boolean preset) {
        if (TARDISPermission.hasPermission(player, "tardis.save")) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return;
            }
            if (!LETTERS_NUMBERS.matcher(name).matches()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NAME_NOT_VALID");
            } else if (name.equalsIgnoreCase("hide") || name.equalsIgnoreCase("rebuild") || name.equalsIgnoreCase("home")) {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "SAVE_RESERVED", "/tardis home", this.plugin);
            } else {
                Tardis tardis = rs.getTardis();
                int id = tardis.getTardisId();
                CircuitChecker tcc = null;
                if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, false)) {
                    tcc = new CircuitChecker(this.plugin, id);
                    tcc.getCircuits();
                }
                if (tcc != null && !tcc.hasMemory()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MEM_CIRCUIT");
                    return;
                }
                HashMap<String, Object> wherename = new HashMap<String, Object>();
                wherename.put("tardis_id", id);
                wherename.put("dest_name", name);
                wherename.put("type", 0);
                ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, wherename, false);
                if (rsd.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_EXISTS");
                    return;
                }
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (!rsc.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                    return;
                }
                Current current = rsc.getCurrent();
                String w = current.location().getWorld().getName();
                if (w.startsWith("TARDIS_")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NO_TARDIS");
                    return;
                }
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("tardis_id", id);
                set.put("dest_name", name);
                set.put("world", w);
                set.put("x", current.location().getBlockX());
                set.put("y", current.location().getBlockY());
                set.put("z", current.location().getBlockZ());
                set.put("direction", current.direction().toString());
                set.put("submarine", current.submarine() ? 1 : 0);
                if (preset) {
                    set.put("preset", tardis.getPreset().toString());
                }
                if (this.plugin.getQueryFactory().doSyncInsert("destinations", set) >= 0) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_SET", name);
                }
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        }
    }
}

