/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPowered;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TARDISRescue;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class RescueCommand {
    private final TARDIS plugin;

    public RescueCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void startRescue(Player player, Player saved) {
        if (TARDISPermission.hasPermission(player, "tardis.timetravel.rescue")) {
            ResultSetTardisPowered rs = new ResultSetTardisPowered(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return;
            }
            if (this.plugin.getConfig().getBoolean("allow.power_down") && !rs.isPowered()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                return;
            }
            if (saved == null) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ONLINE");
                return;
            }
            UUID savedUUID = saved.getUniqueId();
            String who = this.plugin.getTrackerKeeper().getTelepathicRescue().containsKey(savedUUID) ? this.plugin.getServer().getPlayer(this.plugin.getTrackerKeeper().getTelepathicRescue().get(savedUUID)).getName() : player.getName();
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, saved.getUniqueId().toString());
            if (rsp.resultSet() && rsp.isAutoRescueOn()) {
                TARDISRescue res = new TARDISRescue(this.plugin);
                this.plugin.getTrackerKeeper().getChatRescue().remove(savedUUID);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    TARDISRescue.RescueData rd = res.tryRescue(player, saved.getUniqueId(), false);
                    if (rd.success()) {
                        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(rd.getTardis_id())) {
                            new TARDISLand(this.plugin, rd.getTardis_id(), player).exitVortex();
                            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.RESCUE, rd.getTardis_id()));
                        } else {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "REQUEST_RELEASE", saved.getName());
                        }
                    }
                }, 2L);
            } else {
                this.plugin.getMessenger().send((CommandSender)saved, TardisModule.TARDIS, "RESCUE_REQUEST", who);
                this.plugin.getMessenger().sendRescue((CommandSender)saved, this.plugin);
                this.plugin.getTrackerKeeper().getChatRescue().put(savedUUID, player.getUniqueId());
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    if (this.plugin.getTrackerKeeper().getChatRescue().containsKey(savedUUID)) {
                        this.plugin.getTrackerKeeper().getChatRescue().remove(savedUUID);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RESCUE_NO_RESPONSE", saved.getName());
                    }
                }, 1200L);
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_PLAYER");
        }
    }
}

