/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RenameSavedLocationCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_]{2,16}");
    private final TARDIS plugin;

    public RenameSavedLocationCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void doRenameSave(Player player, String oldName, String newName) {
        if (TARDISPermission.hasPermission(player, "tardis.save")) {
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return;
            }
            int id = rs.getTardisId();
            HashMap<String, Object> whered = new HashMap<String, Object>();
            whered.put("dest_name", oldName);
            whered.put("tardis_id", id);
            ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, whered, false);
            if (!rsd.resultSet()) {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "SAVE_NOT_FOUND", "/tardis list saves", this.plugin);
                return;
            }
            if (!LETTERS_NUMBERS.matcher(newName).matches()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NAME_NOT_VALID");
            } else if (newName.equalsIgnoreCase("hide") || oldName.equalsIgnoreCase("rebuild") || oldName.equalsIgnoreCase("home")) {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "SAVE_RESERVED", "/tardis home", this.plugin);
            } else {
                int destID = rsd.getDest_id();
                HashMap<String, Object> did = new HashMap<String, Object>();
                did.put("dest_id", destID);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("dest_name", newName);
                this.plugin.getQueryFactory().doUpdate("destinations", set, did);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DEST_RENAMED", newName);
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        }
    }
}

