/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RemoveCompanionCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_*.]{2,16}");
    private final TARDIS plugin;

    public RemoveCompanionCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doRemoveCompanion(Player player, String p) {
        if (!TARDISPermission.hasPermission(player, "tardis.add")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            return;
        }
        Tardis tardis = rs.getTardis();
        String comps = tardis.getCompanions();
        if (comps == null || comps.isEmpty()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COMPANIONS_NONE");
            return;
        }
        int id = tardis.getTardisId();
        String data = tardis.getChunk();
        String owner = tardis.getOwner();
        if (!LETTERS_NUMBERS.matcher(p).matches()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLAYER_NOT_VALID");
            return;
        }
        String newList = "";
        String message = "COMPANIONS_REMOVE_ALL";
        if (!p.equals("all")) {
            World w;
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)p);
            if (offlinePlayer.getName() == null) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                return;
            }
            UUID oluuid = offlinePlayer.getUniqueId();
            String[] split = comps.split(":");
            StringBuilder sb = new StringBuilder();
            if (split.length > 1) {
                for (String c : split) {
                    if (c.equals(oluuid.toString())) continue;
                    sb.append(c).append(":");
                }
                if (!sb.isEmpty()) {
                    newList = sb.substring(0, sb.length() - 1);
                }
            }
            message = "COMPANIONS_REMOVE_ONE";
            if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && (w = TARDISStaticLocationGetters.getWorldFromSplitString(data)) != null) {
                this.plugin.getWorldGuardUtils().removeMemberFromRegion(w, owner, oluuid);
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message, p);
        } else {
            World w;
            if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && (w = TARDISStaticLocationGetters.getWorldFromSplitString(data)) != null && p.equals("all")) {
                this.plugin.getWorldGuardUtils().removeAllMembersFromRegion(w, owner, player.getUniqueId());
                this.plugin.getWorldGuardUtils().setEntryExitFlags(w.getName(), player.getName(), false);
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message);
        }
        HashMap<String, Object> tid = new HashMap<String, Object>();
        HashMap<String, Object> set = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        set.put("companions", newList);
        this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
    }
}

