/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetChunks;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MonstersCommand {
    private final TARDIS plugin;

    public MonstersCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void reset(Player player, int id, String arg) {
        if (arg.equalsIgnoreCase("reset")) {
            Location l = null;
            for (Map.Entry<Location, TARDISTeleportLocation> map : this.plugin.getTrackerKeeper().getPortals().entrySet()) {
                if (map.getKey().getWorld().getName().contains("TARDIS") || map.getValue().getTardisId() != id) continue;
                l = map.getKey();
                break;
            }
            if (l != null) {
                this.plugin.getTrackerKeeper().getPortals().remove(l);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PORTAL_RESET");
            }
        } else if (arg.equalsIgnoreCase("kill")) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetChunks rsc = new ResultSetChunks(this.plugin, where, true);
            if (rsc.resultSet()) {
                World world = this.plugin.getServer().getWorld(rsc.getWorld());
                for (HashMap<String, String> map : rsc.getData()) {
                    int x = TARDISNumberParsers.parseInt(map.get("x"));
                    int z = TARDISNumberParsers.parseInt(map.get("z"));
                    Chunk chunk = world.getChunkAt(x, z);
                    while (!chunk.isLoaded()) {
                        chunk.load();
                    }
                    for (Entity entity : chunk.getEntities()) {
                        if (!(entity instanceof Enemy)) continue;
                        entity.remove();
                    }
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "MONSTERS_RESET");
            }
        }
    }
}

