/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.CircuitDamager;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MakeHerBlueCommand {
    private final TARDIS plugin;

    public MakeHerBlueCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void show(Player player) {
        int rebuild;
        if (!this.plugin.getConfig().getBoolean("allow.invisibility")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INVISIBILITY_DISABLED");
            return;
        }
        UUID uuid = player.getUniqueId();
        if (this.plugin.getTrackerKeeper().getRebuildCooldown().containsKey(uuid)) {
            long now = System.currentTimeMillis();
            long cooldown = this.plugin.getConfig().getLong("police_box.rebuild_cooldown");
            long then = this.plugin.getTrackerKeeper().getRebuildCooldown().get(uuid) + cooldown;
            if (now < then) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "COOLDOWN", String.format("%d", cooldown / 1000L));
                return;
            }
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NO_TARDIS");
            return;
        }
        Tardis tardis = rs.getTardis();
        if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "POWER_DOWN");
            return;
        }
        if (!tardis.getPreset().equals((Object)ChameleonPreset.INVISIBLE) && !tardis.getPreset().equals((Object)ChameleonPreset.JUNK_MODE)) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "INVISIBILITY_NOT");
            return;
        }
        int id = tardis.getTardisId();
        CircuitChecker tcc = new CircuitChecker(this.plugin, id);
        tcc.getCircuits();
        if (this.plugin.getConfig().getBoolean("difficulty.circuits")) {
            if (!tcc.hasInvisibility() && !tardis.getPreset().equals((Object)ChameleonPreset.JUNK_MODE)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "INVISIBILITY_MISSING");
                return;
            }
            if (!tcc.hasMaterialisation()) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NO_MAT_CIRCUIT");
                return;
            }
        }
        if (this.plugin.getConfig().getBoolean("circuits.damage")) {
            int uses_left;
            if (this.plugin.getConfig().getInt("circuits.uses.invisibility") > 0) {
                uses_left = tcc.getInvisibilityUses();
                new CircuitDamager(this.plugin, DiskCircuit.INVISIBILITY, uses_left, id, player).damage();
            }
            if (this.plugin.getConfig().getInt("circuits.uses.materialisation") > 0) {
                uses_left = tcc.getMaterialisationUses();
                new CircuitDamager(this.plugin, DiskCircuit.MATERIALISATION, uses_left, id, player).damage();
            }
        }
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_IN_VORTEX");
            return;
        }
        if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_MAT");
            return;
        }
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            this.plugin.getMessenger().sendColouredCommand((CommandSender)player.getPlayer(), "REBUILD_FAIL", "/tardis come_here", this.plugin);
            return;
        }
        int level = tardis.getArtronLevel();
        if (level < (rebuild = this.plugin.getArtronConfig().getInt("random"))) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "ENERGY_NO_REBUILD");
            return;
        }
        this.plugin.getTrackerKeeper().getRebuildCooldown().put(uuid, System.currentTimeMillis());
        HashMap<String, Object> wherep = new HashMap<String, Object>();
        wherep.put("tardis_id", id);
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("chameleon_preset", "POLICE_BOX_BLUE");
        this.plugin.getQueryFactory().doUpdate("tardis", set, wherep);
        Current current = rsc.getCurrent();
        BuildData bd = new BuildData(uuid.toString());
        bd.setDirection(current.direction());
        bd.setLocation(current.location());
        bd.setMalfunction(false);
        bd.setOutside(false);
        bd.setPlayer((OfflinePlayer)player);
        bd.setRebuild(true);
        bd.setSubmarine(current.submarine());
        bd.setTardisID(id);
        bd.setThrottle(SpaceTimeThrottle.REBUILD);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), 20L);
        String message = tardis.getPreset().equals((Object)ChameleonPreset.JUNK_MODE) ? "JUNK_PRESET_OFF" : "INVISIBILITY_REMOVED";
        this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, message);
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("tardis_id", id);
        this.plugin.getQueryFactory().alterEnergyLevel("tardis", -rebuild, wheret, player.getPlayer());
    }
}

